/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.interfaces.message.ISharedAddressBookNotification;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.CenteredDialog;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class InstallSharedABDialog
extends CenteredDialog {
    private static Logger logger = Logger.getLogger(InstallSharedABDialog.class);
    private SharedAddressBookNotificationItem notification;
    private JPanel pnlContent = new OrientablePanel(new GridBagLayout());

    public InstallSharedABDialog(Frame owner, SharedAddressBookNotificationItem theNotification) {
        super(owner, true);
        this.notification = theNotification;
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.INSTALL_SHARED_ADDRESS_BOOK);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.buildContentPane();
        contentPane.add((Component)this.pnlContent, "Center");
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)new OrientableLabel(ImageResources.INSTALL_SHARED_AB), "Center");
        pnlTemp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        contentPane.add((Component)pnlTemp, "Before");
        this.buildBottomPane(contentPane);
    }

    private void buildBottomPane(Container contentPane) {
        OrientablePanel pnlButtons = new OrientablePanel(new FlowLayout(4, 5, 5));
        JButton btnAccept = new JButton(new ActionAccept());
        JButton btnDecline = new JButton(new ActionDecline());
        JButton btnCancel = new JButton(new ActionCancel());
        this.setDefaultButton(btnAccept);
        this.setCancelButton(btnCancel);
        if (OS.isMacOS()) {
            pnlButtons.add(btnCancel);
            pnlButtons.add(btnDecline);
            pnlButtons.add(btnAccept);
        } else {
            pnlButtons.add(btnAccept);
            pnlButtons.add(btnDecline);
            pnlButtons.add(btnCancel);
        }
        OrientablePanel pnlBottom = new OrientablePanel(new BorderLayout());
        OrientableLabel lbBorder = new OrientableLabel();
        lbBorder.setBorder(BorderFactory.createEtchedBorder());
        pnlBottom.add((Component)lbBorder, "North");
        pnlBottom.add((Component)pnlButtons, "South");
        pnlBottom.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        contentPane.add((Component)pnlBottom, "South");
    }

    private void buildContentPane() {
        this.pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 21;
        constraints.insets = new Insets(12, 0, 5, 0);
        String text = StringResources.formatString(StringResources.SHARING_OF_ADDRESS_BOOK, ((ISharedAddressBookNotification)this.notification.getNativeItem()).getAddressBookName());
        this.pnlContent.add((Component)new OrientableLabel(text), constraints);
        this.pnlContent.add((Component)new OrientableLabel(StringResources.TO_INSTALL_THIS_ADDRESS_BOOK), constraints);
        constraints.anchor = 21;
        constraints.insets.bottom = 0;
        constraints.insets.top = 20;
        text = StringResources.formatString(StringResources.MESSAGE_FROM_PC, this.notification.getSender().getDisplayText());
        this.pnlContent.add((Component)new OrientableLabel(text), constraints);
        GWTextArea taMessage = new GWTextArea(6, 1);
        ((JTextComponent)taMessage).setEditable(false);
        taMessage.setBackground(this.pnlContent.getBackground());
        ((JTextComponent)taMessage).setText(this.notification.getMessage().getPlainText());
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets.bottom = 5;
        constraints.insets.top = 3;
        OrientableScrollPane scroll = new OrientableScrollPane(taMessage);
        scroll.setVerticalScrollBarPolicy(22);
        constraints.weighty = 1.0;
        this.pnlContent.add((Component)scroll, constraints);
        constraints.weighty = 0.0;
        constraints.insets.top = 5;
        constraints.fill = 0;
        this.pnlContent.add((Component)new OrientableLabel(StringResources.YOU_HAVE_BEEN_GRANTED), constraints);
        constraints.weighty = 1.0;
        constraints.anchor = 23;
        this.pnlContent.add((Component)new OrientableLabel(this.notification.getTextGrantedRights()), constraints);
    }

    class ActionDecline
    extends AbstractAction {
        public ActionDecline() {
            super(StringResources.DECLINE);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                InstallSharedABDialog.this.dispose();
                String userGuid = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(ApplicationFrame.class, InstallSharedABDialog.this)).getUserGuid();
                GWCommandManager.getInstance(userGuid).rejectSharedAddressBook(InstallSharedABDialog.this.notification);
            }
            catch (GWCommandException e1) {
                logger.error((Object)e1);
                logger.debug((Object)e1, (Throwable)e1);
            }
        }
    }

    class ActionCancel
    extends AbstractAction {
        public ActionCancel() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            InstallSharedABDialog.this.dispose();
        }
    }

    class ActionAccept
    extends AbstractAction {
        public ActionAccept() {
            super(StringResources.ACCEPT);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                InstallSharedABDialog.this.dispose();
                String userGuid = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(ApplicationFrame.class, InstallSharedABDialog.this)).getUserGuid();
                GWCommandManager.getInstance(userGuid).acceptSharedAddressBook(InstallSharedABDialog.this.notification);
            }
            catch (GWCommandException e1) {
                logger.error((Object)e1);
                logger.debug((Object)e1, (Throwable)e1);
            }
        }
    }
}

