/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.Application;
import com.appframework.components.AbstractOKAction;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IAddressBookItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IOrganizationContact;
import com.novell.gw.jclient.api.interfaces.ab.IResourceContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.Savable;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GroupContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.OrganizationContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ResourceContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsDialog;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.dialogs.SaveableDialog;
import com.novell.gw.jclient.application.dialogs.categories.CategoriesEditDialog;
import com.novell.gw.jclient.application.frames.options.compose.send.SelectCategoryControl;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.FrequentContactsAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class ContactDetailsDialog
extends SaveableDialog
implements Savable {
    private static Logger logger = Logger.getLogger(UserContactDetailsDialog.class);
    private JTabbedPane tabContent = new OrientableTabbedPane();
    private SelectCategoryControl categoryChooser;
    private OrientableButton btnCategory;
    protected IContact contact;
    protected boolean readOnly;
    protected boolean canEditCategories = false;
    private ContactDetailsPane[] panes;
    protected AbstractAddressBook addressBook;
    protected String optionDialogName;
    protected int defaultWidth;
    protected int defaultHeight;
    private boolean centered;
    private Window parentWindow;
    private IAddressBookItemList itemList;

    protected ContactDetailsDialog(JFrame theParent, IContact theContact, IAddressBookItemList itemList) {
        super(theParent, true);
        this.setDefaultCloseOperation(0);
        this.setParent(theParent);
        this.init(theContact, itemList);
    }

    protected ContactDetailsDialog(JDialog theParent, IContact theContact, IAddressBookItemList itemList) {
        super(theParent, true);
        this.setDefaultCloseOperation(0);
        this.setParent(theParent);
        this.init(theContact, itemList);
    }

    protected ContactDetailsDialog(JFrame theParent, AbstractAddressBook theAddressBook, IAddressBookItemList itemList, ContactType contactType) {
        super(theParent, true);
        this.setDefaultCloseOperation(0);
        this.setParent(theParent);
        this.init(theAddressBook, contactType, itemList);
    }

    protected ContactDetailsDialog(JDialog theParent, AbstractAddressBook theAddressBook, IAddressBookItemList itemList, ContactType contactType) {
        super(theParent, true);
        this.setDefaultCloseOperation(0);
        this.setParent(theParent);
        this.init(theAddressBook, contactType, itemList);
    }

    private void init(AbstractAddressBook theAddressBook, ContactType contactType, IAddressBookItemList itemList) {
        this.contact = GWEngineUtils.createContact((PersonalAddressBook)theAddressBook, contactType);
        this.addressBook = theAddressBook;
        this.itemList = itemList;
    }

    private void init(IContact theContact, IAddressBookItemList itemList) {
        this.setTitle(theContact.getDisplayName() + " (" + theContact.getBookName() + ')');
        this.addressBook = EngineCommandManager.getContactAddressBook(theContact);
        this.contact = theContact;
        this.itemList = itemList;
    }

    public void show() {
        if (this.centered) {
            UIUtils.centerWindow((Window)this, (Window)this.getParent());
        }
        super.show();
    }

    void init(ContactDetailsPane[] thePanes) {
        this.panes = thePanes;
        this.readOnly = this.contact.isReadOnly();
        this.canEditCategories = CategoryUtils.canEditCategories(this.contact);
        ActionEditSendOptionsCategories categoryAction = new ActionEditSendOptionsCategories();
        String userGuid = EngineCommandManager.getUserGuid();
        this.categoryChooser = new SelectCategoryControl(this.contact.getCategories(), userGuid);
        this.categoryChooser.setEnabled(this.canEditCategories);
        this.btnCategory = new OrientableButton(categoryAction);
        categoryAction.setEnabled(this.canEditCategories);
        this.buildUI();
        this.loadProperties();
        if (this.readOnly) {
            ContactDetailsPane.disableAllComponents(this.tabContent);
        }
        if (this.optionDialogName == null) {
            throw new NullPointerException();
        }
    }

    public boolean loadProperties() {
        int nCount = this.panes.length;
        boolean result = true;
        for (int i = 0; i < nCount; ++i) {
            result &= this.panes[i].loadProperties();
        }
        return result;
    }

    public boolean saveProperties() {
        int nCount = this.panes.length;
        boolean result = true;
        for (int i = 0; i < nCount; ++i) {
            result &= this.panes[i].saveProperties();
        }
        return result;
    }

    private void writeContactCategories() {
        IItem[] items = new IItem[]{this.contact};
        ICategoryList newCategories = this.categoryChooser.getCategories();
        ICategoryList oldCategories = this.contact.getCategories();
        ICategoryList categories = CategoryUtils.createValidCategoryList(oldCategories, newCategories);
        this.contact.setCategories(categories);
        if (this.itemList != null) {
            this.itemList.setCategories(categories, items);
        }
    }

    void buildUI() {
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel downPanel = new JPanel(new BorderLayout(5, 0));
        JPanel categoryPanel = new JPanel(new BorderLayout(2, 0));
        contentPane.setLayout(new BorderLayout());
        for (ContactDetailsPane pane : this.panes) {
            this.tabContent.addTab(pane.getName(), null, pane);
        }
        contentPane.add((Component)this.tabContent, "Center");
        FlowLayout layout = new FlowLayout(4);
        OrientablePanel buttonPanel = new OrientablePanel(layout);
        if (OS.isMacOS()) {
            EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 16);
            buttonPanel.setBorder(emptyBorder);
        }
        this.addWindowListener(new ContactDetailsDialogAdapter());
        this.btnOK = new OrientableButton(new OkAction());
        this.btnCancel = new OrientableButton(new CancelAction());
        this.btnCancel.setText(StringResources.CANCEL);
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        if (this.readOnly) {
            this.btnCancel.setText(StringResources.CLOSE);
            buttonPanel.add(this.btnCancel);
        } else {
            OS.addButtons(buttonPanel, this.btnOK, this.btnCancel);
        }
        categoryPanel.add((Component)this.btnCategory, "Before");
        categoryPanel.add((Component)this.categoryChooser, "After");
        categoryPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        downPanel.add((Component)buttonPanel, "After");
        downPanel.add((Component)categoryPanel, "Before");
        contentPane.add((Component)downPanel, "South");
    }

    protected boolean save() {
        boolean success;
        block10: {
            IContact contact = this.contact;
            success = false;
            this.saveProperties();
            String name = contact.getDisplayName();
            if (name != null && name.length() > 0) {
                try {
                    if (this.canEditCategories) {
                        this.writeContactCategories();
                    }
                    this.contact.save(0);
                    success = true;
                }
                catch (EngineException e1) {
                    if (e1.getErrorCode() == 59142) {
                        String errPrompt;
                        String string = errPrompt = contact instanceof IGroupContact ? StringResources.A_GROUP_WITH_THE_SAME_NAME : StringResources.AN_ENTRY_WITH_THE_SAME_NAME;
                        if (0 == JOptionPane.showConfirmDialog(this, errPrompt, StringResources.ADDRESS_BOOK_K_QUESTION, 0)) {
                            try {
                                int dupAction = contact instanceof IGroupContact ? 2 : 1;
                                this.contact.save(dupAction);
                                success = true;
                            }
                            catch (EngineException e2) {
                                logger.error((Object)e1);
                                logger.debug((Object)e1, (Throwable)e1);
                            }
                        }
                        break block10;
                    }
                    logger.error((Object)e1);
                    logger.debug((Object)e1, (Throwable)e1);
                }
            } else {
                JOptionPane.showMessageDialog(this, StringResources.YOU_MUST_ENTER_A_DISPLAY_NAME, StringResources.ERROR, 1);
            }
        }
        if (success) {
            this.getController().processCommand(new GlobalCommand(1190, this.addressBook));
        }
        return success;
    }

    public IContact getContact() {
        return this.contact;
    }

    public void closeDialogAction(AWTEvent event) {
        if (this.isChangedProperties() && event instanceof WindowEvent) {
            int option = JOptionPane.showConfirmDialog(this, StringResources.Q_SAVE_CHANGES, StringResources.NOVELL_GROUPWISE, 1);
            if (option == 0) {
                if (this.save()) {
                    this.setActionCompleteSuccessfully(true);
                }
                this.dispose();
            }
            if (option == 1) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    public boolean isChangedProperties() {
        for (ContactDetailsPane savable : this.panes) {
            if (!savable.isChangedProperties()) continue;
            return true;
        }
        return false;
    }

    public static ContactDetailsDialog createContactDetailsDialog(Window owner, IAddressable theContact, IAddressBookItemList itemList) {
        ContactDetailsDialog dialog;
        if (theContact instanceof IUserContact) {
            dialog = owner instanceof JDialog ? new UserContactDetailsDialog((JDialog)owner, (IUserContact)theContact, itemList) : new UserContactDetailsDialog((JFrame)owner, (IUserContact)theContact, itemList);
        } else if (theContact instanceof IResourceContact) {
            dialog = owner instanceof JDialog ? new ResourceContactDetailsDialog((JDialog)owner, (IResourceContact)theContact, itemList) : new ResourceContactDetailsDialog((JFrame)owner, (IResourceContact)theContact, itemList);
        } else if (theContact instanceof IOrganizationContact) {
            dialog = owner instanceof JDialog ? new OrganizationContactDetailsDialog((JDialog)owner, (IOrganizationContact)theContact, itemList) : new OrganizationContactDetailsDialog((JFrame)owner, (IOrganizationContact)theContact, itemList);
        } else if (theContact instanceof IGroupContact) {
            dialog = owner instanceof JDialog ? new GroupContactDetailsDialog((JDialog)owner, (IGroupContact)theContact, itemList) : new GroupContactDetailsDialog((JFrame)owner, (IGroupContact)theContact, itemList);
        } else if (theContact instanceof IAddress) {
            FrequentContactsAddressBook addressBook = EngineCommandManager.getFrequentContactsAddressBook();
            dialog = owner instanceof JDialog ? new UserContactDetailsDialog((JDialog)owner, (AbstractAddressBook)addressBook, itemList, (IAddress)theContact) : new UserContactDetailsDialog((JFrame)owner, (AbstractAddressBook)addressBook, itemList, (IAddress)theContact);
        } else {
            throw new IllegalArgumentException("Unknown Contact type");
        }
        return dialog;
    }

    public static ContactDetailsDialog createContactDetailsDialog(Window owner, AbstractAddressBook addressBook, ContactType contactType) {
        ContactDetailsDialog dialog;
        switch (contactType) {
            case USER: {
                if (owner instanceof JDialog) {
                    dialog = new UserContactDetailsDialog((JDialog)owner, addressBook, null);
                    break;
                }
                dialog = new UserContactDetailsDialog((JFrame)owner, addressBook, null);
                break;
            }
            case RESOURCE: {
                if (owner instanceof JDialog) {
                    dialog = new ResourceContactDetailsDialog((JDialog)owner, addressBook, null);
                    break;
                }
                dialog = new ResourceContactDetailsDialog((JFrame)owner, addressBook, null);
                break;
            }
            case ORGANIZATION: {
                if (owner instanceof JDialog) {
                    dialog = new OrganizationContactDetailsDialog((JDialog)owner, addressBook, null);
                    break;
                }
                dialog = new OrganizationContactDetailsDialog((JFrame)owner, addressBook, null);
                break;
            }
            case GROUP: {
                if (owner instanceof JDialog) {
                    dialog = new GroupContactDetailsDialog((JDialog)owner, addressBook, null);
                    break;
                }
                dialog = new GroupContactDetailsDialog((JFrame)owner, addressBook, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Contact type");
            }
        }
        return dialog;
    }

    public MVCController getController() {
        return ControlsUtils.findClosestController(this.parentWindow);
    }

    private void setParent(Window parent) {
        assert (parent != null);
        this.parentWindow = parent;
    }

    class ContactDetailsDialogAdapter
    extends WindowAdapter {
        ContactDetailsDialogAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            ContactDetailsDialog.this.closeDialogAction(e);
        }

        public void windowClosed(WindowEvent e) {
            super.windowClosed(e);
        }
    }

    private class ActionEditSendOptionsCategories
    extends AbstractAction {
        public ActionEditSendOptionsCategories() {
            super(StringResources.EDIT_CATEGORIES);
        }

        public void setCategories(ICategoryList categories) {
            if (categories != null) {
                ContactDetailsDialog.this.categoryChooser.setCategories(categories);
            }
        }

        public ICategoryList getCategories() {
            return ContactDetailsDialog.this.categoryChooser.getCategories();
        }

        public void actionPerformed(ActionEvent e) {
            Window ownerWindow;
            for (ownerWindow = ContactDetailsDialog.this.getOwner(); ownerWindow != null && !(ownerWindow instanceof JFrame); ownerWindow = ownerWindow.getOwner()) {
            }
            if (ownerWindow == null) {
                ownerWindow = Application.getActiveFrame();
            }
            this.setCategories(CategoriesEditDialog.show(ownerWindow, ContactDetailsDialog.this.getController(), this.getCategories()));
            ContactDetailsDialog.this.categoryChooser.updateText();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ContactDetailsDialog.this.closeDialogAction(e);
        }
    }

    private class OkAction
    extends AbstractOKAction {
        private OkAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ContactDetailsDialog.this.save()) {
                ContactDetailsDialog.this.setActionCompleteSuccessfully(true);
                ContactDetailsDialog.this.dispose();
            }
        }
    }
}

