/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.utils.OS;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.GroupMembersDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.MembersListRenderer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupDetailsPane
extends ContactDetailsPane {
    private static Logger logger = Logger.getLogger(ContactDetailsPane.class);
    private IGroupContact contact;
    private JTextField tfName = new GWTextField();
    private JTextArea taComments = new GWTextArea(5, 1);
    private JList listMembers = new JList();
    private Model model = new Model();
    private ContactDetailsDialog parent;
    private RefreshButton m_refresh;
    private OrientableButton membersButton;
    private List<IAddressable> removedContacts = new ArrayList<IAddressable>();
    private List<IRecipient> originalContacts = new ArrayList<IRecipient>();

    public OrientableButton getMembersButton() {
        return this.membersButton;
    }

    public GroupDetailsPane(IGroupContact contact, ContactDetailsDialog dialog) {
        this.tfName.setName("GroupDetailsPane_tfName");
        this.taComments.setName("GroupDetailsPane_taComments");
        this.contact = contact;
        this.parent = dialog;
        this.setName(StringResources.DETAILS);
        this.init();
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void init() {
        if (!this.contact.isReadOnly()) {
            this.taComments.addKeyListener(this.getPropertiesChangeListener());
            this.tfName.addKeyListener(this.getPropertiesChangeListener());
        }
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        TitleValueContainer container = new TitleValueContainer(this);
        this.listMembers.setModel(this.model);
        this.listMembers.setCellRenderer(new MembersListRenderer());
        this.listMembers.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (e.getKeyCode() == itemDeleteKey) {
                    GroupDetailsPane.this.removeSelectedMembers();
                }
            }
        });
        this.listMembers.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (OS.isDoubleClick(e)) {
                    GroupDetailsPane.this.viewDetails();
                }
            }
        });
        container.buildRow(new JMnemonicLabel(StringResources.NAME_C, this.tfName), this.tfName, 0);
        OrientableScrollPane scroll = new OrientableScrollPane(this.taComments);
        scroll.setVerticalScrollBarPolicy(22);
        container.buildRow(new JMnemonicLabel(StringResources.COMMENTS_C, this.taComments), scroll, 1);
        scroll = new OrientableScrollPane(this.listMembers);
        scroll.setPreferredSize(new Dimension(300, 230));
        this.membersButton = new OrientableButton(new SelectMembersActions());
        container.buildRow((JComponent)this.membersButton, (JComponent)scroll, 2, true);
        this.listMembers.updateUI();
        this.m_refresh = new RefreshButton(new RefreshMembersAction());
        container.buildRow((JComponent)new OrientableLabel(""), (JComponent)this.m_refresh, 3, false);
        this.m_refresh.setVisible(false);
    }

    private void showRefresh() {
        boolean bShow = this.contact.canRefresh();
        this.m_refresh.setVisible(bShow);
    }

    private void viewDetails() {
        Object o = this.listMembers.getSelectedValue();
        if (o instanceof IRecipient) {
            IRecipient recipient = (IRecipient)o;
            ContactDetailsDialog dialog = ContactDetailsDialog.createContactDetailsDialog((Window)this.parent, recipient.getAddressable(), null);
            dialog.showMe();
        }
    }

    public boolean addRecipients(List theRecipients) {
        return this.model.getMembersList().addAll(theRecipients);
    }

    private void removeSelectedMembers() {
        Object[] selectedValue = this.listMembers.getSelectedValues();
        int index = this.listMembers.getSelectedIndex();
        int nCount = selectedValue.length;
        for (int i = 0; i < nCount; ++i) {
            IRecipient recipient = (IRecipient)selectedValue[i];
            this.model.getMembersList().remove(recipient);
            this.listMembers.setModel(this.model);
            this.removedContacts.add(recipient.getAddressable());
        }
        this.listMembers.repaint();
        if (index != -1) {
            this.selectNearestIndex(index);
        }
    }

    private void selectNearestIndex(int index) {
        int size = this.listMembers.getModel().getSize();
        if (size == 0) {
            return;
        }
        int selectionIndex = index >= size ? size - 1 : index;
        this.listMembers.setSelectedIndex(selectionIndex);
    }

    @Override
    public boolean loadProperties() {
        this.tfName.setText(this.contact.getDisplayName());
        this.taComments.setText(this.contact.getComments());
        this.readGroupMembers();
        this.showRefresh();
        return true;
    }

    private void readGroupMembers() {
        try {
            IItemList members = this.contact.getMembers();
            int nSize = members.getSize();
            for (int i = 0; i < nSize; ++i) {
                IContact contact = (IContact)members.getItemAt(i);
                this.originalContacts.add(APIAbWrapperManager.createRecipient(contact, contact.getDistributionType()));
            }
            this.model.getMembersList().addAll(this.originalContacts);
        }
        catch (EngineException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
    }

    @Override
    public boolean saveProperties() {
        return this.contact.setDisplayName(this.tfName.getText()) & this.contact.setComments(this.taComments.getText());
    }

    public void writeGroupMembers() {
        IItemList itemList = null;
        try {
            itemList = this.contact.getMembers();
            int nSize = itemList.getSize();
            for (int i = 0; i < nSize; ++i) {
                IContact contact = (IContact)itemList.getItemAt(i);
                if (!this.removedContacts.contains(contact)) continue;
                this.contact.removeMember(contact);
            }
        }
        catch (EngineException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        List membersList = this.model.getMembersList();
        int nSize = membersList.size();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = (IRecipient)membersList.get(i);
            if (this.originalContacts.contains(recipient)) continue;
            try {
                IAddressable addressable = recipient.getAddressable();
                if (addressable instanceof IAddress) {
                    PersonalAddressBook pab = (PersonalAddressBook)EngineCommandManager.getAddressBook(String.valueOf(this.contact.getBookId()));
                    IContact contact = GWEngineUtils.createContact(pab, ContactType.USER);
                    contact.setEmailAddress(addressable.getEmailAddress());
                    contact.setDisplayName(addressable.getDisplayName());
                    addressable = contact;
                }
                this.contact.addMember((IContact)addressable, recipient.getCopyType());
                continue;
            }
            catch (EngineException e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
        }
    }

    private void refreshMembers() {
        this.parent.setCursor(Cursor.getPredefinedCursor(3));
        int index = this.listMembers.getSelectedIndex();
        try {
            IItemList members = this.contact.refresh();
            this.originalContacts.clear();
            int nSize = members.getSize();
            for (int i = 0; i < nSize; ++i) {
                IContact contact = (IContact)members.getItemAt(i);
                this.originalContacts.add(APIAbWrapperManager.createRecipient(contact, contact.getDistributionType()));
            }
            this.model.getMembersList().clear();
            this.model.getMembersList().addAll(this.originalContacts);
        }
        catch (EngineException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        this.listMembers.updateUI();
        if (index != -1) {
            this.selectNearestIndex(index);
        }
        this.parent.setCursor(Cursor.getPredefinedCursor(0));
    }

    private static List<IAddressable> contactListFromRecipient(List<IRecipient> recipientList) {
        ArrayList<IAddressable> result = new ArrayList<IAddressable>(recipientList.size());
        int nSize = recipientList.size();
        for (int i = 0; i < nSize; ++i) {
            result.add(recipientList.get(i).getAddressable());
        }
        return result;
    }

    @Override
    public JComponent getDefaultComponent() {
        return this.tfName;
    }

    private static class RefreshButton
    extends OrientableButton {
        public RefreshButton(Action a) {
            super(a);
        }

        public void setEnabled(boolean bEnable) {
        }
    }

    private class RefreshMembersAction
    extends AbstractAction {
        public RefreshMembersAction() {
            super(StringResources.REFRESH_MEMBERS);
        }

        public void actionPerformed(ActionEvent ev) {
            GroupDetailsPane.this.refreshMembers();
        }
    }

    private class SelectMembersActions
    extends AbstractAction {
        public SelectMembersActions() {
            super(StringResources.MEMBERS);
        }

        public void actionPerformed(ActionEvent e) {
            GroupMembersDialog dialog = new GroupMembersDialog(GroupDetailsPane.this.parent, GroupDetailsPane.this.model.getMembersList(), GroupDetailsPane.this.parent.getController());
            dialog.pack();
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed()) {
                List<IRecipient> result = dialog.getSelectedRecipients();
                List<IAddressable> contactList = GroupDetailsPane.this.model.getContactsList();
                List recipientsList = GroupDetailsPane.contactListFromRecipient(result);
                int nSize = contactList.size();
                for (int i = 0; i < nSize; ++i) {
                    if (recipientsList.contains(contactList.get(i))) continue;
                    GroupDetailsPane.this.removedContacts.add(contactList.get(i));
                }
                GroupDetailsPane.this.model.getMembersList().clear();
                GroupDetailsPane.this.model.getMembersList().addAll(result);
                GroupDetailsPane.this.listMembers.updateUI();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Model
    extends DefaultListModel {
        private List membersList = new ArrayList();

        public void setMembersList(List membersList) {
            this.membersList = membersList;
        }

        public List getMembersList() {
            return this.membersList;
        }

        @Override
        public int getSize() {
            if (this.membersList == null) {
                return 0;
            }
            return this.membersList.size();
        }

        public List<IAddressable> getContactsList() {
            ArrayList<IAddressable> result = new ArrayList<IAddressable>(this.membersList.size());
            int nSize = this.membersList.size();
            for (int i = 0; i < nSize; ++i) {
                result.add(((IRecipient)this.membersList.get(i)).getAddressable());
            }
            return result;
        }

        @Override
        public Object getElementAt(int index) {
            return this.membersList.get(index);
        }
    }
}

