/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IOrganizationContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.contactsearch.FilteredContactSearchTextField;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

class OrganizationDetailsPane
extends ContactDetailsPane {
    private static Logger logger = Logger.getLogger(OrganizationDetailsPane.class);
    private IOrganizationContact contact;
    private IUserContact primaryContact;
    private JTextField tfOrganization = new GWTextField();
    private JTextField tfPhone = new GWTextField();
    private FilteredContactSearchTextField tfPrimaryContact;
    private JTextField tfFax = new GWTextField();
    private JTextField tfCity = new GWTextField();
    private JTextField tfState = new GWTextField();
    private JTextField tfZip = new GWTextField();
    private JTextField tfCountry = new GWTextField();
    private JTextField tfWebSite = new GWTextField();
    private JTextArea taAddress = new GWTextArea(3, 1);
    private JTextArea taComments = new GWTextArea(4, 1);
    private JButton btnWebSite = new JButton(new ContactDetailsPane.LaunchWebSiteAction(this.tfWebSite, this));
    private AbstractAddressBook addressBook;

    public OrganizationDetailsPane(IOrganizationContact contact, AbstractAddressBook addressBook) {
        this.tfOrganization.setName("OrganizationDetailsPane_tfOrganization");
        this.tfPhone.setName("OrganizationDetailsPane_tfPhone");
        this.tfFax.setName("OrganizationDetailsPane_tfFax");
        this.tfCity.setName("OrganizationDetailsPane_tfCity");
        this.tfState.setName("OrganizationDetailsPane_tfState");
        this.tfZip.setName("OrganizationDetailsPane_tfZip");
        this.tfCountry.setName("OrganizationDetailsPane_tfCountry");
        this.tfWebSite.setName("OrganizationDetailsPane_tfWebSite");
        this.taAddress.setName("OrganizationDetailsPane_taAddress");
        this.taComments.setName("OrganizationDetailsPane_taComments");
        this.addressBook = addressBook;
        this.tfPrimaryContact = new FilteredContactSearchTextField(ContactType.USER);
        this.tfPrimaryContact.setName("OrganizationDetailsPane_tfPrimaryContact");
        this.contact = contact;
        this.setName(StringResources.DETAILS);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (!this.contact.isReadOnly()) {
            this.taAddress.addKeyListener(this.getPropertiesChangeListener());
            this.taComments.addKeyListener(this.getPropertiesChangeListener());
            this.tfCity.addKeyListener(this.getPropertiesChangeListener());
            this.tfCountry.addKeyListener(this.getPropertiesChangeListener());
            this.tfFax.addKeyListener(this.getPropertiesChangeListener());
            this.tfOrganization.addKeyListener(this.getPropertiesChangeListener());
            this.tfPhone.addKeyListener(this.getPropertiesChangeListener());
            this.tfPrimaryContact.addKeyListener(this.getPropertiesChangeListener());
            this.tfState.addKeyListener(this.getPropertiesChangeListener());
            this.tfWebSite.addKeyListener(this.getPropertiesChangeListener());
            this.tfZip.addKeyListener(this.getPropertiesChangeListener());
        }
    }

    private void buildUI() {
        int width = this.btnWebSite.getIcon().getIconWidth() + 8;
        this.btnWebSite.setPreferredSize(new Dimension(width, this.tfWebSite.getPreferredSize().height));
        TitleValueContainer container = new TitleValueContainer(this);
        container.buildRow(new JMnemonicLabel(StringResources.ORGANIZATION_C, this.tfOrganization), this.tfOrganization, new JMnemonicLabel(StringResources.PHONE_C, this.tfPhone), this.tfPhone, 0);
        container.buildRow(new JMnemonicLabel(StringResources.PRIMARY_CONTACT_C, this.tfPrimaryContact), this.tfPrimaryContact, new JMnemonicLabel(StringResources.FAX_C, this.tfFax), this.tfFax, 1);
        container.buildRow((JComponent)new JMnemonicLabel(StringResources.ADDRESS_C, this.taAddress), (JComponent)new OrientableScrollPane(this.taAddress), 2, true);
        container.buildRow(new JMnemonicLabel(StringResources.CITY_C, this.tfCity), this.tfCity, 3);
        container.buildRow(new JMnemonicLabel(StringResources.STATE_PROVINCE_C, this.tfState), this.tfState, new JMnemonicLabel(StringResources.ZIP_POSTAL_CODE_C, this.tfZip), this.tfZip, 4);
        container.buildRow(new JMnemonicLabel(StringResources.COUNTRY_C, this.tfCountry), this.tfCountry, new OrientableLabel(), new OrientableLabel(), 5);
        container.buildRow((JComponent)new JMnemonicLabel(StringResources.WEB_SITE_C, this.tfWebSite), (JComponent)this.tfWebSite, this.btnWebSite, 6);
        OrientableScrollPane scroll = new OrientableScrollPane(this.taComments);
        container.buildRow((JComponent)new JMnemonicLabel(StringResources.COMMENTS_C, this.taComments), (JComponent)scroll, 7, true);
        scroll.setPreferredSize(new Dimension(200, 110));
        this.tfFax.setColumns(6);
        this.tfCity.setColumns(6);
        this.tfState.setColumns(6);
        this.tfZip.setColumns(6);
        this.tfCountry.setColumns(6);
        this.tfWebSite.setColumns(6);
    }

    public boolean loadProperties() {
        this.primaryContact = this.contact.getPrimaryContact();
        this.tfOrganization.setText(this.contact.getDisplayName());
        this.tfPhone.setText(this.contact.getPhone());
        this.tfPrimaryContact.setInitialValue(this.primaryContact);
        this.tfFax.setText(this.contact.getFax());
        this.tfCity.setText(this.contact.getCity());
        this.tfState.setText(this.contact.getState());
        this.tfZip.setText(this.contact.getPostalCode());
        this.tfCountry.setText(this.contact.getCountry());
        this.tfWebSite.setText(this.contact.getWebsite());
        this.taAddress.setText(this.contact.getStreetAddress());
        this.taComments.setText(this.contact.getComments());
        return true;
    }

    public boolean saveProperties() {
        IContact foundContact = this.tfPrimaryContact.getContact();
        String text = this.tfPrimaryContact.getText();
        if (foundContact == null && !text.equals("")) {
            foundContact = GWEngineUtils.createContact((PersonalAddressBook)this.addressBook, ContactType.USER);
            foundContact.setDisplayName(text);
        }
        if (foundContact != null) {
            this.primaryContact = (IUserContact)foundContact;
            try {
                this.primaryContact.save(0);
            }
            catch (EngineException e) {
                logger.error((Object)e, (Throwable)e);
            }
        } else {
            this.primaryContact = null;
        }
        this.contact.setDisplayName(this.tfOrganization.getText());
        this.contact.setPhone(this.tfPhone.getText());
        this.contact.setPrimaryContact(this.primaryContact);
        this.contact.setFax(this.tfFax.getText());
        this.contact.setCity(this.tfCity.getText());
        this.contact.setState(this.tfState.getText());
        this.contact.setPostalCode(this.tfZip.getText());
        this.contact.setCountry(this.tfCountry.getText());
        this.contact.setWebsite(this.tfWebSite.getText());
        this.contact.setStreetAddress(this.taAddress.getText());
        this.contact.setComments(this.taComments.getText());
        return true;
    }

    public JComponent getDefaultComponent() {
        return this.tfOrganization;
    }
}

