/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.appframework.components.EmptyStringDocumentListener;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class RenameAddressBookDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(RenameAddressBookDialog.class);
    private JTextField tfName = new GWTextField();
    private PersonalAddressBook addressBook;

    public RenameAddressBookDialog(JFrame theFrame, PersonalAddressBook theAddressBook) {
        super(theFrame);
        this.setTitle(StringResources.RENAME_ADDRESS_BOOK);
        this.buildUI();
        this.btnOK.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RenameAddressBookDialog.this.renameAddressBook();
                RenameAddressBookDialog.this.dispose();
            }
        });
        this.btnOK.setText(StringResources.OK);
        this.addressBook = theAddressBook;
        this.tfName.getDocument().addDocumentListener(new EmptyStringDocumentListener(this.btnOK.getAction()){

            protected void setActionEnable(Document document) {
                super.setActionEnable(document);
                if (this.getText(document).equals(RenameAddressBookDialog.this.addressBook.getName())) {
                    this.action.setEnabled(false);
                }
            }
        });
        this.tfName.setText(this.addressBook.getName());
        this.tfName.selectAll();
    }

    private void renameAddressBook() {
        try {
            this.addressBook.setName(this.tfName.getText());
        }
        catch (EngineException e) {
            logger.error((Object)e);
        }
    }

    private void buildUI() {
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        pnlButtons.add(this.btnOK);
        pnlButtons.add(this.btnCancel);
        OrientablePanel pnlTemp = new OrientablePanel();
        pnlTemp.add((Component)pnlButtons, "North");
        OrientablePanel pnlCenter = new OrientablePanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.bottom = 5;
        constraints.insets.right = 10;
        constraints.anchor = 21;
        pnlCenter.add((Component)new JMnemonicLabel(StringResources.NEW_ADDRESS_BOOK_NAME_C, this.tfName), constraints);
        constraints.gridy = 1;
        constraints.anchor = 23;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        pnlCenter.add((Component)this.tfName, constraints);
        pnlContent.add((Component)pnlCenter, "Center");
        pnlContent.add((Component)pnlTemp, "After");
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public static void main(String[] args) {
        StringResources.initTestStringResources();
        RenameAddressBookDialog renameAddressBookDialog = new RenameAddressBookDialog(null, null);
        renameAddressBookDialog.pack();
        renameAddressBookDialog.show();
    }
}

