/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.table;

import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressBookTableModel<M extends AbstractAddressBookTable>
extends AbstractTableModel {
    private IItemList itemList;
    protected M abstractAddressBookTable;
    protected RefreshItemListListener refreshItemListListener = new RefreshItemListListener();

    public AddressBookTableModel(M abstractAddressBookTable) {
        this.abstractAddressBookTable = abstractAddressBookTable;
    }

    public void setItemList(IItemList itemList) {
        if (this.itemList != null) {
            this.itemList.removeItemListListener(this.refreshItemListListener);
        }
        this.itemList = itemList;
        if (this.itemList != null) {
            this.itemList.addItemListListener(this.refreshItemListListener);
        }
    }

    @Override
    public int getRowCount() {
        if (this.getItemList() == null) {
            return 0;
        }
        return this.getItemList().getSize();
    }

    public IItem getItemAt(int index) {
        return this.getItemList().getItemAt(index);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return ImageIcon.class;
        }
        return super.getColumnClass(columnIndex);
    }

    private void processItemListChanged() {
        this.fireTableDataChanged();
        ((AbstractAddressBookTable)this.abstractAddressBookTable).paintSortIcon(this.itemList.getSortField(), this.itemList.isSortAscending());
        ((Component)this.abstractAddressBookTable).repaint();
    }

    public void updateData(IItemList itemList) {
        if (itemList == null) {
            throw new IllegalArgumentException("ItemList = null");
        }
        this.setItemList(itemList);
        this.processItemListChanged();
    }

    public IItemList getItemList() {
        return this.itemList;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "";
        }
        return AddressBookManager.getPropertyLabel((int)((AbstractAddressBookTable)this.abstractAddressBookTable).columnsIDs[column - 1]);
    }

    @Override
    public int getColumnCount() {
        return ((AbstractAddressBookTable)this.abstractAddressBookTable).columnsIDs.length + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return ImageResources.ICON_ATTACHMENT;
        }
        assert (this.getItemAt(rowIndex) instanceof IContact);
        String value = ((IContact)this.getItemAt(rowIndex)).getStringValue(((AbstractAddressBookTable)this.abstractAddressBookTable).columnsIDs[columnIndex - 1]);
        if (value == null) {
            return "";
        }
        return value;
    }

    public int getEntryIndex(IContact theContact) {
        return this.getItemList().indexOf(theContact);
    }

    void dispose() {
        this.itemList = null;
    }

    private class RefreshItemListListener
    implements IItemListListener {
        private RefreshItemListListener() {
        }

        public void contentsChanged(ItemListEvent e) {
            AddressBookTableModel.this.processItemListChanged();
        }

        public void moreResultsAvailable(ItemListEvent e) {
        }

        public void notifyEmptyList(ItemListEvent e) {
        }

        public void queryResultsDone(ItemListEvent e) {
        }
    }
}

