/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.table;

import com.appframework.ActionList;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.CategoriesContactsEntryRenderer;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTableController;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressSelectorEntriesTableController;
import com.novell.gw.jclient.application.controls.menus.AddressSelectorEntryPopupMenu;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressSelectorEntriesTable
extends AbstractAddressBookTable {
    private Set<String> movedEntries = new HashSet<String>();
    private SelectorCellRenderer selectorCellRenderer = new SelectorCellRenderer();

    public AddressSelectorEntriesTable(MVCController theParentController, JTextField theSearchTextField) {
        super(theParentController, theSearchTextField);
        this.movedEntries.clear();
        this.init();
        this.addKeyListener(new DeleteContactListener());
    }

    @Override
    protected AbstractAddressBookTableController createController(MVCController parentController) {
        return new AddressSelectorEntriesTableController(this, parentController);
    }

    void init() {
        this.addMouseListener(new ASMouseListener());
        this.tfSearch.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    AddressSelectorEntriesTable.this.requestFocus();
                }
            }
        });
    }

    @Override
    public void setMVCModel(Object model) {
        super.setMVCModel(model);
        this.selectorCellRenderer.clearCache();
        if (model instanceof IRecipient) {
            this.clearSelection();
            Command command = new Command(270);
            this.getController().processCommand(command);
            this.movedEntries.add(String.valueOf(((IContact)model).getId()));
        } else if (model instanceof List) {
            this.clearSelection();
            Command command = new Command(270);
            this.getController().processCommand(command);
            List recipients = (List)model;
            for (Object recipient : recipients) {
                IAddressable addressable;
                if (!(recipient instanceof IRecipient) || !((addressable = ((IRecipient)recipient).getAddressable()) instanceof IContact)) continue;
                String id = String.valueOf(((IContact)addressable).getId());
                this.movedEntries.add(id);
            }
        }
    }

    @Override
    protected void performDefaultAction() {
        this.getController().getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.selectorCellRenderer;
    }

    public Set<String> getMovedEntries() {
        return this.movedEntries;
    }

    @Override
    public void refreshAddressBook(AbstractAddressBook addressBook) {
        super.refreshAddressBook(addressBook);
        this.selectorCellRenderer.clearCache();
    }

    private class DeleteContactListener
    extends KeyAdapter {
        private DeleteContactListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == OptionManager.getInstance().getGeneralOptions().getItemDeleteKey()) {
                AddressSelectorEntriesTable.this.controller.getActionList().performAction(ActionKey.DELETE_CONTACT);
            }
        }
    }

    private class SelectorCellRenderer
    extends CategoriesContactsEntryRenderer {
        private SelectorCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            IContact contact = (IContact)AddressSelectorEntriesTable.this.abstractAddressBookTableModel.getItemList().getItemAt(row);
            if (AddressSelectorEntriesTable.this.movedEntries.contains(String.valueOf(contact.getId())) && !(value instanceof ImageIcon)) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class ASMouseListener
    extends MouseAdapter {
        ASMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            int index;
            if (e.isPopupTrigger() && (index = AddressSelectorEntriesTable.this.rowAtPoint(e.getPoint())) != -1) {
                if (AddressSelectorEntriesTable.this.getSelectedRowCount() <= 1) {
                    AddressSelectorEntriesTable.this.setRowSelectionInterval(index, index);
                }
                ActionList actionList = AddressSelectorEntriesTable.this.getController().getActionList();
                IContact selectedContact = (IContact)AddressSelectorEntriesTable.this.abstractAddressBookTableModel.getItemList().getItemAt(index);
                AddressSelectorEntryPopupMenu popup = new AddressSelectorEntryPopupMenu(actionList, selectedContact);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

