/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.cache.IdentifiedObject;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.Borders;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentViewController;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentViewTransferHandler;
import com.novell.gw.jclient.application.controls.attachmentlist.FileSizeWarnDialog;
import com.novell.gw.jclient.application.controls.attachmentlist.ListView;
import com.novell.gw.jclient.application.controls.attachmentlist.TableView;
import com.novell.gw.jclient.application.controls.attachmentlist.ViewContent;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.menus.PopupMenuFactory;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButtonMenuItem;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.frames.open.FrameOpenActionList;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttachmentView
extends JPanel
implements MVCView<AttachmentViewController, AbstractItem> {
    public static final int SMALL_ICONS_VIEW = 0;
    public static final int LARGE_ICONS_VIEW = 1;
    public static final int LIST_VIEW = 2;
    public static final int DETAILS_VIEW = 3;
    private int viewMode = 1;
    private ButtonGroup iconsSizeButtonGroup;
    protected AttachmentViewController controller;
    protected ViewContent listContent;
    protected boolean viewMessage;
    protected boolean hideSystemAttachments;
    protected AbstractItem<?> item;
    private Object[] previousSelected;
    private Object[] nowSelected;
    private AVListSelectionListener listSelectionListener;
    private AVMouseListener listMouseListener;
    protected AppAction actionPrintMessage;
    protected JScrollPane sp;
    private Component parentComponent;

    protected AttachmentView(boolean isViewMessage, MVCController parentController) {
        this.viewMessage = isViewMessage;
        this.setController(new AttachmentViewController(this, parentController));
        this.buildUI();
    }

    private void buildUI() {
        this.actionPrintMessage = new ActionProcessGWItemAttachment(this.controller.getActionList(), StringResources.PRINT_D, ActionKey.PRINT);
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.iconsSizeButtonGroup = new ButtonGroup();
        this.listSelectionListener = new AVListSelectionListener();
        this.listMouseListener = new AVMouseListener();
        this.createContent(new ListView(this.viewMessage, new Object[0]));
        this.setViewMode(OptionManager.getInstance().getEnvironmentOptions().getAttachmentIconSizeID());
    }

    protected JPopupMenu getMultipleObjectsPopupMenu(Object[] theSelectedItems) {
        return PopupMenuFactory.createAttachmentsPopupMenu(this.getController(), theSelectedItems);
    }

    private JPopupMenu getSingleObjectPopupMenu(Object itemAtPoint) {
        if (itemAtPoint instanceof GWAttachment) {
            Command command = new Command(30, itemAtPoint);
            this.controller.processCommand(command);
            return this.getAttachmentPopupMenu(itemAtPoint);
        }
        if (itemAtPoint instanceof AbstractItem) {
            return PopupMenuFactory.createAttachmentsPopupMenu(this.getController(), (AbstractItem)itemAtPoint);
        }
        return null;
    }

    protected JPopupMenu getItemPopupMenu(AbstractItem item) {
        SensitivePopupMenu popupMenu = new SensitivePopupMenu();
        this.actionPrintMessage.setMVCModel(new SelectedItemsInfoImpl(null, item));
        ((JPopupMenu)popupMenu).add(new OpenGWItemAction(item));
        popupMenu.add(this.actionPrintMessage.getMenuItem());
        return popupMenu;
    }

    protected JPopupMenu getAttachmentPopupMenu(Object itemAtPoint) {
        return PopupMenuFactory.createAttachmentsPopupMenu(this.getController(), itemAtPoint);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = null;
        Object[] selectedItems = this.getSelectedObjects();
        if (selectedItems.length > 1) {
            popup = this.getMultipleObjectsPopupMenu(selectedItems);
        } else if (selectedItems.length == 1) {
            popup = this.getSingleObjectPopupMenu(selectedItems[0]);
        }
        popup = this.appendDefaultActions(popup);
        return popup;
    }

    protected Object[] getSelectedObjects() {
        return this.listContent.getSelectedValues();
    }

    protected JPopupMenu appendDefaultActions(JPopupMenu thePopupMenu) {
        if (thePopupMenu != null) {
            thePopupMenu.addSeparator();
        } else {
            thePopupMenu = new GWPopupMenu();
        }
        JMenu subMenu = MenuItemFactory.createMenu(StringResources.VIEW);
        subMenu.add(this.getMenuItem(1, StringResources.LARGE_ICONS));
        subMenu.add(this.getMenuItem(0, StringResources.SMALL_ICONS));
        subMenu.add(this.getMenuItem(2, StringResources.LIST));
        subMenu.add(this.getMenuItem(3, StringResources.DETAILS));
        thePopupMenu.add(subMenu);
        return thePopupMenu;
    }

    private JMenuItem getMenuItem(int theViewMode, String caption) {
        OrientableRadioButtonMenuItem menuItem = new OrientableRadioButtonMenuItem(new ActionChangeItemIconSize(theViewMode, caption));
        this.iconsSizeButtonGroup.add(menuItem);
        if (this.viewMode == theViewMode) {
            menuItem.setSelected(true);
        }
        return menuItem;
    }

    private boolean askToViewAttachment(Object item) {
        GWAttachment gwAttachment;
        int allowedFileSize;
        if (this.controller.getActionList() instanceof FrameOpenActionList && item instanceof GWAttachment && (allowedFileSize = EngineCommandManager.getAccountSettings().getAttachmentSizeWarningThreshold()) != -1 && (gwAttachment = (GWAttachment)item).getSize() > (long)allowedFileSize) {
            return !gwAttachment.isAllowedToView();
        }
        return false;
    }

    private void processItemSelection(Object[] items) {
        this.previousSelected = this.nowSelected;
        this.nowSelected = items;
        if (items.length > 1) {
            boolean ask = false;
            int lastSelectedItem = -1;
            for (int i = 0; i < items.length; ++i) {
                if (!this.askToViewAttachment(items[i])) continue;
                ask = true;
                lastSelectedItem = i;
            }
            if (ask) {
                int allowedFileSize = EngineCommandManager.getAccountSettings().getAttachmentSizeWarningThreshold();
                long currentFileSize = ((GWAttachment)items[lastSelectedItem]).getSize();
                FileSizeWarnDialog dialog = new FileSizeWarnDialog((FrameOpen)this.controller.getActionList().getOwnerComponent(), allowedFileSize, currentFileSize);
                dialog.showMe();
                if (dialog.allowToView) {
                    for (Object theItem : items) {
                        if (!(theItem instanceof GWAttachment)) continue;
                        ((GWAttachment)theItem).setAllowedToView(true);
                    }
                    this.controller.processCommand(new Command(50, items));
                }
            } else {
                this.controller.processCommand(new Command(50, items));
            }
        } else if (items.length == 1) {
            if (this.askToViewAttachment(items[0])) {
                int allowedFileSize = EngineCommandManager.getAccountSettings().getAttachmentSizeWarningThreshold();
                long currentFileSize = ((GWAttachment)items[0]).getSize();
                FileSizeWarnDialog dialog = new FileSizeWarnDialog((FrameOpen)this.controller.getActionList().getOwnerComponent(), allowedFileSize, currentFileSize);
                dialog.showMe();
                if (dialog.allowToView) {
                    this.controller.processCommand(new Command(50, items[0]));
                    ((GWAttachment)items[0]).setAllowedToView(true);
                }
            } else {
                this.controller.processCommand(new Command(50, items[0]));
            }
        }
    }

    public int[] getSelectedIndices() {
        return this.listContent.getSelectedIndices();
    }

    public void setViewMode(int viewMode) {
        if (viewMode < 0 || viewMode > 3) {
            throw new IllegalArgumentException("Unsuported view mode");
        }
        EnvironmentOptions eo = OptionManager.getInstance().getEnvironmentOptions();
        eo.setAttachmentIconSizeID(viewMode);
        OptionManager.getInstance().setEnvironmentOptions(eo);
        this.viewMode = viewMode;
        boolean focused = this.listContent.isFocused();
        switch (this.viewMode) {
            case 0: 
            case 1: 
            case 2: {
                if (this.listContent instanceof TableView) {
                    Object[] elements = this.listContent.getElements();
                    Object[] selectedValues = this.getSelectedObjects();
                    this.createContent(new ListView(this.viewMessage, elements));
                    this.listContent.selectItems(selectedValues);
                }
                this.listContent.setViewMode(viewMode);
                break;
            }
            case 3: {
                if (!(this.listContent instanceof ListView)) break;
                Object[] elements = this.listContent.getElements();
                Object[] selectedValues = this.getSelectedObjects();
                this.createContent(new TableView(this.viewMessage, elements));
                this.listContent.selectItems(selectedValues);
            }
        }
        this.listContent.setFocused(focused);
    }

    protected void createContent(ViewContent theViewContent) {
        if (this.listContent != null) {
            this.unRegisterListeners();
        }
        this.listContent = theViewContent;
        this.registerListeners();
        if (this.sp != null) {
            this.sp.removeMouseListener(this.listMouseListener);
            this.remove(this.sp);
        }
        this.sp = new ColoredScrollPane((JComponent)((Object)this.listContent));
        this.sp.setBorder(Borders.getEmptyTextComponentBorder(false));
        this.sp.addMouseListener(this.listMouseListener);
        this.add((Component)this.sp, "Center");
        this.listContent.updateScrollPane();
        this.getListContent().setTransferHandler(new AttachmentViewTransferHandler(this));
        this.revalidate();
        this.repaint();
    }

    protected void registerListeners() {
        this.listContent.addMouseListener(this.listMouseListener);
        this.listContent.addListSelectionListener(this.listSelectionListener);
    }

    protected void unRegisterListeners() {
        this.listContent.removeMouseListener(this.listMouseListener);
        this.listContent.removeListSelectionListener(this.listSelectionListener);
    }

    @Override
    public void setController(AttachmentViewController controller) {
        this.controller = controller;
    }

    @Override
    public AttachmentViewController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(AbstractItem model) {
        this.listContent.removeAllElements();
        if (model == null) {
            this.item = null;
        } else {
            this.item = model;
            this.parseGWItem();
        }
    }

    protected abstract void parseGWItem();

    public AbstractItem getItem() {
        return this.item;
    }

    @Override
    public AbstractItem getMVCModel() {
        return this.item;
    }

    private void requestFocusForCorrectComponent() {
        Component component = this.parentComponent;
        if (!this.isShowing()) {
            for (Component parent = component; parent != null; parent = parent.getParent()) {
                if (!parent.isShowing() || !parent.isFocusable()) continue;
                parent.requestFocusInWindow();
                break;
            }
        }
    }

    public void selectAttachment(IdentifiedObject theCommandObject) {
        this.listContent.selectItems(new Object[]{theCommandObject});
        this.requestFocusForCorrectComponent();
    }

    private void processDClick(Point p) {
        Object itemAtPoint = this.listContent.getItemAtPoint(p);
        if (itemAtPoint instanceof GWAttachment) {
            this.controller.getActionList().performAction(ActionKey.ATTACHMENT_OPEN);
        } else if (itemAtPoint instanceof AbstractItem && itemAtPoint != this.item) {
            this.processGWItemDClick((AbstractItem)itemAtPoint);
        } else {
            return;
        }
        if (this.previousSelected != null) {
            this.listContent.selectItems(this.previousSelected);
        } else {
            this.listContent.selectItems(new Object[]{this.item});
        }
    }

    protected void processGWItemDClick(AbstractItem item) {
        MessageUtils.openItem(null, item, ControlsUtils.getUserGuid(this.getController()));
    }

    void openEmbeddedItem(AbstractItem theItem) {
        this.getController().processCommand(new Command(920, theItem));
        this.setMVCModel(theItem);
    }

    public void setHideSystemAttachments(boolean theHide) {
        this.hideSystemAttachments = theHide;
        this.listContent.removeAllElements();
        this.parseGWItem();
    }

    public JComponent getListContent() {
        return (JComponent)((Object)this.listContent);
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    protected class OpenGWItemAction
    extends AbstractAction {
        private AbstractItem gwItem;

        public OpenGWItemAction(AbstractItem theGWItem) {
            super(StringResources.OPEN);
            this.gwItem = theGWItem;
        }

        public void actionPerformed(ActionEvent e) {
            MessageUtils.openItem(null, this.gwItem, ControlsUtils.getUserGuid(AttachmentView.this.getController()));
        }
    }

    protected class SensitivePopupMenu
    extends GWPopupMenu {
        protected SensitivePopupMenu() {
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (b) {
                AttachmentView.this.listContent.setSelectionEnabled(false);
            } else {
                AttachmentView.this.listContent.setPopupItem(null);
                AttachmentView.this.listContent.setSelectionEnabled(true);
                AttachmentView.this.repaint();
            }
        }
    }

    private static class ActionProcessGWItemAttachment
    extends AppAction {
        private ActionKey actionID;

        public ActionProcessGWItemAttachment(ActionList theActionList, String name, ActionKey theActionID) {
            super(theActionList, null, name);
            this.putValue("SmallIcon", null);
            this.actionID = theActionID;
        }

        public void actionPerformed(ActionEvent e) {
            AppAction action;
            Object model = this.getMVCModel();
            if (model != null && (action = this.getActionList().getAction(this.actionID)) != null) {
                action.setMVCModel(model);
                this.getActionList().performAction(this.actionID);
            }
        }
    }

    class AVListSelectionListener
    implements ListSelectionListener {
        private boolean enabled = true;

        AVListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (this.enabled && !e.getValueIsAdjusting()) {
                Object[] selectedItems = AttachmentView.this.getSelectedObjects();
                AttachmentView.this.processItemSelection(selectedItems);
            }
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }
    }

    private class AVMouseListener
    extends MouseAdapter {
        private AVMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.clearPopupSelection();
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AttachmentView view = AttachmentView.this;
                Object[] selectedItems = view.getSelectedObjects();
                Point point = e.getPoint();
                Object itemAtPoint = view.listContent.getItemAtPoint(point);
                AttachmentView.this.listContent.setPopupItem(itemAtPoint, true);
                if (!this.isPointSelected(selectedItems, itemAtPoint)) {
                    JPopupMenu menu = view.getSingleObjectPopupMenu(itemAtPoint);
                    menu = view.appendDefaultActions(menu);
                    menu.show((JComponent)((Object)view.listContent), point.x + 10, point.y + 10);
                } else {
                    JPopupMenu menu = view.createPopupMenu();
                    menu.show((JComponent)((Object)view.listContent), point.x + 10, point.y + 10);
                }
                view.listContent.setPopupItem(itemAtPoint, false);
                view.repaint();
            }
        }

        private boolean isPointSelected(Object[] theSelectedItems, Object theItemAtPoint) {
            for (Object selectedItem : theSelectedItems) {
                if (selectedItem != theItemAtPoint) continue;
                return true;
            }
            return false;
        }

        public void mouseClicked(MouseEvent e) {
            if (OS.isDoubleClick(e)) {
                AttachmentView.this.processDClick(e.getPoint());
            }
        }

        private void clearPopupSelection() {
            AttachmentView view = AttachmentView.this;
            if (view.listContent.getPopupItem() != null) {
                view.listContent.setPopupItem(null, false);
                ((JComponent)((Object)view.listContent)).repaint();
            }
        }
    }

    private class ActionChangeItemIconSize
    extends AbstractAction {
        private int viewMode;

        public ActionChangeItemIconSize(int theViewMode, String caption) {
            super(caption);
            this.viewMode = theViewMode;
        }

        public void actionPerformed(ActionEvent e) {
            AttachmentView.this.setViewMode(this.viewMode);
        }
    }
}

