/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.AttachmentView;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import java.util.List;
import org.apache.log4j.Logger;

public class OpenAttachmentView
extends AttachmentView {
    private static Logger logger = Logger.getLogger(OpenAttachmentView.class);

    public OpenAttachmentView(boolean isViewMessage, MVCController theParentController) {
        super(isViewMessage, theParentController);
    }

    protected void parseGWItem() {
        if (this.item != null) {
            List<GWAttachment> attachments = this.item.getAttachments();
            boolean messageRefExists = this.item instanceof DocumentItem;
            if (this.viewMessage && (this.item.hasPaperClipAttachments() || attachments.size() > 0 && !this.hideSystemAttachments) && !messageRefExists) {
                this.addMessageRef();
                messageRefExists = true;
            }
            for (GWAttachment attachment : attachments) {
                if (attachment.isMessageAttachment()) {
                    try {
                        String userGuid = ControlsUtils.getUserGuid(this.controller);
                        AbstractItem item = GWCommandManager.getInstance(userGuid).getEnclosedItem(attachment);
                        this.listContent.addElement(item);
                    }
                    catch (GWCommandException e) {
                        logger.error((Object)e, (Throwable)e);
                        ErrorDialog.processGWException(e);
                    }
                    continue;
                }
                if (attachment.isSystemAttachment() && this.hideSystemAttachments) continue;
                if (!messageRefExists) {
                    this.addMessageRef();
                    messageRefExists = true;
                }
                this.listContent.addElement(attachment);
            }
        }
    }

    public int[] getSelectedIndices() {
        int[] selectedIndices = super.getSelectedIndices();
        if (selectedIndices.length > 0 && selectedIndices[0] == 0) {
            int[] temp = new int[selectedIndices.length - 1];
            System.arraycopy(selectedIndices, 1, temp, 0, temp.length);
            selectedIndices = temp;
        }
        if (selectedIndices.length > 0) {
            selectedIndices = this.exludeMessageAttachment(selectedIndices);
            if (this.hideSystemAttachments) {
                this.exludeSystemAttachment(selectedIndices);
            }
        }
        return selectedIndices;
    }

    private int[] exludeMessageAttachment(int[] selectedIndices) {
        if (selectedIndices[0] == 0 && this.listContent.getElementAt(0) instanceof AbstractItem) {
            int[] temp = new int[selectedIndices.length - 1];
            System.arraycopy(selectedIndices, 1, temp, 0, temp.length);
            selectedIndices = temp;
        }
        return selectedIndices;
    }

    private void exludeSystemAttachment(int[] selectedIndices) {
        int k = 0;
        int size = this.item.getAttachments().size();
        int nCount = selectedIndices.length;
        while (this.item.getAttachments().get(k).isSystemAttachment() && k <= size) {
            ++k;
            int i = 0;
            while (i < nCount) {
                int n = i++;
                selectedIndices[n] = selectedIndices[n] + 1;
            }
        }
    }

    private void addMessageRef() {
        this.listContent.addElement(this.item);
        this.listContent.selectItems(new Object[]{this.item});
    }
}

