/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.jclient.application.controls.ScrollPaneBorderHighlightFocusListener;
import com.novell.gw.jclient.application.controls.attachmentlist.TableViewModel;
import com.novell.gw.jclient.application.controls.attachmentlist.TableViewRenderer;
import com.novell.gw.jclient.application.controls.attachmentlist.ViewContent;
import com.novell.gw.jclient.application.controls.orientable.OrientableTable;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

class TableView
extends OrientableTable
implements ViewContent {
    private boolean viewMessage;
    private Object popupItem;
    private boolean selectionEnabled = true;

    public TableView(boolean isViewMessage, Object[] theElements) {
        this.setBackground(Color.WHITE);
        this.viewMessage = isViewMessage;
        TableViewModel model = new TableViewModel();
        List items = model.getItems();
        for (Object element : theElements) {
            items.add(element);
        }
        this.setModel(model);
        this.setAutoResizeMode(3);
        this.setAutoscrolls(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSelectionMode(2);
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addFocusListener(new ScrollPaneBorderHighlightFocusListener(this));
        this.setDragEnabled(true);
        this.setColumnSelectionAllowed(false);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return new TableViewRenderer(this.viewMessage);
    }

    private List getItems() {
        return ((TableViewModel)this.getModel()).getItems();
    }

    public Object getItemAtPoint(Point thePoint) {
        int index = this.rowAtPoint(thePoint);
        if (index != -1) {
            List items = this.getItems();
            return items.get(index);
        }
        return null;
    }

    public void setViewMode(int viewMode) {
    }

    public void removeAllElements() {
        List items = this.getItems();
        items.clear();
        ((TableViewModel)this.getModel()).fireTableDataChanged();
    }

    public void addElement(Object obj) {
        List items = this.getItems();
        boolean result = items.add(obj);
        if (result) {
            ((TableViewModel)this.getModel()).fireTableDataChanged();
        }
    }

    public int getItemsCount() {
        return this.getModel().getRowCount();
    }

    public Object getElementAt(int index) {
        List items = this.getItems();
        return items.get(index);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().removeListSelectionListener(listener);
    }

    public boolean removeElement(Object obj) {
        List items = this.getItems();
        boolean result = items.remove(obj);
        if (result) {
            ((TableViewModel)this.getModel()).fireTableDataChanged();
        }
        return result;
    }

    public Object[] getSelectedValues() {
        int[] rows = this.getSelectedRows();
        ArrayList result = new ArrayList(rows.length);
        List items = this.getItems();
        for (int row : rows) {
            if (row < 0 || row >= items.size()) continue;
            result.add(items.get(row));
        }
        return result.toArray();
    }

    public Object[] getElements() {
        List items = this.getItems();
        return items.toArray();
    }

    public void selectItems(Object[] theSelectedValues) {
        this.clearSelection();
        int[] indeces = new int[theSelectedValues.length];
        List items = this.getItems();
        for (Object selectedValue : theSelectedValues) {
            int index;
            indeces[i] = index = items.indexOf(selectedValue);
        }
        if (indeces.length > 0) {
            Arrays.sort(indeces);
            this.setRowSelectionInterval(indeces[0], indeces[indeces.length - 1]);
            this.scrollRectToVisible(this.getCellRect(indeces[0], 0, true));
        }
    }

    public Object getPopupItem() {
        return this.popupItem;
    }

    public void setPopupItem(Object o, boolean lock) {
        this.popupItem = o;
    }

    public void setPopupItem(Object o) {
        this.popupItem = o;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
        this.repaint();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public boolean containsObject(Object theObject) {
        for (Object element : this.getElements()) {
            if (!element.equals(theObject)) continue;
            return true;
        }
        return false;
    }

    public void setFocused(boolean theFocused) {
        if (theFocused) {
            this.grabFocus();
        }
    }

    public boolean isFocused() {
        return this.isFocusOwner();
    }

    public int[] getSelectedIndices() {
        return this.getSelectedRows();
    }

    public void updateScrollPane() {
        this.configureEnclosingScrollPane();
        this.resizeAndRepaint();
    }
}

