/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.TableViewModel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.Logger;

class TableViewRenderer
extends DefaultTableCellRenderer {
    private static Logger logger = Logger.getLogger(TableViewRenderer.class);
    private boolean viewMessage;

    public TableViewRenderer(boolean theViewMessage) {
        this.viewMessage = theViewMessage;
        this.setComponentOrientation(UIUtils.getComponentOrientation());
    }

    public static Icon getIconForAttachment(Object theAttachment) {
        if (theAttachment instanceof GWAttachment) {
            GWAttachment attachment = (GWAttachment)theAttachment;
            return ControlsUtils.getSmallIconForAttachment(attachment.getFileName(), attachment.getDownloadState());
        }
        if (theAttachment instanceof AbstractItem) {
            return ControlsUtils.getAttachmentIconForGWItem((AbstractItem)theAttachment, false);
        }
        throw new IllegalArgumentException("Unsupported attachment type [" + theAttachment.getClass().getName() + ']');
    }

    public static boolean isMessage(Object theObject) {
        return theObject instanceof AbstractItem;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column == 0) {
            Object selected = ((TableViewModel)table.getModel()).getItems().get(row);
            if (row == 0 && TableViewRenderer.isMessage(selected) && this.viewMessage) {
                this.setText(StringResources.MESSAGE);
                this.setIcon(ImageResources.ICON_MESSAGE_SMALL);
            } else {
                this.setIcon(TableViewRenderer.getIconForAttachment(value));
                if (value != null) {
                    this.setText(value.toString());
                }
            }
        }
        return this;
    }
}

