/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeEvent;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.DayBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.dailycalendar.DailyCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class AutoDateCalendar
extends DailyCalendar {
    private Collection<Calendar> multiselectedDates;
    private Font fntBold;
    private Dimension size;
    private DayBorder dayBorder;
    private Color clrDaysHolyLigth;
    private Color clrDaysWorkLigth;
    private JLabel btnToday;
    private ArrayList<AutoDateChangeListener> autoDateChangeListeners = new ArrayList();
    private static final float BTN_FONT_SIZE = (float)PLAFChanger.getFontSize() - 3.5f;
    private static final float LBL_FONT_SIZE = (float)PLAFChanger.getFontSize() - 2.0f;

    protected void buildUI() {
        super.buildUI();
        this.setMinimumSize(this.size);
        this.setPreferredSize(this.size);
    }

    protected void init() {
        super.init();
        this.multiselectedDates = new HashSet<Calendar>();
        this.fntBold = Utils.deriveFont(this.fntDates, 1);
        this.clrDaysHolyLigth = new Color(255, 125, 125);
        this.clrDaysWorkLigth = new Color(125, 125, 125);
        int fontSize = PLAFChanger.getFontSize();
        this.size = new Dimension(fontSize * 10 + 4, fontSize * 10 - 10);
        this.dayBorder = new DayBorder(DayBorder.BORDER_TODAY_UNSELECTED);
        this.isSelectedRectangleShowing = false;
        this.dimMinDaysButtSize = new Dimension(17, 10);
        this.dimMinMonthSize = new Dimension(94, 12);
        this.lblHeader.setFont(Utils.deriveFont(this.lblHeader.getFont(), 1, BTN_FONT_SIZE));
        this.fntDates = Utils.deriveFontForSize(this.fntDates, BTN_FONT_SIZE);
        this.fntDays = Utils.deriveFontForSize(this.fntDays, BTN_FONT_SIZE);
        this.fntBold = Utils.deriveFont(this.fntDates, 1, BTN_FONT_SIZE);
        this.setFont(Utils.deriveFontForSize(this.lblHeader.getFont(), LBL_FONT_SIZE));
    }

    public void refreshView() {
        super.refreshView();
        this.repaint();
    }

    private void addMultiselectDate(Calendar date) {
        assert (!GWCalendarUtils.hasTimeFraction(date)) : "time fraction is present in the element: " + DateAndTimeFormattingUtils.calendarToLogString(date);
        if (date != null && GWCalendarUtils.inMonthRange(this.gcCurrDay, date)) {
            this.multiselectedDates.add((Calendar)date.clone());
        }
    }

    public void clearMultiselectDates() {
        this.multiselectedDates.clear();
    }

    private void removeMultiselectDate(Calendar date) {
        assert (!GWCalendarUtils.hasTimeFraction(date)) : "time fraction is present in the element: " + DateAndTimeFormattingUtils.calendarToLogString(date);
        this.multiselectedDates.remove(date);
    }

    public void addMultiselectDates(Calendar[] dates) {
        int nSize = dates.length;
        for (int i = 0; i < nSize; ++i) {
            this.addMultiselectDate(dates[i]);
        }
    }

    public void setCurrDay(Calendar theCurrDay) {
        this.gcCurrDay = (Calendar)theCurrDay.clone();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (GWCalendarUtils.inMonthRange(this.gcCurrDay, GWCalendarUtils.getToday()) && this.btnToday != null) {
            int dd = 1;
            Rectangle todayBounds = SwingUtilities.convertRectangle(this.btnToday.getParent(), this.btnToday.getBounds(), this);
            this.dayBorder.paintBorder(this, g, todayBounds.x - dd, todayBounds.y - dd, todayBounds.width + dd, todayBounds.height + dd * 2);
        }
    }

    protected void setTodayColor(Calendar theCalendar, int i) {
        if (GWCalendarUtils.isToday(theCalendar.getTime())) {
            this.btnToday = this.btnDates[i];
        }
    }

    protected void refreshDateLabelView(int i) {
        String title = "";
        if (this.days[i] != null) {
            title = String.valueOf(this.days[i].get(5));
            if (this.multiselectedDates.contains(this.days[i])) {
                if (this.btnDates[i].getForeground().equals(this.clrDaysHolyLigth)) {
                    this.btnDates[i].setForeground(ColorConstants.clrDaysHoly);
                } else if (this.btnDates[i].getForeground().equals(this.clrDaysWorkLigth)) {
                    this.btnDates[i].setForeground(ColorConstants.clrDaysWork);
                }
                this.btnDates[i].setFont(this.fntBold);
            } else {
                this.btnDates[i].setFont(this.fntDates);
            }
        }
        this.btnDates[i].setText(title);
        this.btnDates[i].setEnabled(this.days[i] != null);
        this.btnDates[i].setBorder(null);
    }

    protected void setWeekEndColor(Calendar theCalendar, int i) {
        if (theCalendar.get(7) == 1 || theCalendar.get(7) == 7) {
            this.btnDates[i].setForeground(this.clrDaysHolyLigth);
        } else {
            this.btnDates[i].setForeground(this.clrDaysWorkLigth);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Calendar gcDay = this.days[((DailyCalendar.DailyLabel)e.getSource()).getIndex()];
        if (gcDay == null) {
            e.consume();
            return;
        }
        if (this.multiselectedDates.contains(gcDay)) {
            this.removeMultiselectDate(gcDay);
            this.fireAutoDateChanged(new AutoDateChangeEvent(gcDay, false));
        } else {
            this.addMultiselectDate(gcDay);
            this.fireAutoDateChanged(new AutoDateChangeEvent(gcDay, true));
        }
        this.refreshView();
    }

    public void addAutoDateChangeListener(AutoDateChangeListener theListener) {
        this.autoDateChangeListeners.add(theListener);
    }

    public void removeAutoDateChangeListener(AutoDateChangeListener theListener) {
        this.autoDateChangeListeners.remove(theListener);
    }

    private void fireAutoDateChanged(AutoDateChangeEvent e) {
        for (AutoDateChangeListener l : this.autoDateChangeListeners) {
            l.selectionChanged(e);
        }
    }
}

