/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.novell.gw.jclient.application.controls.autodate.AutoDateCalendar;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeEvent;
import com.novell.gw.jclient.application.controls.autodate.AutoDateChangeListener;
import com.novell.gw.jclient.application.controls.autodate.SpinYearButtons;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SetDateCalendarPanel
extends JComponent
implements AutoDateChangeListener {
    private static Logger logger = Logger.getLogger(SetDateCalendarPanel.class);
    private static final int CALENDARS_COUNT = 12;
    private HashMap selected = new HashMap();
    private AutoDateCalendar[] calendars = new AutoDateCalendar[12];
    private Calendar startDate = GWCalendarUtils.getToday();
    private SpinYearButtons spinButtons;
    private boolean isYearAdjusting;

    public SetDateCalendarPanel() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.buildUI();
    }

    private void buildUI() {
        int gap = 10;
        OrientablePanel pnl = new OrientablePanel(new GridLayout(3, 4, gap, gap));
        for (int i = 0; i < this.calendars.length; ++i) {
            this.calendars[i] = new AutoDateCalendar();
            this.calendars[i].addAutoDateChangeListener(this);
            pnl.add(this.calendars[i]);
        }
        JPanel pnl1 = new JPanel();
        pnl1.add(pnl);
        this.add((Component)pnl1, "Center");
        JPanel pnl2 = new JPanel();
        this.spinButtons = new SpinYearButtons();
        this.spinButtons.addPropertyChangeListener("Date_changed", new DateChangeListener());
        pnl2.add(this.spinButtons);
        this.add((Component)pnl2, "North");
    }

    public void selectionChanged(AutoDateChangeEvent e) {
        Calendar date = e.getDate();
        String key = GWCalendarUtils.calendarToString(date);
        if (e.wasAdded()) {
            this.selected.put(key, date);
        } else {
            this.selected.remove(key);
        }
    }

    private void validateCalendars() {
        this.startDate.set(2, 0);
        Calendar[] dates = this.getSelectedDates();
        for (int i = 0; i < this.calendars.length; ++i) {
            this.calendars[i].setCurrDay(this.startDate);
            this.calendars[i].clearMultiselectDates();
            this.calendars[i].addMultiselectDates(dates);
            this.calendars[i].refreshView();
            this.startDate.add(2, 1);
        }
    }

    public void setSelectedDates(Calendar[] dates) {
        this.selected.clear();
        for (int i = 0; i < dates.length; ++i) {
            Calendar date = dates[i];
            this.startDate.setTime(date.getTime());
            String key = GWCalendarUtils.calendarToString(date);
            this.selected.put(key, date);
        }
        if (dates.length == 0) {
            this.startDate.setTime(GWCalendarUtils.getToday().getTime());
        }
        this.isYearAdjusting = true;
        this.goToYear(this.startDate.get(1));
        this.isYearAdjusting = false;
        this.validateCalendars();
    }

    public Calendar[] getSelectedDates() {
        Calendar[] result = new Calendar[this.selected.size()];
        return this.selected.values().toArray(result);
    }

    public void reset() {
        this.selected.clear();
        this.goToYear(GWCalendarUtils.getToday().get(1));
    }

    private void goToYear(int theYear) {
        this.spinButtons.setYear(theYear);
    }

    private class DateChangeListener
    implements PropertyChangeListener {
        private DateChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!SetDateCalendarPanel.this.isYearAdjusting) {
                SetDateCalendarPanel.this.startDate.setTime(((Calendar)evt.getNewValue()).getTime());
                SetDateCalendarPanel.this.validateCalendars();
            }
        }
    }
}

