/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.addressbook.DLSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchDialogController;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchUtils;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientActionsPopup;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusySearchDialog
extends ApplicationDialog<BusySearchDialogController> {
    private static Logger logger = Logger.getLogger(BusySearchDialog.class);
    private Dimension dialogSize = new Dimension(460, 325);
    private Border sideBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private ContactSearchTextField tfTo = new ContactSearchTextField();
    private ContactSearchTextField tfCc = new ContactSearchTextField();
    private ContactSearchTextField tfBc = new ContactSearchTextField();
    private DefaultListModel modelTo = new DefaultListModel();
    private DefaultListModel modelCc = new DefaultListModel();
    private DefaultListModel modelBc = new DefaultListModel();
    private SingleDateSelector dsDate;
    private JSpinner spinnerDaysCount;
    private RecipientActionsPopup recipientActionsPopup;
    private boolean disableDefaultAction = false;
    private static final int DEFAULT_CHARACTERS_COUNT = 10;

    public BusySearchDialog(JFrame parentFrame, MVCController parentController) {
        super((Frame)parentFrame, parentController, true);
        this.buildUI();
    }

    @Override
    protected BusySearchDialogController createController(MVCController parentController) {
        return new BusySearchDialogController(this, parentController);
    }

    private void buildUI() {
        this.setTitle(StringResources.BUSY_SEARCH);
        this.tfTo.addKeyListener(new RecipientInputKeyAdapter());
        this.tfCc.addKeyListener(new RecipientInputKeyAdapter());
        this.tfBc.addKeyListener(new RecipientInputKeyAdapter());
        this.tfTo.addSearchListener(new SearchListener(this.modelTo));
        this.tfCc.addSearchListener(new SearchListener(this.modelCc));
        this.tfBc.addSearchListener(new SearchListener(this.modelBc));
        this.tfTo.addFocusListener(new RecipientsFocusListener());
        this.tfCc.addFocusListener(new RecipientsFocusListener());
        this.tfBc.addFocusListener(new RecipientsFocusListener());
        this.tfTo.setColumns(10);
        this.tfCc.setColumns(10);
        this.tfBc.setColumns(10);
        this.modelTo.addListDataListener(new RecipientListChangeAdapter());
        this.modelCc.addListDataListener(new RecipientListChangeAdapter());
        this.modelBc.addListDataListener(new RecipientListChangeAdapter());
        this.recipientActionsPopup = new RecipientActionsPopup();
        this.recipientActionsPopup.addPropertyChangeListener("action", new PopupPropertyChanged());
        OrientablePanel pnlCenter = new OrientablePanel();
        pnlCenter.setLayout(new BorderLayout());
        pnlCenter.add((Component)this.buildInvitePanel(), "Center");
        pnlCenter.add((Component)this.buildSelectionPanel(), "Last");
        OrientablePanel buttonPanel = new OrientablePanel();
        buttonPanel.setBorder(this.sideBorder);
        JButton addrBook = new JButton(StringResources.ADDRESS_BOOK_D);
        addrBook.addActionListener(new BtnAddressBookAction());
        OS.addButtons(buttonPanel, this.getBtnOk(), this.getBtnCancel(), addrBook);
        OrientablePanel pnlBottom = new OrientablePanel();
        pnlBottom.setLayout(new BorderLayout());
        pnlBottom.add((Component)buttonPanel, "After");
        this.getBtnOk().setEnabled(this.isSearchAllowed());
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout());
        pnlContent.add((Component)pnlCenter, "Center");
        pnlContent.add((Component)pnlBottom, "Last");
        this.setContentPane(pnlContent);
    }

    private JPanel buildInvitePanel() {
        int y;
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(StringResources.INVITE_TO_MEETING));
        GridBagConstraints c = new GridBagConstraints();
        int x = 15;
        Insets left = new Insets(0, x, 0, 0);
        Insets center = new Insets(0, x, 0, x);
        Insets right = new Insets(0, 0, 0, x);
        OrientableLabel label = new OrientableLabel(StringResources.TO_C);
        c.anchor = 21;
        c.insets = left;
        pnl.add((Component)label, c);
        label = new OrientableLabel(StringResources.CARBON_COPY_C);
        c.gridx = 1;
        c.insets = center;
        pnl.add((Component)label, c);
        label = new OrientableLabel(StringResources.BLIND_COPY_C);
        c.gridx = 2;
        c.insets = right;
        pnl.add((Component)label, c);
        c.gridy = 1;
        c.fill = 2;
        left.bottom = y = 10;
        center.bottom = y;
        right.bottom = y;
        c.gridx = 0;
        c.insets = left;
        c.weightx = 1.0;
        pnl.add((Component)this.tfTo, c);
        c.gridx = 1;
        c.insets = center;
        pnl.add((Component)this.tfCc, c);
        c.gridx = 2;
        c.insets = right;
        pnl.add((Component)this.tfBc, c);
        c.ipadx = 0;
        c.gridy = 2;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = left;
        pnl.add((Component)this.createRecipientsList(this.modelTo), c);
        c.gridx = 1;
        c.insets = center;
        c.weighty = 1.0;
        pnl.add((Component)this.createRecipientsList(this.modelCc), c);
        c.gridx = 2;
        c.insets = right;
        c.weighty = 1.0;
        pnl.add((Component)this.createRecipientsList(this.modelBc), c);
        c.weighty = 0.0;
        return pnl;
    }

    private JComponent createRecipientsList(final ListModel listModel) {
        final OrientableList list = new OrientableList(listModel);
        list.addMouseListener(new ListMouseListener());
        list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (e.getKeyCode() == itemDeleteKey) {
                    Object[] values = list.getSelectedValues();
                    int nCount = values.length;
                    for (int i = nCount - 1; i > -1; --i) {
                        ((DefaultListModel)listModel).removeElement(values[i]);
                    }
                }
            }
        });
        OrientableScrollPane result = new OrientableScrollPane(list);
        int defaultWidht = UIUtils.getColumnWidth(10, list);
        result.setPreferredSize(new Dimension(defaultWidht, defaultWidht));
        return result;
    }

    private JPanel buildSelectionPanel() {
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout());
        pnl.setBorder(this.sideBorder);
        GridBagConstraints c = new GridBagConstraints();
        int x = 13;
        Insets left = new Insets(0, x, 0, 0);
        Insets center = new Insets(0, x, 0, x);
        OrientableLabel label = new OrientableLabel(StringResources.START_SEARCH_DATE_C);
        c.anchor = 21;
        c.insets = left;
        pnl.add((Component)label, c);
        label = new OrientableLabel(StringResources.NUMBER_OF_DAYS_TO_SEARCH_C);
        c.gridx = 1;
        c.insets = center;
        pnl.add((Component)label, c);
        c.gridy = 1;
        c.gridx = 0;
        c.insets = left;
        c.fill = 2;
        c.weightx = 1.0;
        this.dsDate = new SingleDateSelector();
        this.dsDate.setIcon(ImageResources.ICON_ACT_VIEW_CALENDAR);
        pnl.add((Component)this.dsDate, c);
        c.weightx = 0.0;
        String userGuid = ControlsUtils.getUserGuid(this.getController());
        int initialValue = (Integer)GWCommandManager.getInstance(userGuid).getDataStoreSettings().getBusySearchRange().getValue();
        this.spinnerDaysCount = new JSpinner(new SpinnerNumberModel(initialValue, 1, 365, 1));
        this.spinnerDaysCount.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.spinnerDaysCount.setComponentOrientation(UIUtils.getComponentOrientation());
        c.gridx = 1;
        c.insets = center;
        c.fill = 0;
        c.ipadx = 10;
        pnl.add((Component)this.spinnerDaysCount, c);
        return pnl;
    }

    @Override
    public void setMVCModel(Object model) {
        if (model instanceof GWBusySearch) {
            GWBusySearch busySearch = (GWBusySearch)model;
            this.setStartDate(busySearch.getSearchStartTime());
            BusySearchDialog.fillListModel(busySearch.getRecipientDescriptionsList().getRecipientDescriptions(RecipientCopyType.getTo()), this.modelTo, true);
            BusySearchDialog.fillListModel(busySearch.getRecipientDescriptionsList().getRecipientDescriptions(RecipientCopyType.getCc()), this.modelCc, true);
            BusySearchDialog.fillListModel(busySearch.getRecipientDescriptionsList().getRecipientDescriptions(RecipientCopyType.getBc()), this.modelBc, true);
            this.spinnerDaysCount.setValue(busySearch.getDaysCount());
            this.validate();
        } else if (model instanceof List) {
            List list = (List)model;
            BusySearchDialog.fillListModel((List<IRecipient>)list, this.modelTo, RecipientCopyType.getTo());
            BusySearchDialog.fillListModel((List<IRecipient>)list, this.modelCc, RecipientCopyType.getCc());
            BusySearchDialog.fillListModel((List<IRecipient>)list, this.modelBc, RecipientCopyType.getBc());
            this.validate();
        }
    }

    private static void fillListModel(List source, DefaultListModel theListModel, boolean clear) {
        if (clear) {
            theListModel.clear();
        }
        int nSize = source.size();
        for (int i = 0; i < nSize; ++i) {
            theListModel.add(i, new ListLabel((RecipientDescription)source.get(i)));
        }
    }

    private static void fillListModel(List<IRecipient> source, DefaultListModel theListModel, RecipientCopyType copyType) {
        theListModel.clear();
        int nSize = source.size();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = source.get(i);
            if (!recipient.getCopyType().hasRecipientCopyType(copyType)) continue;
            theListModel.addElement(new ListLabel(recipient));
        }
    }

    public void setStartDate(Date theDate) {
        Calendar startDate = GWCalendarUtils.getToday();
        startDate.setTime(theDate);
        this.dsDate.setDate(startDate);
    }

    public Date getStartDate() {
        return this.dsDate.getDate().getTime();
    }

    public int getDaysCount() {
        return (Integer)this.spinnerDaysCount.getValue();
    }

    public RecipientDescriptionsList getRecepientDescriptinsList() {
        RecipientDescriptionsList list = new RecipientDescriptionsList();
        list.addAllRecipientDiscriptions(BusySearchDialog.createRecipeintDescriptionsList(this.modelTo));
        list.addAllRecipientDiscriptions(BusySearchDialog.createRecipeintDescriptionsList(this.modelCc));
        list.addAllRecipientDiscriptions(BusySearchDialog.createRecipeintDescriptionsList(this.modelBc));
        return list;
    }

    private static ArrayList<RecipientDescription> createRecipeintDescriptionsList(DefaultListModel theListModel) {
        ArrayList<RecipientDescription> result = new ArrayList<RecipientDescription>();
        int nSize = theListModel.size();
        for (int i = 0; i < nSize; ++i) {
            ListLabel ll = (ListLabel)theListModel.elementAt(i);
            RecipientDescription rd = ll.getRecipientDescription();
            BusySearchUtils.addRecipientDescriptionToList(result, rd.getRecipient(), rd.getState(), rd.isSelected());
        }
        return result;
    }

    private boolean isSearchAllowed() {
        return this.modelTo.size() > 0 || this.modelCc.size() > 0 || this.modelBc.size() > 0;
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        BusySearchDialog form = this;
        if (!(form.disableDefaultAction && (form.tfTo.isFocusOwner() || form.tfCc.isFocusOwner() || form.tfBc.isFocusOwner()) || BusySearchUtils.hasValidRecipient(this.getRecepientDescriptinsList().getDistributionList()))) {
            JOptionPane.showMessageDialog(null, StringResources.BYSY_SEARCH_NO_VALID_USERS);
            return;
        }
        super.processOkAction(event);
    }

    private class SearchListener
    implements SearchResultListener {
        private DefaultListModel listModel;

        public SearchListener(DefaultListModel listModel) {
            this.listModel = listModel;
        }

        private boolean isRecpientExistInModel(IRecipient theRecipient, DefaultListModel theListModel) {
            boolean result = false;
            ArrayList existing = BusySearchDialog.createRecipeintDescriptionsList(theListModel);
            int nSize = existing.size();
            String strRecip = ABUtils.getRecipientID(theRecipient);
            for (int i = 0; i < nSize; ++i) {
                RecipientDescription rd = (RecipientDescription)existing.get(i);
                if (!ABUtils.getRecipientID(rd.getRecipient()).equals(strRecip)) continue;
                result = true;
                break;
            }
            return result;
        }

        public void searchFinished(SearchEvent e) {
            IAddressable addressable = e.getFoundContact();
            if (addressable != null) {
                RecipientCopyType copyType = RecipientCopyType.getTo();
                if (this.listModel.equals(BusySearchDialog.this.modelCc)) {
                    copyType = RecipientCopyType.getCc();
                } else if (this.listModel.equals(BusySearchDialog.this.modelBc)) {
                    copyType = RecipientCopyType.getBc();
                }
                IRecipient recipient = APIAbWrapperManager.createRecipient(addressable, copyType);
                if (this.isRecpientExistInModel(recipient, this.listModel)) {
                    logger.debug((Object)("recipient - " + recipient.getAddressable().getDisplayName() + " exists in the list"));
                    return;
                }
                ListLabel ll = new ListLabel(new RecipientDescription(recipient));
                this.listModel.add(this.listModel.size(), ll);
            }
        }
    }

    private class PopupPropertyChanged
    implements PropertyChangeListener {
        private JList focusedList;

        private PopupPropertyChanged() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!(BusySearchDialog.this.recipientActionsPopup.getFocusedComponent() instanceof JList) || !(evt.getNewValue() instanceof Integer)) {
                return;
            }
            int selectedAction = (Integer)evt.getNewValue();
            this.focusedList = (JList)BusySearchDialog.this.recipientActionsPopup.getFocusedComponent();
            if (selectedAction == RecipientActionsPopup.EDIT) {
                this.doEdit();
            } else if (selectedAction == RecipientActionsPopup.CUT) {
                this.doCopy();
                this.doDelete();
            } else if (selectedAction == RecipientActionsPopup.COPY) {
                this.doCopy();
            } else if (selectedAction == RecipientActionsPopup.DELETE) {
                this.doDelete();
                BusySearchDialog.this.recipientActionsPopup.setBuffer(null);
            } else if (selectedAction == RecipientActionsPopup.PASTE) {
                this.doPaste();
            } else if (selectedAction == RecipientActionsPopup.SELECT_ALL) {
                this.doSelectAll();
            }
        }

        private void doEdit() {
            GWTextField target = new GWTextField();
            if (this.focusedList.getModel().equals(BusySearchDialog.this.modelTo)) {
                target = BusySearchDialog.this.tfTo;
            } else if (this.focusedList.getModel().equals(BusySearchDialog.this.modelCc)) {
                target = BusySearchDialog.this.tfCc;
            } else if (this.focusedList.getModel().equals(BusySearchDialog.this.modelBc)) {
                target = BusySearchDialog.this.tfBc;
            }
            if (this.focusedList.getSelectedValues().length > 0) {
                RecipientDescription rd = ((ListLabel)this.focusedList.getSelectedValue()).getRecipientDescription();
                ((JTextComponent)target).setText(rd.getRecipient().getAddressable().getDisplayName());
                ((DefaultListModel)this.focusedList.getModel()).removeElement(this.focusedList.getSelectedValue());
            }
        }

        private void doCopy() {
            ArrayList<RecipientDescription> al = new ArrayList<RecipientDescription>();
            Object[] values = this.focusedList.getSelectedValues();
            int nCount = values.length;
            for (int i = 0; i < nCount; ++i) {
                al.add(((ListLabel)values[i]).getRecipientDescription());
            }
            BusySearchDialog.this.recipientActionsPopup.setBuffer(al);
        }

        private void doDelete() {
            Object[] values = this.focusedList.getSelectedValues();
            int nCount = values.length;
            for (int i = nCount - 1; i > -1; --i) {
                ((DefaultListModel)this.focusedList.getModel()).removeElement(values[i]);
            }
        }

        private void doPaste() {
            ArrayList al = BusySearchDialog.this.recipientActionsPopup.getBuffer();
            ListModel model = this.focusedList.getModel();
            int nSize = model.getSize();
            for (int i = 0; i < nSize; ++i) {
                RecipientDescription rd = ((ListLabel)model.getElementAt(i)).getRecipientDescription();
                for (int j = al.size() - 1; j > -1; --j) {
                    if (!rd.isSameRecipient((RecipientDescription)al.get(j))) continue;
                    al.remove(j);
                }
            }
            BusySearchDialog.fillListModel(al, (DefaultListModel)this.focusedList.getModel(), false);
        }

        private void doSelectAll() {
            int[] selIndices = new int[this.focusedList.getModel().getSize()];
            int nSize = this.focusedList.getModel().getSize();
            for (int i = 0; i < nSize; ++i) {
                selIndices[i] = i;
            }
            this.focusedList.setSelectedIndices(selIndices);
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger() && e.getSource() instanceof JList) {
                JList source = (JList)e.getSource();
                BusySearchDialog.this.recipientActionsPopup.setFocusedComponent(source);
                BusySearchDialog.this.recipientActionsPopup.show(source, e.getX(), e.getY());
            }
        }
    }

    private class RecipientListChangeAdapter
    implements ListDataListener {
        private RecipientListChangeAdapter() {
        }

        public void contentsChanged(ListDataEvent e) {
            this.doListChange();
        }

        public void intervalAdded(ListDataEvent e) {
            this.doListChange();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.doListChange();
        }

        private void doListChange() {
            BusySearchDialog.this.getBtnOk().setEnabled(BusySearchDialog.this.isSearchAllowed());
        }
    }

    private static class RecipientsFocusListener
    extends FocusAdapter {
        private RecipientsFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            ContactSearchTextField tfSource = (ContactSearchTextField)e.getSource();
            tfSource.addRecipient();
            tfSource.setText("");
        }
    }

    private class RecipientInputKeyAdapter
    extends KeyAdapter {
        private RecipientInputKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            BusySearchDialog form = BusySearchDialog.this;
            if (e.getKeyChar() == '\n') {
                ContactSearchTextField tfSource = (ContactSearchTextField)e.getSource();
                if (BusySearchDialog.this.getBtnOk().isEnabled() && tfSource.getText().length() == 0) {
                    form.disableDefaultAction = false;
                    BusySearchDialog.this.getBtnOk().getAction().actionPerformed(null);
                } else {
                    tfSource.setText("");
                    form.disableDefaultAction = true;
                }
            }
        }
    }

    private class BtnAddressBookAction
    extends AbstractAction {
        private BtnAddressBookAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ArrayList allRecipient = new ArrayList();
            this.fillRecipientListFromDescriptionsList(BusySearchDialog.createRecipeintDescriptionsList(BusySearchDialog.this.modelTo), allRecipient);
            this.fillRecipientListFromDescriptionsList(BusySearchDialog.createRecipeintDescriptionsList(BusySearchDialog.this.modelCc), allRecipient);
            this.fillRecipientListFromDescriptionsList(BusySearchDialog.createRecipeintDescriptionsList(BusySearchDialog.this.modelBc), allRecipient);
            DLSelectorDialog d = new DLSelectorDialog(BusySearchDialog.this, (List)allRecipient, (MVCController)BusySearchDialog.this.getController());
            d.setVisible(true);
        }

        private void fillRecipientListFromDescriptionsList(ArrayList source, ArrayList destination) {
            int nSize = source.size();
            for (int i = 0; i < nSize; ++i) {
                destination.add(((RecipientDescription)source.get(i)).getRecipient());
            }
        }
    }

    static class ListLabel
    extends OrientableLabel {
        private RecipientDescription recipientDescription = new RecipientDescription();

        public ListLabel(IRecipient recipient) {
            this.recipientDescription = new RecipientDescription(recipient);
        }

        public ListLabel(RecipientDescription recipientDescription) {
            this.recipientDescription = recipientDescription;
        }

        public RecipientDescription getRecipientDescription() {
            return this.recipientDescription;
        }

        public String toString() {
            return this.recipientDescription.getRecipient().getAddressable().getDisplayName();
        }
    }
}

