/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.components.AbstractCancelAction;
import com.appframework.components.AbstractOKAction;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewAppointment;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.busysearch.AvailableWithTreePanel;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchDialog;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrameActionList;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchUtils;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.ShedulesWithListPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.AbstractCalendarView;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.message.BusySearchEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusySearchFrame
extends ApplicationFrame<BusySearchFrameActionList, GWBusySearch> {
    private static Logger logger = Logger.getLogger(BusySearchFrame.class);
    public static final Color COLOR_OUT_OF_OFFICE = new Color(128, 128, 128);
    public static final Color COLOR_BUSY = new Color(192, 192, 192);
    public static final Color COLOR_TENTATIVE = new Color(230, 230, 230);
    public static final Color COLOR_AVAILABLE = Color.white;
    private GWBusySearch busySearch = null;
    private AvailableWithTreePanel availableWithTree;
    static Border sideBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    static Border lineBorder = BorderFactory.createLineBorder(Color.darkGray, 1);
    private JButton btnOK;
    private JButton btnRequest;
    private ActionNewAppointment actionNewAppointment;
    public static final int CELL_WIDTH = 26;
    private ShedulesWithListPanel shedulesWithListPanel;
    private BtnInviteToMeetingAction inviteToMeetingAction = new BtnInviteToMeetingAction();
    private JLabel searchingIndicator;
    private JLabel lblOneOfAll;
    private int recipientCount = 0;
    private int recipientCompleted = 0;
    private JPanel searchingIndicatorPanel;
    private JTabbedPane tpCalendarView = new OrientableTabbedPane();
    private GWBusySearch.GWBusySearchListener listener = new BusySearchListener();
    private com.novell.gw.message.BusySearchListener nativeListener = new NativeBusySearchListener();
    private ApplicationFrame invokerFrame;

    public BusySearchFrame(GWBusySearch busySearch, MVCController parentController, String userGuid, ApplicationFrame theInvokerFrame) {
        this(busySearch, parentController, userGuid);
        this.invokerFrame = theInvokerFrame;
    }

    public BusySearchFrame(GWBusySearch busySearch, MVCController parentController, String userGuid) {
        super(StringResources.CHOOSE_APPOINTMENT_TIME, "BUSY_SEARCH_FRAME", userGuid);
        assert (parentController instanceof Application);
        this.setController(new BusySearchFrameActionList(this, parentController));
        this.setDefaultCloseOperation(2);
        this.buildUI();
        this.setMVCModel(busySearch);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public Component getComponentAfter(Container aContainer, Component aComponent) {
                Component componentAfter = super.getComponentAfter(aContainer, aComponent);
                if (aComponent instanceof ShedulesWithListPanel) {
                    return ((AbstractCalendarView)aComponent).getDefaultComponent();
                }
                return componentAfter;
            }
        });
    }

    private void buildUI() {
        this.setIconImage(ImageResources.ACT_BUSYSEARCH.getImage());
        Container cp = this.getContentPane();
        cp.setComponentOrientation(UIUtils.getComponentOrientation());
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.buildCentralPanel(), "Center");
        cp.add((Component)this.buildButtonsPanel(), "South");
    }

    private JPanel buildCentralPanel() {
        OrientablePanel content = new OrientablePanel(new BorderLayout());
        this.buildAvailableTimesPanel();
        this.tpCalendarView.add(StringResources.AVAILABLE_TIMES, this.availableWithTree);
        this.buildIndividualShedulePanel();
        this.tpCalendarView.add(StringResources.INDIVIDUAL_SCHEDULES, this.shedulesWithListPanel);
        this.tpCalendarView.setSelectedIndex(1);
        content.add((Component)this.tpCalendarView, "Center");
        content.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return content;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.shedulesWithListPanel.selectDefaultComponent();
        }
    }

    private JPanel buildButtonsPanel() {
        OrientablePanel result = new OrientablePanel(new BorderLayout());
        OrientablePanel buttonPanel = new OrientablePanel();
        this.btnOK = new JButton(new OKAction());
        this.btnRequest = new JButton(new RequestAction());
        this.btnRequest.setVisible(false);
        CancelAction cancelAction = new CancelAction();
        JButton btnCancel = new JButton(cancelAction);
        btnCancel.registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().setDefaultButton(this.btnOK);
        OS.addButtons(buttonPanel, this.btnOK, this.btnRequest, btnCancel);
        this.buildSearchingIndicatorPanel();
        result.add((Component)buttonPanel, "After");
        result.add((Component)this.createLegendPanel(), "Before");
        result.add((Component)this.searchingIndicatorPanel, "South");
        return result;
    }

    private JPanel createLegendPanel() {
        OrientablePanel content = new OrientablePanel();
        EmptyBorder border = content.getComponentOrientation().isLeftToRight() ? new EmptyBorder(0, 0, 0, 15) : new EmptyBorder(0, 15, 0, 0);
        content.add(BusySearchFrame.buildLegendLabel(COLOR_OUT_OF_OFFICE));
        OrientableLabel label = new OrientableLabel(StringResources.OUT_OF_OFFICE);
        label.setBorder(border);
        content.add(label);
        content.add(BusySearchFrame.buildLegendLabel(COLOR_BUSY));
        label = new OrientableLabel(StringResources.BUSY);
        label.setBorder(border);
        content.add(label);
        content.add(BusySearchFrame.buildLegendLabel(COLOR_TENTATIVE));
        label = new OrientableLabel(StringResources.TENTATIVE);
        label.setBorder(border);
        content.add(label);
        return content;
    }

    private void buildSearchingIndicatorPanel() {
        this.searchingIndicatorPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.searchingIndicator = new OrientableLabel(StringResources.PERFORMING_BUSY_SEARCH + ' ');
        this.searchingIndicator.setBorder(BorderFactory.createLoweredBevelBorder());
        this.searchingIndicator.setIcon(ImageResources.ICON_BUSY_SEARCH_SEARCHING);
        c.ipadx = 10;
        this.searchingIndicatorPanel.add((Component)this.searchingIndicator, c);
        this.lblOneOfAll = new OrientableLabel(" ");
        this.lblOneOfAll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.lblOneOfAll.setHorizontalAlignment(0);
        c.ipadx = 50;
        c.gridx = 1;
        c.fill = 1;
        this.searchingIndicatorPanel.add((Component)this.lblOneOfAll, c);
        OrientableLabel lblLast = new OrientableLabel(" ");
        lblLast.setBorder(BorderFactory.createLoweredBevelBorder());
        c.weightx = 1.0;
        c.gridx = 2;
        this.searchingIndicatorPanel.add((Component)lblLast, c);
        this.searchingIndicatorPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    private static JLabel buildLegendLabel(Color color) {
        Dimension dim = new Dimension(14, 13);
        OrientableLabel result = new OrientableLabel();
        result.setPreferredSize(dim);
        result.setMinimumSize(dim);
        result.setOpaque(true);
        result.setBackground(color);
        result.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        return result;
    }

    private void buildAvailableTimesPanel() {
        this.availableWithTree = new AvailableWithTreePanel(this.busySearch, new OrientableButton(this.inviteToMeetingAction), this.getController());
        this.availableWithTree.setBorder(sideBorder);
    }

    private void buildIndividualShedulePanel() {
        this.shedulesWithListPanel = new ShedulesWithListPanel(this.busySearch, new JButton(this.inviteToMeetingAction), this.getController());
        this.shedulesWithListPanel.setBorder(sideBorder);
    }

    private void refreshView() {
        this.recipientCount = this.busySearch.getRecipientSize();
        this.recipientCompleted = this.busySearch.getCompletedRecipientSize();
        boolean isStillWorking = this.busySearch.isStillWorking();
        logger.debug((Object)("search completed - " + !isStillWorking));
        this.refreshSearchingIndicator(isStillWorking);
        this.availableWithTree.setMVCModel(this.busySearch);
        this.shedulesWithListPanel.setMVCModel(this.busySearch);
    }

    private void refreshSearchingIndicator(boolean stillWorking) {
        int failed = this.busySearch.getRecipientDescriptionsList().getFailedSize();
        if (failed == 0) {
            this.searchingIndicator.setText(StringResources.PERFORMING_BUSY_SEARCH + ' ');
            this.searchingIndicator.setIcon(ImageResources.ICON_BUSY_SEARCH_SEARCHING);
            this.searchingIndicatorPanel.setVisible(stillWorking);
            this.lblOneOfAll.setVisible(stillWorking);
            this.lblOneOfAll.setText(StringResources.formatString(StringResources.NUM_OF_NUM, Integer.toString(this.recipientCompleted), Integer.toString(this.recipientCount)));
        } else {
            this.searchingIndicator.setIcon(null);
            this.searchingIndicator.setText(StringResources.formatString(StringResources.UNDELIVERABLE_ON_C, Integer.toString(failed), Integer.toString(this.recipientCount)));
            this.lblOneOfAll.setText(" ");
        }
    }

    public void setNewAppointmentAction(ActionNewAppointment theAction) {
        this.actionNewAppointment = theAction;
        this.btnOK.setVisible(false);
        this.btnRequest.setVisible(true);
        this.getRootPane().setDefaultButton(this.btnRequest);
    }

    @Override
    public void setMVCModel(GWBusySearch model) {
        if (this.busySearch != null) {
            if (this.busySearch.isStillWorking()) {
                this.busySearch.cancel();
            }
            this.busySearch.removeGWBusySearchListener(this.listener);
        }
        this.btnOK.setEnabled(false);
        logger.debug((Object)"setMVCModel entered");
        this.busySearch = model;
        this.busySearch.addGWBusySearchListener(this.listener);
        this.busySearch.getNativeBusySearch().addBusySearchListener(this.nativeListener);
        this.refreshView();
        logger.debug((Object)"setMVCModel exited");
    }

    @Override
    public void dispose() {
        this.busySearch.cancel();
        super.dispose();
    }

    private class NativeBusySearchListener
    implements com.novell.gw.message.BusySearchListener {
        private NativeBusySearchListener() {
        }

        public void moreBusySearchResultsAvailable(BusySearchEvent e) {
        }

        public void busySearchResultsComplete(BusySearchEvent e) {
            BusySearchFrame.this.btnOK.setEnabled(true);
        }
    }

    private class BusySearchListener
    implements GWBusySearch.GWBusySearchListener {
        private BusySearchListener() {
        }

        public void busySearchUpdated() {
            if (SwingUtilities.isEventDispatchThread()) {
                BusySearchFrame.this.refreshView();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BusySearchFrame.this.refreshView();
                    }
                });
            }
        }

        public void recipientDescriptionRemoved(RecipientDescription removed) {
            BusySearchFrame.this.availableWithTree.removeRecipient(removed);
            BusySearchFrame.this.shedulesWithListPanel.removeRecipient(removed);
        }
    }

    class BtnInviteToMeetingAction
    extends AbstractAction {
        public BtnInviteToMeetingAction() {
            super(StringResources.INVITE_TO_MEETING);
        }

        public void actionPerformed(ActionEvent e) {
            BusySearchDialog dlgInviteToMeeting = new BusySearchDialog(BusySearchFrame.this, BusySearchFrame.this.getController());
            dlgInviteToMeeting.setMVCModel(BusySearchFrame.this.busySearch);
            dlgInviteToMeeting.pack();
            dlgInviteToMeeting.setLocationRelativeTo(null);
            dlgInviteToMeeting.setVisible(true);
            if (!dlgInviteToMeeting.isOkActionProcessed()) {
                BusySearchFrame.this.btnOK.setEnabled(true);
            } else {
                BusySearchFrame.this.searchingIndicator.setVisible(true);
                if (!BusySearchUtils.hasValidRecipient(dlgInviteToMeeting.getRecepientDescriptinsList().getDistributionList())) {
                    JOptionPane.showMessageDialog(null, StringResources.BYSY_SEARCH_NO_VALID_USERS);
                    return;
                }
                try {
                    BusySearchFrame.this.btnOK.setEnabled(false);
                    String userGuid = ControlsUtils.getUserGuid(BusySearchFrame.this.getController());
                    GWBusySearch tempBusySeacrh = GWCommandManager.getInstance(userGuid).composeBusySearch(dlgInviteToMeeting.getRecepientDescriptinsList(), dlgInviteToMeeting.getStartDate(), dlgInviteToMeeting.getDaysCount(), BusySearchFrame.this.busySearch.getAppointmentTime());
                    BusySearchFrame.this.setMVCModel(tempBusySeacrh);
                }
                catch (GWCommandException e1) {
                    logger.error((Object)e1, (Throwable)e1);
                    BusySearchFrame.this.btnOK.setEnabled(true);
                }
            }
            dlgInviteToMeeting.dispose();
        }
    }

    class RequestAction
    extends AbstractAction {
        public RequestAction() {
            super(StringResources.REQUEST_MEETING_D);
        }

        public void actionPerformed(ActionEvent e) {
            if (BusySearchFrame.this.busySearch.isStillWorking()) {
                BusySearchFrame.this.busySearch.cancel();
            }
            BusySearchFrame.this.actionNewAppointment.setMVCModel(BusySearchFrame.this.busySearch);
            BusySearchFrame.this.actionNewAppointment.actionPerformed(null);
            ((BusySearchFrameActionList)BusySearchFrame.this.getController()).performAction(ActionKey.CANCEL_FRAME);
        }
    }

    private class OKAction
    extends AbstractOKAction {
        private OKAction() {
        }

        public void actionPerformed(ActionEvent e) {
            GlobalCommand com = new GlobalCommand(770, BusySearchFrame.this.busySearch);
            com.setAttribute((Object)AttributeKey.FRAME, BusySearchFrame.this.invokerFrame);
            ((BusySearchFrameActionList)BusySearchFrame.this.getController()).processCommand(com);
            ((BusySearchFrameActionList)BusySearchFrame.this.getController()).performAction(ActionKey.CANCEL_FRAME);
        }
    }

    private class CancelAction
    extends AbstractCancelAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ((BusySearchFrameActionList)BusySearchFrame.this.getController()).performAction(ActionKey.CANCEL_FRAME);
        }
    }
}

