/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

public class PositionInterval {
    private int startPosition = -1;
    private int endPosition = -1;

    public PositionInterval(int startPosition, int endPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException("startPosition less than 0: " + startPosition);
        }
        if (endPosition < 0) {
            throw new IllegalArgumentException("endPosition less than 0: " + endPosition);
        }
        this.endPosition = endPosition;
        this.startPosition = startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getLength() {
        return Math.abs(this.endPosition - this.startPosition);
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.startPosition + ',' + this.endPosition + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionInterval that = (PositionInterval)o;
        return this.startPosition == that.startPosition && this.endPosition == that.endPosition;
    }

    public int hashCode() {
        int result = this.startPosition;
        result = 31 * result + this.endPosition;
        return result;
    }
}

