/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.DragRectanglePanel;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.TimeBlockInfo;
import com.novell.gw.jclient.application.controls.busysearch.TimeGridPanelController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TimeGridPanel
extends DragRectanglePanel
implements MVCView {
    private static Logger logger = Logger.getLogger(TimeGridPanel.class);
    protected HashMap<String, List<VisibleIndividualInfo>> hmOutOfOffice = new HashMap();
    protected HashMap<String, List<VisibleIndividualInfo>> hmBusy = new HashMap();
    protected HashMap<String, List<VisibleIndividualInfo>> hmTentative = new HashMap();
    protected HashMap<String, List<VisibleIndividualInfo>> hmWorkshedule = new HashMap();
    protected Map<String, Integer> hmNewState = new HashMap<String, Integer>();
    protected Calendar gcStartDay = GWCalendarUtils.getToday();
    protected Calendar gcAppointmentTime = GWCalendarUtils.getToday();
    protected GWBusySearch busySearch = null;
    protected int daysCount = 7;
    protected boolean isOnlySelectedRecipientShowing = true;
    private TimeBlockInfo timeBlockInfo = new TimeBlockInfo();
    private MVCController mvcController;

    public TimeGridPanel(MVCController theParentController) {
        super(7, 96);
        this.mvcController = new TimeGridPanelController(this, theParentController);
        this.initCalendar();
        this.buildView();
        this.addKeyListener(new TGPKeyListener());
        this.setFocusable(true);
    }

    protected abstract boolean isDayEnd();

    protected abstract boolean isDayStart();

    protected abstract boolean prevRow();

    protected abstract boolean prevColumn();

    protected abstract boolean nextColumn();

    protected abstract boolean nextRow();

    protected void initCalendar() {
        this.gcStartDay.set(11, 0);
        this.gcStartDay.set(12, 0);
        this.gcStartDay.set(13, 0);
        this.gcStartDay.set(14, 0);
    }

    protected abstract void buildView();

    protected abstract void drawRectangles(Graphics var1, Map<String, List<VisibleIndividualInfo>> var2, Color var3, boolean var4);

    protected abstract void drawGrid(Graphics var1);

    protected abstract void setDaysCount(int var1);

    protected abstract void setAppointmentTime(TimeInterval var1);

    protected abstract Rectangle getLogicalRectangle(TimeInterval var1, int var2);

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawRectangles(g, this.hmWorkshedule, BusySearchFrame.COLOR_OUT_OF_OFFICE, false);
        this.drawGrid(g);
        this.drawRectangles(g, this.hmTentative, BusySearchFrame.COLOR_TENTATIVE, true);
        this.drawRectangles(g, this.hmBusy, BusySearchFrame.COLOR_BUSY, true);
        this.drawRectangles(g, this.hmOutOfOffice, BusySearchFrame.COLOR_OUT_OF_OFFICE, true);
        super.paint(g);
    }

    protected void updateRecPosition() {
        this.updatePhysicalCoordinates();
        this.refreshRects();
        this.repaint();
        this.scrollRectToVisible(this.recDragged);
        this.checkAvailableTimePosition(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e = this.localizeMouseEvent(e);
        super.mouseDragged(e);
        if (this.draggingMode != 0) {
            this.checkAvailableTimePosition(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e = this.localizeMouseEvent(e);
        super.mousePressed(e);
        this.checkAvailableTimePosition(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e = this.localizeMouseEvent(e);
        super.mouseReleased(e);
    }

    private MouseEvent localizeMouseEvent(MouseEvent e) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), this.getWidth() - e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }
        return e;
    }

    protected void checkAvailableTimePosition(boolean isAtStart) {
        this.initCalendar();
        if (this.updateRecipientDescriptions() || isAtStart) {
            Command com = new Command(690, this.busySearch.getRecipientDescriptionsList());
            this.mvcController.processCommand(com);
        }
    }

    protected boolean updateRecipientDescriptions() {
        Rectangle appointment = new Rectangle(this.getSelectedColumn(), this.getSelectedRow(), this.getSelectedWidth(), this.getSelectedHeight());
        if (appointment.width <= 0) {
            appointment.width = 1;
        }
        if (appointment.height <= 0) {
            appointment.height = 1;
        }
        this.hmNewState.clear();
        this.timeBlockInfo = new TimeBlockInfo();
        this.checkIntersectedTimes(appointment, this.hmWorkshedule, 4);
        this.checkIntersectedTimes(appointment, this.hmOutOfOffice, 3);
        this.checkIntersectedTimes(appointment, this.hmTentative, 1);
        this.checkIntersectedTimes(appointment, this.hmBusy, 2);
        TimeInterval ti = this.getAppointmentTimeInterval();
        this.busySearch.setAppointmentTime(ti);
        this.timeBlockInfo.setTimeInterval(ti);
        Command com = new Command(680, this.timeBlockInfo);
        this.mvcController.processCommand(com);
        return this.isRecipientStateChanged();
    }

    protected TimeInterval getAppointmentTimeInterval() {
        return new TimeInterval();
    }

    protected void checkIntersectedTimes(Rectangle appointmenTime, Map<String, List<VisibleIndividualInfo>> map, int newState) {
        for (RecipientDescription recipientDescription : this.busySearch.getRecipientDescriptionsList().getResolvedList()) {
            IRecipient recipient = recipientDescription.getRecipient();
            List<VisibleIndividualInfo> list = map.get(ABUtils.getRecipientID(recipient));
            if (list == null || list.isEmpty()) continue;
            for (VisibleIndividualInfo visibleIndividualInfo : list) {
                Rectangle r = visibleIndividualInfo.getVisibleRectangle();
                if (!appointmenTime.intersects(r)) continue;
                this.hmNewState.put(ABUtils.getRecipientID(recipient), newState);
                this.timeBlockInfo = new TimeBlockInfo(visibleIndividualInfo.getTimeBlockInfo());
            }
        }
    }

    private boolean isRecipientStateChanged() {
        boolean result = false;
        List<RecipientDescription> recipientList = this.busySearch.getRecipientDescriptionsList().getResolvedList();
        for (RecipientDescription rd : recipientList) {
            Integer state = this.hmNewState.get(ABUtils.getRecipientID(rd.getRecipient()));
            if (state == null) {
                if (rd.getState() == 0) continue;
                result = true;
                rd.setState(0);
                continue;
            }
            if (state.intValue() == rd.getState()) continue;
            result = true;
            rd.setState(state);
        }
        return result;
    }

    void processRecipientListChange() {
        this.createRectangles();
        this.repaint();
        this.updateRecipientDescriptions();
    }

    protected void createRectangles() {
        this.hmOutOfOffice.clear();
        this.hmBusy.clear();
        this.hmTentative.clear();
        this.hmWorkshedule.clear();
        List<RecipientDescription> lst = this.busySearch.getRecipientDescriptionsList().getResolvedList();
        int nSize = lst.size();
        for (int recipientIndex = 0; recipientIndex < nSize; ++recipientIndex) {
            RecipientDescription rd = lst.get(recipientIndex);
            if (this.isOnlySelectedRecipientShowing && !rd.isSelected()) continue;
            IRecipient recipient = rd.getRecipient();
            this.fillRectanglesMap(recipient, recipientIndex, this.busySearch.getOutOfOfficeList(recipient), this.hmOutOfOffice);
            this.fillRectanglesMap(recipient, recipientIndex, this.busySearch.getBusyList(recipient), this.hmBusy);
            this.fillRectanglesMap(recipient, recipientIndex, this.busySearch.getTentativeList(recipient), this.hmTentative);
            this.fillRectanglesMap(recipient, recipientIndex, this.busySearch.getWorkshedule(recipient), this.hmWorkshedule);
        }
    }

    private void fillRectanglesMap(IRecipient recipient, int recipientIndex, List list, Map<String, List<VisibleIndividualInfo>> map) {
        if (list == null) {
            return;
        }
        this.initCalendar();
        int nSize = list.size();
        String strId = ABUtils.getRecipientID(recipient);
        for (int i = 0; i < nSize; ++i) {
            TimeBlockInfo tbi = (TimeBlockInfo)list.get(i);
            List<VisibleIndividualInfo> al = map.get(strId);
            if (al == null) {
                al = new ArrayList<VisibleIndividualInfo>();
            }
            al.add(new VisibleIndividualInfo(this.getLogicalRectangle(tbi.getTimeInterval(), recipientIndex), tbi));
            map.put(ABUtils.getRecipientID(recipient), al);
        }
    }

    public void setController(MVCController theController) {
        this.mvcController = theController;
    }

    public MVCController getController() {
        return this.mvcController;
    }

    public void setMVCModel(Object theModel) {
        this.busySearch = (GWBusySearch)theModel;
        this.setStartDay(this.busySearch.getSearchStartTime());
        this.setDaysCount(this.busySearch.getDaysCount());
        this.setAppointmentTime(this.busySearch.getAppointmentTime());
        this.createRectangles();
        this.repaint();
        this.checkAvailableTimePosition(true);
    }

    public Object getMVCModel() {
        return null;
    }

    public void setStartDay(Date theStartDate) {
        this.gcStartDay.setTime(theStartDate);
    }

    protected int calculateShiftHours(TimeInterval theTimeInterval) {
        Calendar timeIntervalStartDay = Calendar.getInstance();
        timeIntervalStartDay.setTimeInMillis(theTimeInterval.getStartDate());
        timeIntervalStartDay.set(11, 0);
        timeIntervalStartDay.set(12, 0);
        timeIntervalStartDay.set(13, 0);
        timeIntervalStartDay.set(14, 0);
        Calendar viewStartDay = Calendar.getInstance();
        viewStartDay.setTimeInMillis(this.gcStartDay.getTimeInMillis());
        viewStartDay.set(11, 0);
        viewStartDay.set(12, 0);
        viewStartDay.set(13, 0);
        viewStartDay.set(14, 0);
        int shiftHours = 0;
        if ((timeIntervalStartDay.getTimeInMillis() - viewStartDay.getTimeInMillis()) % 86400000L == 3600000L) {
            shiftHours = -1;
        } else if ((timeIntervalStartDay.getTimeInMillis() - viewStartDay.getTimeInMillis()) % 86400000L == 82800000L) {
            shiftHours = 1;
        }
        return shiftHours;
    }

    private class TGPKeyListener
    extends KeyAdapter {
        private TGPKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                if (!e.isShiftDown()) {
                    TimeGridPanel.this.nextColumn();
                }
                if (TimeGridPanel.this.recDragged.x + TimeGridPanel.this.recDragged.width <= TimeGridPanel.this.getWidth() && (float)TimeGridPanel.this.selectedColumn * TimeGridPanel.this.columnWidth < (float)TimeGridPanel.this.getWidth()) {
                    TimeGridPanel.this.updateRecPosition();
                }
            } else if (e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                if (!e.isShiftDown()) {
                    TimeGridPanel.this.prevColumn();
                }
                TimeGridPanel.this.updateRecPosition();
            }
            if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                if (!e.isShiftDown()) {
                    TimeGridPanel.this.nextRow();
                }
                if (TimeGridPanel.this.recDragged.x + TimeGridPanel.this.recDragged.width <= TimeGridPanel.this.getWidth() && (float)TimeGridPanel.this.selectedColumn * TimeGridPanel.this.columnWidth < (float)TimeGridPanel.this.getWidth()) {
                    TimeGridPanel.this.updateRecPosition();
                    TimeGridPanel.this.getController().processCommand(new Command(1370));
                }
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                if (!e.isShiftDown()) {
                    TimeGridPanel.this.prevRow();
                }
                TimeGridPanel.this.updateRecPosition();
                TimeGridPanel.this.getController().processCommand(new Command(1370));
            }
        }
    }

    static class VisibleIndividualInfo {
        private Rectangle visibleRectangle;
        private TimeBlockInfo timeBlockInfo;

        public VisibleIndividualInfo(Rectangle theVisibleRectangle, TimeBlockInfo theTimeBlockInfo) {
            this.visibleRectangle = theVisibleRectangle;
            this.timeBlockInfo = theTimeBlockInfo;
        }

        public Rectangle getVisibleRectangle() {
            return this.visibleRectangle;
        }

        public TimeBlockInfo getTimeBlockInfo() {
            return this.timeBlockInfo;
        }
    }
}

