/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.components;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.components.ComponentUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.log4j.Logger;

public class GradientPanel
extends SkinnablePanel {
    private static Logger logger = Logger.getLogger(GradientPanel.class);
    private boolean mouseOn = false;
    private boolean mousePressed = false;
    private GWPopupMenu popupMenu = null;
    private GradientPanelMouseListener mouseListener = new GradientPanelMouseListener();

    public GradientPanel() {
        this.skinnableDelegate.clearPropertyBindings();
        this.skinnableDelegate.putSkinProperty(SkinProperty.HIGHLIGHTED_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.skinnableDelegate.putSkinProperty(SkinProperty.HEADER_TEXT_COLOR, ComponentProperty.CUSTOM);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(this.mouseListener);
        this.setOpaque(false);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mouseOn) {
            this.setForeground((Color)this.getClientProperty((Object)SkinProperty.HIGHLIGHTED_TEXT_COLOR));
            UIUtils.paintGradient(g, this, "both", true, this.mousePressed);
        } else {
            this.setForeground((Color)this.getClientProperty((Object)SkinProperty.HEADER_TEXT_COLOR));
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        for (Component child : this.getComponents()) {
            ComponentUtils.propagateForeground(fg, child);
        }
    }

    public GWPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(GWPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }

    public void propagateMouseListener() {
        for (Component child : this.getComponents()) {
            GradientPanel.propagateMouseListener(this, this.mouseListener);
        }
    }

    private static void propagateMouseListener(Component component, MouseListener mouseListener) {
        boolean hasThisListener = false;
        for (MouseListener listener : component.getMouseListeners()) {
            if (listener != mouseListener) continue;
            hasThisListener = true;
            break;
        }
        if (!hasThisListener) {
            component.addMouseListener(mouseListener);
        }
        if (component instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)component).getComponents()) {
                GradientPanel.propagateMouseListener(child, mouseListener);
            }
        }
    }

    protected void showPopup(MouseEvent e) {
        if (this.popupMenu == null) {
            return;
        }
        this.popupMenu.show(this, 0, this.getHeight());
    }

    private class GradientPanelMouseListener
    extends MouseAdapter {
        private GradientPanelMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            GradientPanel.this.mouseOn = true;
            GradientPanel.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            GradientPanel.this.mouseOn = false;
            GradientPanel.this.repaint();
        }

        public void mouseClicked(MouseEvent e) {
            GradientPanel.this.showPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            GradientPanel.this.mousePressed = true;
            GradientPanel.this.repaint();
        }

        public void mouseReleased(MouseEvent e) {
            GradientPanel.this.mousePressed = false;
            GradientPanel.this.repaint();
        }
    }
}

