/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import java.io.Serializable;

public class AddressSerializable
implements Serializable {
    private final String emailAddress;
    private final String displayName;
    private final boolean isContact;

    public AddressSerializable(String emailAddress, String displayName, boolean isContact) {
        this.emailAddress = emailAddress;
        this.displayName = displayName;
        this.isContact = isContact;
    }

    public AddressSerializable(IAddressable addressable) {
        this(addressable.getEmailAddress(), addressable.getDisplayName(), addressable instanceof IContact);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public IAddressable getAddressable() {
        if (this.isContact) {
            return ContactUtils.getAddress(this.emailAddress, this.displayName);
        }
        return APIAbWrapperManager.createAddress(this.emailAddress, this.displayName);
    }
}

