/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.contactsearch.AbstractAddressTransferHandler;
import com.novell.gw.jclient.application.controls.contactsearch.AddressSerializable;
import com.novell.gw.jclient.application.controls.contactsearch.AddressesTransferrable;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientList;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class ComboFieldTransferHandler
extends AbstractAddressTransferHandler {
    private static final Logger logger = Logger.getLogger(ComboFieldTransferHandler.class);

    public ComboFieldTransferHandler(ContactSearchComboField comboField, RecipientList recipientList) {
        super(comboField, recipientList);
    }

    protected Transferable createTransferable(JComponent c) {
        String text = this.getComboField().getSelectedText();
        if (text == null || text.equals("")) {
            return new StringSelection("");
        }
        ArrayList<AddressSerializable> addressSerializableList = new ArrayList<AddressSerializable>();
        List<IRecipient> recipientList = this.getRecipientList().getModel().getRecipients();
        for (String name : ContactUtils.parse(text)) {
            boolean foundRecipient = false;
            for (IRecipient recipient : recipientList) {
                if (!recipient.getAddressable().getDisplayName().equals(name)) continue;
                addressSerializableList.add(new AddressSerializable(recipient.getAddressable()));
                foundRecipient = true;
                break;
            }
            if (foundRecipient) continue;
            addressSerializableList.add(new AddressSerializable(APIAbWrapperManager.createAddress(name, name)));
        }
        return new AddressesTransferrable(text, addressSerializableList.toArray(new AddressSerializable[addressSerializableList.size()]));
    }

    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        super.exportToClipboard(comp, clip, action);
        if (action == 2) {
            try {
                this.getComboField().getDocument().remove(this.getComboField().getSelectionStart(), this.getComboField().getSelectedText().length());
            }
            catch (BadLocationException e) {
                logger.error((Object)e);
            }
        }
    }

    public boolean importData(JComponent comp, Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(AddressesTransferrable.addressFlavor)) {
                List<IRecipient> recipients = this.getRecipients(transferable);
                if (!recipients.isEmpty()) {
                    this.getRecipientList().getModel().addRecipients(recipients);
                    this.getComboField().setText(ContactUtils.toString(recipients));
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }
}

