/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.appframework.listener.ListenerManager;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.contactsearch.AddressesTransferrable;
import com.novell.gw.jclient.application.controls.contactsearch.ComboFieldPopup;
import com.novell.gw.jclient.application.controls.contactsearch.ComboFieldTransferHandler;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchTextField;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientList;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListChangeListener;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListModel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactSearchComboField
extends ContactSearchTextField
implements MVCView {
    private static Logger logger = Logger.getLogger(ContactSearchComboField.class);
    private ComboFieldPopup recipientPopup;
    private RecipientList recipientList;
    private MVCController controller;
    private RecipientCopyType copyType;
    private boolean showRecipientList = true;

    public ContactSearchComboField(MVCController controller, RecipientCopyType copyType) {
        this.controller = controller;
        this.copyType = copyType;
        this.init();
    }

    private void init() {
        this.recipientList = new RecipientList(this.getController(), this);
        this.recipientPopup = new ComboFieldPopup(this);
        OrientableScrollPane scrollPane = new OrientableScrollPane(this.recipientList);
        scrollPane.setBorder(null);
        this.recipientPopup.add(scrollPane);
        ListenerManager listenerManager = ControlsUtils.getListenerManager(this.getController());
        listenerManager.addListener(this, new CSCFFocusListener(), ListenerType.FOCUS_LISTENER);
        listenerManager.addListener(this, new CSCFKeyListener(), ListenerType.KEY_LISTENER);
        this.addHierarchyBoundsListener(new CSCFHierarchyBoundsListener());
        this.setDragEnabled(true);
        this.setTransferHandler(new ComboFieldTransferHandler(this, this.recipientList));
    }

    public RecipientCopyType getCopyType() {
        return this.copyType;
    }

    public RecipientList getRecipientList() {
        return this.recipientList;
    }

    public boolean isShowRecipientList() {
        return this.showRecipientList;
    }

    public void setShowRecipientList(boolean showRecipientList) {
        this.showRecipientList = showRecipientList;
    }

    public void addRecipientListChangeListener(RecipientListChangeListener listener) {
        this.getRecipientList().getModel().addRecipientListChangeListener(listener);
    }

    public void removeRecipientListChangeListener(RecipientListChangeListener listener) {
        this.getRecipientList().getModel().removeRecipientListChangeListener(listener);
    }

    @Override
    public void paste() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (clipboard.isDataFlavorAvailable(AddressesTransferrable.addressFlavor)) {
                super.paste();
            } else if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.getText());
                builder.append((String)clipboard.getData(DataFlavor.stringFlavor));
                List<String> names = ContactUtils.parse(builder.toString());
                if (names.size() == 1) {
                    this.setText(names.get(0));
                    this.restartTimer();
                } else {
                    super.paste();
                    if (!this.recipientList.getModel().isEmpty()) {
                        this.recipientPopup.showMe();
                    }
                    this.requestFocus();
                }
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }

    @Override
    protected boolean isValidString(String str) {
        boolean isValidString = super.isValidString(str);
        if (!isValidString && !str.equals(" ")) {
            this.processSearchEvent(this.search(this.getText()));
            this.setText("");
        }
        return isValidString;
    }

    public List<IRecipient> getRecipients(RecipientCopyType copyType) {
        String text;
        RecipientListModel model = this.recipientList.getModel();
        if (!(this.recipientPopup.isShowing() && !model.isEmpty() || (text = this.getText()).equals("") || ContactUtils.toString(model.getRecipients()).equals(text))) {
            IAddressable addressable = ContactUtils.getAddressForName(text);
            model.addRecipient(APIAbWrapperManager.createRecipient(addressable, copyType));
        }
        return this.recipientList.getModel().getRecipients();
    }

    public List<IRecipient> getRecipients() {
        return this.getRecipients(this.getCopyType());
    }

    public void setController(MVCController controller) {
        this.controller = controller;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void clear() {
        this.recipientList.getModel().removeAllRecipients();
        this.setText("");
    }

    public void hidePopup() {
        this.recipientPopup.hideMe();
    }

    public void showPopup() {
        if (!this.recipientPopup.isVisible()) {
            this.recipientPopup.showMe();
            this.recipientList.requestFocus();
        }
    }

    public void setRecipients(List<IRecipient> recipients) {
        RecipientListModel model = this.recipientList.getModel();
        model.addRecipients(recipients);
        String text = ContactUtils.toString(model.getRecipients());
        this.setInitialValue(text);
        this.setText(text);
    }

    @Override
    public boolean isDirty() {
        return !this.initialValue.equals(ContactUtils.toString(this.recipientList.getModel().getRecipients()));
    }

    private class CSCFHierarchyBoundsListener
    implements HierarchyBoundsListener {
        private CSCFHierarchyBoundsListener() {
        }

        public void ancestorMoved(HierarchyEvent e) {
            if (ContactSearchComboField.this.recipientPopup.isShowing()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!ContactSearchComboField.this.recipientPopup.isShowing()) {
                            return;
                        }
                        int x = ContactSearchComboField.this.getLocationOnScreen().x;
                        int y = ContactSearchComboField.this.getLocationOnScreen().y;
                        int height = ContactSearchComboField.this.getHeight();
                        ContactSearchComboField.this.recipientPopup.setLocation(x, y + height);
                    }
                });
            }
        }

        public void ancestorResized(HierarchyEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (ContactSearchComboField.this.recipientPopup.isVisible()) {
                        Dimension dimension = ContactSearchComboField.this.recipientPopup.getSize();
                        dimension.width = ContactSearchComboField.this.getWidth();
                        ContactSearchComboField.this.recipientPopup.setPreferredSize(dimension);
                        ContactSearchComboField.this.recipientPopup.validate();
                    }
                }
            });
        }
    }

    private class CSCFKeyListener
    extends KeyAdapter {
        private CSCFKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if ((ContactSearchComboField.this.foundContacts.isEmpty() || ContactSearchComboField.this.getText().equals("")) && key == 40 && ContactSearchComboField.this.recipientList.isVisible() && ContactSearchComboField.this.recipientList.getModel().getRecipients().size() > 0) {
                if (OS.isMacOS()) {
                    SwingUtilities.getWindowAncestor(ContactSearchComboField.this.recipientList).setFocusableWindowState(true);
                }
                ContactSearchComboField.this.recipientList.requestFocus();
                ContactSearchComboField.this.recipientList.selectAtIndex(0);
            }
        }
    }

    private class CSCFFocusListener
    implements FocusListener {
        private CSCFFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            Component component = event.getOppositeComponent();
            if (RecipientList.isParentInstanceOfPopup(component)) {
                return;
            }
            if (!(component != null && SwingUtilities.isDescendingFrom(component, ContactSearchComboField.this.recipientPopup) || ContactSearchComboField.this.recipientPopup.isVisible() || ContactSearchComboField.this.recipientList.getModel().isEmpty() || !ContactSearchComboField.this.isShowRecipientList() || !ContactSearchComboField.this.isShowing())) {
                ContactSearchComboField.this.recipientPopup.showMe();
                ContactSearchComboField.this.requestFocus();
            }
        }

        public void focusLost(FocusEvent event) {
            Component component = event.getOppositeComponent();
            if (RecipientList.isParentInstanceOfPopup(component)) {
                return;
            }
            if (component == null || !SwingUtilities.isDescendingFrom(component, ContactSearchComboField.this.recipientPopup) && !component.equals(ContactSearchComboField.this.getRootPane()) && !component.equals(ContactSearchComboField.this.recipientPopup.getRootPane())) {
                ContactSearchComboField.this.recipientPopup.hideMe();
                String text = ContactSearchComboField.this.getText();
                RecipientListModel model = ContactSearchComboField.this.recipientList.getModel();
                if (!text.equals("") && !text.equals(ContactUtils.toString(model.getRecipients()))) {
                    IAddressable addressable = ContactUtils.getAddressForName(text);
                    model.addRecipient(APIAbWrapperManager.createRecipient(addressable, ContactSearchComboField.this.getCopyType()));
                }
                ContactSearchComboField.this.setText(ContactUtils.toString(model.getRecipients()));
            }
        }
    }
}

