/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.Contact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactUtils {
    private static final Logger logger = Logger.getLogger(ContactUtils.class);
    public static final String CONTACT_SEPARATOR = "; ";
    protected static final String[] DELIMETERS = new String[]{";", "\n"};

    public static String toString(List list) {
        StringBuilder builder = new StringBuilder();
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            IAddressable addressable = ContactUtils.getAddressable(iterator.next());
            builder.append(addressable.getDisplayName());
            while (iterator.hasNext()) {
                builder.append(CONTACT_SEPARATOR);
                addressable = ContactUtils.getAddressable(iterator.next());
                builder.append(addressable.getDisplayName());
            }
        }
        return builder.toString();
    }

    private static IAddressable getAddressable(Object o) {
        if (o instanceof IAddressable) {
            return (IAddressable)o;
        }
        if (o instanceof IRecipient) {
            return ((IRecipient)o).getAddressable();
        }
        return null;
    }

    public static IContact findContactByEmail(String searchText) {
        try {
            Contact contact = EngineCommandManager.getAddressBookManager().findContactByEmail(searchText);
            if (contact != null) {
                return APIAbWrapperManager.getContact(contact);
            }
        }
        catch (EngineException e) {
            logger.error((Object)("e: " + (Object)((Object)e)));
        }
        return null;
    }

    public static IContact findContactByName(String searchText) {
        try {
            Contact contact = EngineCommandManager.getAddressBookManager().findContactByName(searchText);
            if (contact != null) {
                return APIAbWrapperManager.getContact(contact);
            }
        }
        catch (EngineException e) {
            logger.error((Object)("e: " + (Object)((Object)e)));
        }
        return null;
    }

    public static IAddressable getAddressForName(String name) {
        IAddressable addressable = ContactUtils.findContactByName(name);
        if (addressable == null || !addressable.getDisplayName().equals(name) && name.contains("@")) {
            addressable = APIAbWrapperManager.createAddress(name, name);
        }
        return addressable;
    }

    public static IAddressable getAddress(String emailAddress, String displayName) {
        List<IContact> contacts = ContactUtils.findContactsByName(displayName);
        for (IContact contact : contacts) {
            if (!contact.getEmailAddress().equals(emailAddress)) continue;
            return contact;
        }
        return APIAbWrapperManager.createAddress(displayName, emailAddress);
    }

    public static List<IContact> findContactsByName(String searchText, AddressBook addressBook) {
        ArrayList<IContact> contacts = new ArrayList<IContact>();
        try {
            IItemList list = APIWrapperManager.getItemList(addressBook.findContactsByName(searchText));
            if (list != null) {
                for (IItem item : ControlsUtils.itemListToList(list)) {
                    logger.debug((Object)("      " + ((IContact)item).getEmailAddress()));
                    contacts.add((IContact)item);
                }
            }
        }
        catch (EngineException e) {
            logger.error((Object)("e: " + (Object)((Object)e)));
        }
        return contacts;
    }

    public static IContact findContactByName(String searchText, AddressBook addressBook) {
        try {
            return APIAbWrapperManager.getContact(addressBook.findContactByName(searchText));
        }
        catch (EngineException e) {
            logger.error((Object)("e: " + (Object)((Object)e)));
            return null;
        }
    }

    public static List<IContact> findContactsByName(String searchText) {
        ArrayList<IContact> contacts = new ArrayList<IContact>();
        AddressBookManager manager = EngineCommandManager.getAddressBookManager();
        logger.debug((Object)"------------------------");
        logger.debug((Object)("searchText: " + searchText));
        try {
            IItemList list = APIWrapperManager.getItemList(manager.findContactsByName(searchText));
            if (list != null) {
                for (IItem item : ControlsUtils.itemListToList(list)) {
                    logger.debug((Object)("      " + ((IContact)item).getEmailAddress()));
                    contacts.add((IContact)item);
                }
            }
        }
        catch (EngineException e) {
            logger.error((Object)("e: " + (Object)((Object)e)));
        }
        return contacts;
    }

    public static List<String> parse(String s) {
        List<String> result = new ArrayList<String>();
        result.add(s);
        for (String delimeter : DELIMETERS) {
            result = ContactUtils.parse(result, delimeter);
        }
        return result;
    }

    private static List<String> parse(List<String> strings, String delimeter) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : strings) {
            StringTokenizer tokenizer = new StringTokenizer(s, delimeter);
            while (tokenizer.hasMoreTokens()) {
                String prefix;
                String token = tokenizer.nextToken();
                if (token.startsWith(prefix = " ")) {
                    token = token.substring(prefix.length());
                }
                if (token.equals("")) continue;
                result.add(token);
            }
        }
        return result;
    }
}

