/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientList;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListModel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class RecipientListPopup
extends GWPopupMenu {
    private static RecipientListPopup popup;
    private RecipientList recipientList;
    private MVCController controller;
    private final AbstractAction actionDetails = new DetailsAction();
    private final AbstractAction actionEdit = new EditAction();
    private final AbstractAction actionCut = new CutCopyAction(StringResources.CUT, 2);
    private final AbstractAction actionCopy = new CutCopyAction(StringResources.COPY, 1);
    private final AbstractAction actionPaste = new PasteAction();
    private final AbstractAction actionDelete = new DeleteAction();
    private final AbstractAction actionSelectAll = new SelectAllAction();
    private final AbstractAction actionDisableQuickInfo = new DisableQuickInfoAction();
    private JMenuItem miDisableQuickInfo;

    private RecipientListPopup() {
        this.buildUI();
    }

    private void buildUI() {
        this.add(MenuItemFactory.createMenuItem(this.actionDetails));
        this.addSeparator();
        this.add(MenuItemFactory.createMenuItem(this.actionEdit));
        this.add(MenuItemFactory.createMenuItem(this.actionCut));
        this.add(MenuItemFactory.createMenuItem(this.actionCopy));
        this.add(MenuItemFactory.createMenuItem(this.actionPaste));
        this.add(MenuItemFactory.createMenuItem(this.actionDelete));
        this.add(MenuItemFactory.createMenuItem(this.actionSelectAll));
        this.addSeparator();
        this.miDisableQuickInfo = MenuItemFactory.createCkeckBoxMenuItem(this.actionDisableQuickInfo);
        this.add(this.miDisableQuickInfo);
    }

    public static RecipientListPopup getInstance() {
        if (popup == null) {
            popup = new RecipientListPopup();
        }
        return popup;
    }

    private void refreshActions() {
        int selectedIndex = this.recipientList.getSelectedIndex();
        boolean hasSelection = selectedIndex >= 0;
        boolean isSingleSelection = hasSelection && selectedIndex == this.recipientList.getMaxSelectionIndex();
        this.actionDetails.setEnabled(isSingleSelection);
        this.actionEdit.setEnabled(isSingleSelection);
        this.actionCut.setEnabled(hasSelection);
        this.actionCopy.setEnabled(hasSelection);
        this.actionDelete.setEnabled(hasSelection);
        this.miDisableQuickInfo.setSelected(OptionManager.getInstance().getGeneralOptions().isDisableQuickInfo());
    }

    public void show(RecipientList invoker, int x, int y, MVCController controller) {
        this.recipientList = invoker;
        this.controller = controller;
        this.refreshActions();
        super.show(invoker, x, y);
    }

    private class DisableQuickInfoAction
    extends AbstractAction {
        private DisableQuickInfoAction() {
            this.putValue("Name", StringResources.DISABLE_QUICK_INFO);
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem menuItem;
            boolean isSelected = (menuItem = (JMenuItem)e.getSource()).isSelected();
            menuItem.setSelected(!isSelected);
            OptionManager.getInstance().getGeneralOptions().setDisableQuickInfo(!isSelected);
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
            this.putValue("Name", StringResources.SELECT_ALL);
        }

        public void actionPerformed(ActionEvent e) {
            RecipientListModel model = RecipientListPopup.this.recipientList.getModel();
            RecipientListPopup.this.recipientList.setSelectionInterval(0, model.getSize());
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
            this.putValue("Name", StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            RecipientListPopup.this.recipientList.removeRecipients(RecipientListPopup.this.recipientList.getSelectedRecipients());
        }
    }

    private class PasteAction
    extends AbstractAction {
        private PasteAction() {
            this.putValue("Name", StringResources.PASTE);
        }

        public void actionPerformed(ActionEvent e) {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (transferable != null) {
                RecipientListPopup.this.recipientList.getTransferHandler().importData(RecipientListPopup.this.recipientList, transferable);
            }
        }
    }

    private class CutCopyAction
    extends AbstractAction {
        private final int action;

        private CutCopyAction(String name, int action) {
            this.putValue("Name", name);
            this.action = action;
        }

        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            RecipientListPopup.this.recipientList.getTransferHandler().exportToClipboard(RecipientListPopup.this.recipientList, clipboard, this.action);
        }
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
            this.putValue("Name", StringResources.EDIT);
        }

        public void actionPerformed(ActionEvent e) {
            RecipientListPopup.this.recipientList.edit(RecipientListPopup.this.recipientList.getSelectedValue());
        }
    }

    private class DetailsAction
    extends AbstractAction {
        private DetailsAction() {
            this.putValue("Name", StringResources.DETAILS);
        }

        public void actionPerformed(ActionEvent e) {
            IRecipient recipient = RecipientListPopup.this.recipientList.getSelectedValue();
            Window owner = SwingUtilities.getWindowAncestor((Component)RecipientListPopup.this.controller.getMVCView());
            IAddressable result = recipient.getAddressable();
            ContactDetailsDialog dialog = ContactDetailsDialog.createContactDetailsDialog(owner, result, null);
            dialog.showMe();
            if (dialog.isActionCompleteSuccessfully()) {
                IContact contact = dialog.getContact();
                IRecipient newRecipient = APIAbWrapperManager.createRecipient(contact, RecipientListPopup.this.recipientList.getCopyType());
                RecipientListModel listModel = RecipientListPopup.this.recipientList.getModel();
                listModel.removeRecipient(recipient);
                listModel.addRecipient(newRecipient);
            }
        }
    }
}

