/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.contactsearch;

import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.contactsearch.AbstractAddressTransferHandler;
import com.novell.gw.jclient.application.controls.contactsearch.AddressSerializable;
import com.novell.gw.jclient.application.controls.contactsearch.AddressesTransferrable;
import com.novell.gw.jclient.application.controls.contactsearch.ContactSearchComboField;
import com.novell.gw.jclient.application.controls.contactsearch.ContactUtils;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientList;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class RecipientListTransferHandler
extends AbstractAddressTransferHandler {
    private static final Logger logger = Logger.getLogger(RecipientListTransferHandler.class);
    private List<IRecipient> recipients;

    public RecipientListTransferHandler(RecipientList recipientList, ContactSearchComboField comboField) {
        super(comboField, recipientList);
    }

    protected Transferable createTransferable(JComponent c) {
        this.recipients = this.getRecipientList().getSelectedRecipients();
        ArrayList<AddressSerializable> addressSerializableList = new ArrayList<AddressSerializable>();
        for (IRecipient recipient : this.recipients) {
            addressSerializableList.add(new AddressSerializable(recipient.getAddressable()));
        }
        String text = ContactUtils.toString(this.recipients);
        return new AddressesTransferrable(text, addressSerializableList.toArray(new AddressSerializable[addressSerializableList.size()]));
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        super.exportDone(source, data, action);
        if (action == 2) {
            this.getRecipientList().removeRecipients(this.recipients);
        }
        this.getComboField().setShowRecipientList(true);
        if (!this.getRecipientList().getModel().getRecipients().isEmpty()) {
            this.getComboField().showPopup();
        }
    }

    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        super.exportAsDrag(comp, e, action);
        this.getRecipientList().requestFocus();
        this.getComboField().hidePopup();
        this.getComboField().setShowRecipientList(false);
    }

    public boolean importData(JComponent comp, Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(AddressesTransferrable.addressFlavor)) {
                List<IRecipient> recipients = this.getRecipients(transferable);
                this.getRecipientList().getModel().addRecipients(recipients);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }
}

