/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.filter.FilterDialogController;
import com.novell.gw.jclient.application.controls.filter.FilterPanel;
import com.novell.gw.jclient.application.controls.filter.OpenFilterDialog;
import com.novell.gw.jclient.application.controls.filter.SaveFilterDialog;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendarActionList;
import com.novell.gw.jclient.application.frames.search.FrameItemSearchActionList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDialog
extends ApplicationDialog<FilterDialogController> {
    private JButton btnOpen = new JMnemonicButton(new OpenAction());
    private JButton btnSave = new JMnemonicButton(new SaveAction());
    protected FilterPanel pnlLeft;

    protected FilterDialog(JDialog parentDialog, MVCController parentController) {
        super((Dialog)parentDialog, parentController);
    }

    public FilterDialog(JDialog parentDialog, MVCController parentController, Filter theFilter) {
        this(parentDialog, parentController);
        this.buildUI(theFilter, false);
        this.setTitle(this.guessTitleFromMVCController(parentController));
    }

    protected FilterDialog(ApplicationFrame frame) {
        super((Frame)frame, frame.getController());
    }

    public FilterDialog(ApplicationFrame frame, Filter theFilter) {
        this(frame);
        this.buildUI(theFilter, false);
        this.setTitle(this.guessTitleFromMVCController(frame.getController()));
    }

    protected String guessTitleFromMVCController(MVCController parentController) {
        String suggestedTitle = StringResources.FIND;
        if (parentController instanceof GWMainAppFrameActionList) {
            GWMainAppFrame frame = (GWMainAppFrame)((GWMainAppFrameActionList)parentController).getMVCView();
            if (frame.isMultiPanelView()) {
                PanelView selectedPanel = frame.getMultiPanelView().getSelectedPanel();
                if (selectedPanel != null) {
                    String name = selectedPanel.getPanelName();
                    suggestedTitle = StringResources.formatString(StringResources.FIND_IN_PANEL, name);
                } else {
                    String name = ((GWMainAppFrame)((GWMainAppFrameActionList)parentController).getMVCView()).getFolder().getName();
                    suggestedTitle = StringResources.formatString(StringResources.FIND_IN_FOLDER, name);
                }
            } else {
                String name = ((GWMainAppFrame)((GWMainAppFrameActionList)parentController).getMVCView()).getFolder().getName();
                suggestedTitle = StringResources.formatString(StringResources.FIND_IN_FOLDER, name);
            }
        } else if (parentController instanceof FrameItemSearchActionList) {
            suggestedTitle = StringResources.formatString(StringResources.IN_SOME_FOLDER_D, StringResources.FIND_RESULTS);
        } else if (parentController instanceof FrameCalendarActionList) {
            suggestedTitle = StringResources.formatString(StringResources.IN_SOME_FOLDER_D, StringResources.CALENDAR);
        }
        return suggestedTitle;
    }

    protected void buildUI(Filter filter, boolean isContact) {
        this.pnlLeft = new FilterPanel(this, (MVCController)this.getController(), filter, isContact);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)this.pnlLeft, "Center");
        contentPane.add((Component)this.buildButtonsPane(), "After");
        contentPane.add((Component)this.buildOKCancel(), "Last");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private OrientablePanel buildOKCancel() {
        OrientablePanel pnl = new OrientablePanel(new BorderLayout());
        pnl.add((Component)this.createOkCancelButtonsPanel(), "After");
        return pnl;
    }

    private JPanel buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        JMnemonicButton btnReset = new JMnemonicButton(new FilterPanel.ActionReset(this.pnlLeft));
        JMnemonicButton btnAdvanced = new JMnemonicButton(new FilterPanel.ActionAdvanced(this.pnlLeft));
        pnlButtons.add(this.btnOpen);
        pnlButtons.add(this.btnSave);
        pnlButtons.add(new OrientablePanel());
        pnlButtons.add(btnAdvanced);
        pnlButtons.add(btnReset);
        OrientablePanel pnlTemp = new OrientablePanel(new FlowLayout(4, 0, 20));
        pnlTemp.add(Box.createVerticalStrut(0));
        pnlTemp.add(pnlButtons);
        return pnlTemp;
    }

    public Filter getFilter() {
        return this.pnlLeft.getFilter();
    }

    @Override
    protected FilterDialogController createController(MVCController parentController) {
        return new FilterDialogController(this, parentController);
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(StringResources.SAVE);
        }

        public void actionPerformed(ActionEvent e) {
            Filter filter = FilterDialog.this.getFilter();
            if (filter != null) {
                SaveFilterDialog dlgsave = new SaveFilterDialog(FilterDialog.this, filter);
                dlgsave.showMe();
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super(StringResources.OPEN);
        }

        public void actionPerformed(ActionEvent e) {
            Filter filter;
            OpenFilterDialog dlg = new OpenFilterDialog(FilterDialog.this);
            dlg.showMe();
            if (dlg.isActionCompleteSuccessfully() && (filter = dlg.getFilter()) != null) {
                FilterDialog.this.pnlLeft.setFilter(filter);
            }
        }
    }
}

