/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.filter.FilterDialog;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.search.FrameItemSearch;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class FilterFeedbackDialog
extends BasicDialog {
    private JButton btnYes = new JMnemonicButton(new YesAction());
    private JButton btnNo = new JMnemonicButton(new NoAction());
    private JButton btnClear = new JMnemonicButton(new ClearAction());
    private ApplicationFrame frame;
    private MVCController controller;

    public FilterFeedbackDialog(ApplicationFrame theFrame, MVCController theController) throws HeadlessException {
        super(theFrame);
        this.setModal(true);
        this.frame = theFrame;
        this.controller = theController;
        if (this.controller == null) {
            this.btnClear = new JMnemonicButton(new CancelFindAction());
        }
        this.setTitle(StringResources.FILTER_FEEDBACK);
        this.getRootPane().setDefaultButton(this.btnYes);
        this.setCancelButton(this.btnNo);
        this.buildUI();
    }

    private void buildUI() {
        OrientablePanel pnlCenter = new OrientablePanel(new BorderLayout(5, 5));
        pnlCenter.add((Component)new OrientableLabel(StringResources.NO_ITEMS_WERE_FOUND), "North");
        pnlCenter.add((Component)new OrientableLabel(StringResources.MODIFY_YOUR_FILTER), "Center");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)new OrientableLabel(ImageResources.ICON_FILTER_FEEDBACK), "Before");
        contentPane.add((Component)pnlCenter, "Center");
        contentPane.add((Component)this.buildButtonsPane(), "South");
        this.pack();
    }

    private JPanel buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel(new FlowLayout(2, 10, 10));
        pnlButtons.add(this.btnYes);
        pnlButtons.add(this.btnNo);
        pnlButtons.add(this.btnClear);
        return pnlButtons;
    }

    private class CancelFindAction
    extends AbstractAction {
        public CancelFindAction() {
            super(StringResources.CANCEL_FIND);
        }

        public void actionPerformed(ActionEvent e) {
            FilterFeedbackDialog.this.dispose();
            FilterFeedbackDialog.this.frame.dispose();
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(StringResources.FILTER_FEEDBACK_CLEAR);
        }

        public void actionPerformed(ActionEvent e) {
            if (FilterFeedbackDialog.this.controller != null) {
                FilterFeedbackDialog.this.controller.processCommand(new Command(400, null));
            }
            FilterFeedbackDialog.this.dispose();
        }
    }

    private class NoAction
    extends AbstractAction {
        public NoAction() {
            super(StringResources.FILTER_FEEDBACK_NO);
        }

        public void actionPerformed(ActionEvent e) {
            FilterFeedbackDialog.this.dispose();
        }
    }

    private class YesAction
    extends AbstractAction {
        public YesAction() {
            super(StringResources.FILTER_FEEDBACK_YES);
        }

        public void actionPerformed(ActionEvent e) {
            FilterFeedbackDialog.this.dispose();
            if (FilterFeedbackDialog.this.controller != null) {
                FilterFeedbackDialog.this.controller.getActionList().getAction(ActionKey.CREATE_GWITEM_FILTER).actionPerformed(e);
            } else {
                FrameItemSearch frameItemSearch = (FrameItemSearch)FilterFeedbackDialog.this.frame;
                FilterDialog filterDialog = new FilterDialog(frameItemSearch, frameItemSearch.getFilterForModify());
                filterDialog.setVisible(true);
                if (filterDialog.isOkActionProcessed()) {
                    frameItemSearch.startSearch(filterDialog.getFilter());
                }
            }
        }
    }
}

