/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.ApplicationFrameActionList;
import com.appframework.OrientableStringBuilder;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.filter.HeaderFindLabel;
import com.novell.gw.jclient.application.controls.filter.QuickFilter;
import com.novell.gw.jclient.application.controls.filter.QuickFilterKeyPressListener;
import com.novell.gw.jclient.application.controls.filter.QuickFilterPanelController;
import com.novell.gw.jclient.application.controls.filter.QuickFilterPanelModel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFilterPanel
extends SkinnablePanel
implements MVCView<QuickFilterPanelController, QuickFilterPanelModel> {
    private static final Logger logger = Logger.getLogger(QuickFilterPanel.class);
    private QuickFilterPanelController controller;
    private JTextField tfFind;
    private HeaderFindLabel lbFilter;
    private OrientableLabel lbClearFilter;
    private QuickFilterPanelModel model;
    private static final Icon emptyIcon = new Icon(){

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return ImageResources.ICON_ACTIVE_FILTER.getIconWidth();
        }

        public int getIconHeight() {
            return ImageResources.ICON_ACTIVE_FILTER.getIconHeight();
        }
    };

    public QuickFilterPanel(ApplicationFrameActionList actionList) {
        super(new BorderLayout());
        ControlsUtils.prepareHeaderPanel(this);
        this.controller = new QuickFilterPanelController(this, (MVCController)actionList);
        this.model = new QuickFilterPanelModel(this.controller);
        this.tfFind = new GWTextField(15);
        this.tfFind.addKeyListener(new QuickFilterKeyPressListener(this));
        this.tfFind.setBackground(Color.WHITE);
        this.tfFind.setForeground(Color.BLACK);
        if (!LookAndFeelManager.isGtkLookAndFeel()) {
            this.tfFind.setBorder(BorderFactory.createEmptyBorder());
        }
        this.lbClearFilter = new OrientableLabel(emptyIcon);
        this.lbClearFilter.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                QuickFilterPanel.this.getMVCModel().clearFilter();
                QuickFilterPanel.this.adjustViewToModel();
            }
        });
        this.lbFilter = new HeaderFindLabel(actionList);
        OrientablePanel pnlWhite = new OrientablePanel();
        pnlWhite.setLayout(new GridBagLayout());
        if (!LookAndFeelManager.isGtkLookAndFeel()) {
            pnlWhite.setBackground(Color.WHITE);
            pnlWhite.setBorder(BorderFactory.createEtchedBorder());
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 1;
        pnlWhite.add((Component)this.tfFind, constraints);
        ++constraints.gridx;
        constraints.weightx = 0.0;
        constraints.fill = 0;
        pnlWhite.add((Component)this.lbClearFilter, constraints);
        this.add((Component)this.lbFilter, "Before");
        this.add((Component)pnlWhite, "Center");
    }

    public void setFolder(AbstractFolder folder) {
        this.model.setFolder(folder);
        this.lbFilter.setFolder(folder);
        this.adjustViewToModel();
    }

    void setFilter(Filter filter) {
        this.model.setFilter(filter);
        this.adjustViewToModel();
    }

    public Filter getFilter() {
        return this.model.getFilter();
    }

    void panelSelected(PanelView panel) {
        this.model.panelSelected(panel);
        this.adjustViewToModel();
    }

    void quickFilterTextChanged() {
        this.model.quickFilterTextChanged(this.tfFind.getText());
        this.adjustViewToModel();
    }

    private void adjustViewToModel() {
        Filter filter = this.model.getFilter();
        if (filter == null || filter.isEmpty()) {
            this.lbClearFilter.setIcon(emptyIcon);
            this.lbClearFilter.setToolTipText(null);
            this.lbClearFilter.setCursor(new Cursor(0));
        } else {
            OrientableStringBuilder builder = new OrientableStringBuilder(this.getComponentOrientation());
            builder.append(StringResources.FIND_C);
            builder.append(' ');
            builder.append(filter.getItemListFilter().generateDescription());
            this.lbClearFilter.setIcon(ImageResources.ICON_ACTIVE_FILTER);
            this.lbClearFilter.setToolTipText(builder.toString());
            this.lbClearFilter.setCursor(new Cursor(12));
        }
        if (filter instanceof QuickFilter) {
            String quickFilterText = ((QuickFilter)filter).getText();
            if (!this.tfFind.getText().equals(quickFilterText)) {
                this.tfFind.setText(quickFilterText);
            }
        } else {
            this.tfFind.setText("");
        }
    }

    @Override
    public QuickFilterPanelController getController() {
        logger.warn((Object)"setting new controller");
        return this.controller;
    }

    @Override
    public void setController(QuickFilterPanelController theController) {
        this.controller = theController;
    }

    @Override
    public QuickFilterPanelModel getMVCModel() {
        return this.model;
    }

    @Override
    public void setMVCModel(QuickFilterPanelModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = model;
    }
}

