/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.filter;

import com.appframework.components.ActionEnablerTextField;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.filter.AbstractViewFiltersDialog;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SaveFilterDialog
extends AbstractViewFiltersDialog {
    private static Logger logger = Logger.getLogger(SaveFilterDialog.class);
    private JTextField tfName;
    private Filter filter;
    private JTextArea taDescription;

    public SaveFilterDialog(CustomFilter theFilter) {
        this.init(theFilter);
    }

    public SaveFilterDialog(GWDialog dialog, Filter theFilter) {
        super(dialog);
        this.init(theFilter);
    }

    public SaveFilterDialog(ApplicationDialog dialog, Filter theFilter) {
        super(dialog);
        this.init(theFilter);
    }

    private void init(Filter theFilter) {
        this.tfName = new ActionEnablerTextField(this.btnOK.getAction());
        this.filter = theFilter;
        this.setTitle(StringResources.SAVE_FILTER);
        this.taDescription = new JTextArea(2, 1);
        this.taDescription.setEditable(false);
        this.taDescription.setBackground(this.getBackground());
        this.taDescription.setLineWrap(true);
        String text = new com.novell.gw.engine.Filter(this.dataStore.getNativeDataStore(), this.filter.getItemListFilter(), false).generateDescription();
        this.taDescription.setText(text);
        this.buildUI();
        this.cbPutOnMenu.setSelected(true);
        this.listFilters.addListSelectionListener(new FilterListSelectionListener());
    }

    JTextField getTfName() {
        return this.tfName;
    }

    private void buildUI() {
        OrientablePanel pnlLeft = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlLeft);
        adapter.setColumnCount(2);
        adapter.setResizableColumn(1);
        adapter.setInsets(new Insets(0, 5, 0, 5));
        adapter.addComponent(new OrientableLabel(StringResources.SAVE_AS_C));
        adapter.setInsets(new Insets(0, 5, 0, 5));
        adapter.addComponent(new OrientableLabel(StringResources.DESCRIPTION_C));
        adapter.setIpadx(140);
        adapter.addComponent(this.tfName);
        adapter.setGridHeight(2);
        adapter.addComponent(new OrientableScrollPane(this.taDescription));
        adapter.addComponent(this.cbPutOnMenu);
        adapter.endRow();
        OrientableLabel lbBorder = new OrientableLabel();
        lbBorder.setBorder(BorderFactory.createEtchedBorder());
        adapter.setGridWidth(2);
        adapter.addComponent(lbBorder);
        adapter.setInsets(new Insets(0, 5, 0, 5));
        adapter.addComponent(new OrientableLabel(StringResources.NAME_C));
        adapter.setInsets(new Insets(0, 5, 0, 5));
        adapter.addComponent(new OrientableLabel(StringResources.DESCRIPTION_C));
        adapter.setWidthY(100);
        adapter.addComponent(new OrientableScrollPane(this.listFilters));
        adapter.addComponent(new OrientableScrollPane(this.talistDescription));
        this.panCenterPanel.add((Component)pnlLeft, "Center");
        this.panCenterPanel.add((Component)this.buildButtonsPane(), "After");
        this.panCenterPanel.setPreferredSize(new Dimension(500, 260));
    }

    protected void performOkAction() {
        this.filter.getItemListFilter().save(this.tfName.getText(), this.cbPutOnMenu.isSelected(), this.dataStore.getNativeDataStore());
    }

    private JPanel buildButtonsPane() {
        OrientablePanel pnlButtons = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlButtons);
        adapter.setColumnCount(1);
        adapter.addComponent(this.btnOK);
        adapter.addComponent(this.btnCancel);
        OrientablePanel pnlContent = new OrientablePanel(new BorderLayout());
        pnlContent.add((Component)pnlButtons, "North");
        return pnlContent;
    }

    private class FilterListSelectionListener
    implements ListSelectionListener {
        private FilterListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SaveFilterDialog.this.valueChanged(false);
        }
    }
}

