/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UnopenedFolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class CheckFoldersTree
extends PlainFoldersTree {
    private AbstractFolder selectedFolder;
    private AbstractButton btnToEnable;

    public CheckFoldersTree(MVCController parentController, String userGuid) {
        this(parentController, null, userGuid);
    }

    public CheckFoldersTree(MVCController parentController, AbstractButton theButton, String userGuid) {
        super(parentController, userGuid);
        this.setCellRenderer(new TreeRenderrer());
        this.addMouseListener(new CheckedTreeMouseListener());
        this.btnToEnable = theButton != null ? theButton : new JButton();
        this.btnToEnable.setEnabled(false);
    }

    private static boolean canSelectFolder(AbstractFolder folder) {
        return !(folder instanceof UnopenedFolder) && !(folder instanceof SentItemsFolder) && !(folder instanceof TrashFolder) && !(folder instanceof ContactsFolder) && !(folder instanceof QueryFolder);
    }

    public AbstractFolder getSelectedFolder() {
        return this.selectedFolder;
    }

    public void selectFolder(AbstractFolder theFolder) {
        this.selectedFolder = theFolder;
        this.repaint();
        super.selectFolder(this.selectedFolder);
        this.btnToEnable.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(UIManager.getColor("Tree.background"));
        } else {
            this.setBackground(UIManager.getColor("Tree.disabledBackground"));
        }
    }

    private class TreeLabel
    extends OrientableLabel {
        boolean isSelected;
        boolean hasFocus;

        private TreeLabel() {
        }

        public void paint(Graphics g) {
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (CheckFoldersTree.this.isEnabled()) {
                    if (this.isSelected) {
                        g.setColor(UIManager.getColor("Tree.selectionBackground"));
                    } else {
                        g.setColor(UIManager.getColor("Tree.textBackground"));
                    }
                } else {
                    g.setColor(CheckFoldersTree.this.getBackground());
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
            }
            super.paint(g);
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }
    }

    private class CheckedTreeMouseListener
    extends MouseAdapter {
        private CheckedTreeMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            int y;
            if (!CheckFoldersTree.this.isEnabled()) {
                return;
            }
            int x = e.getX();
            int row = CheckFoldersTree.this.getRowForLocation(x, y = e.getY());
            TreePath path = CheckFoldersTree.this.getPathForRow(row);
            if (path != null) {
                boolean pressedOnCheck;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                AbstractFolder folder = (AbstractFolder)node.getUserObject();
                TreeRenderrer treeRenderrer = (TreeRenderrer)CheckFoldersTree.this.getCellRenderer();
                Rectangle pathBounds = CheckFoldersTree.this.getPathBounds(path);
                if (UIUtils.getComponentOrientation().isLeftToRight()) {
                    pressedOnCheck = x > pathBounds.x && x < pathBounds.x + treeRenderrer.CHECK_WIDTH;
                } else {
                    boolean bl = pressedOnCheck = x > pathBounds.x + pathBounds.width - treeRenderrer.CHECK_WIDTH && x < pathBounds.x + pathBounds.width;
                }
                if (CheckFoldersTree.canSelectFolder(folder) && pressedOnCheck) {
                    if (folder.equals(CheckFoldersTree.this.selectedFolder)) {
                        CheckFoldersTree.this.selectedFolder = null;
                        CheckFoldersTree.this.btnToEnable.setEnabled(false);
                    } else {
                        CheckFoldersTree.this.selectedFolder = folder;
                        CheckFoldersTree.this.btnToEnable.setEnabled(true);
                    }
                }
                ((DefaultTreeModel)CheckFoldersTree.this.getModel()).nodeChanged(node);
            }
        }
    }

    private class TreeRenderrer
    extends OrientablePanel
    implements TreeCellRenderer,
    TextTreeRenderer {
        private JCheckBox check = new OrientableCheckBox();
        private final TreeLabel label = new TreeLabel();
        public final int CHECK_WIDTH;
        private int rowHeight;

        public TreeRenderrer() {
            this.CHECK_WIDTH = this.check.getPreferredSize().width;
            this.rowHeight = PLAFChanger.getTreeRowHeight();
            this.setLayout(new FlowLayout(3, 0, 0));
            this.add(this.check);
            this.add(this.label);
            this.label.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            AbstractFolder folder = (AbstractFolder)((DefaultMutableTreeNode)value).getUserObject();
            this.check = new OrientableCheckBox();
            this.check.setOpaque(!LookAndFeelManager.isGtkLookAndFeel());
            this.check.setPreferredSize(new Dimension(this.CHECK_WIDTH, this.rowHeight));
            this.remove(0);
            this.add((Component)this.check, 0);
            this.check.setEnabled(CheckFoldersTree.canSelectFolder(folder));
            this.label.setSelected(selected);
            if (CheckFoldersTree.this.selectedFolder != null && CheckFoldersTree.this.selectedFolder.equals(folder)) {
                this.check.setSelected(true);
            } else {
                this.check.setSelected(false);
            }
            if (selected && tree.isEnabled()) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(tree.getBackground());
                this.label.setForeground(UIManager.getColor("Tree.foreground"));
            }
            this.check.setBackground(tree.getBackground());
            this.label.setText(value.toString() + ' ');
            this.label.setFont(tree.getFont());
            int width = this.label.getPreferredSize().width + this.CHECK_WIDTH + 3;
            if (tree.getRowHeight() != 0) {
                this.rowHeight = tree.getRowHeight();
            }
            if (folder != null) {
                this.label.setIcon(ControlsUtils.getImageForFolder(folder));
            }
            return this;
        }

        public Component getComponent() {
            return this;
        }

        public int getTextX() {
            return this.CHECK_WIDTH + this.label.getIcon().getIconWidth() + this.label.getIconTextGap();
        }
    }
}

