/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeCellEditor;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class EditableFoldersTree
extends PlainFoldersTree {
    private static Logger logger = Logger.getLogger(EditableFoldersTree.class);

    public EditableFoldersTree(MVCController parentController, String userGuid) {
        super(parentController, userGuid);
        GWFoldersTreeCellEditor ed = new GWFoldersTreeCellEditor(this, this.renderer);
        this.setCellEditor(ed);
        this.addTreeSelectionListener(new PlainFoldersTree.TreeSetEditableListener(this));
    }

    private void moveCalendarTo(AbstractFolder folder, int position) {
        if (folder.getNativeFolder().isCalendarChildFolder()) {
            AbstractFolder parent = folder.getParent();
            for (IFolder subfolder : parent.getNativeFolder().getSubFolders()) {
                if (position != subfolder.getCalendarListSequenceNumber() - 1) continue;
                folder.getNativeFolder().setCalendarListSequenceNumber(subfolder);
                GWClient.getApplication().processCommand(new GlobalCommand(200));
                break;
            }
        }
    }

    public void moveUpFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        int index = parent.getIndex(folderNode);
        --index;
        if (folder.getNativeFolder().isCalendarChildFolder()) {
            this.moveCalendarTo(folder, index);
        } else {
            folder.getNativeFolder().moveTo(((AbstractFolder)parent.getUserObject()).getNativeFolder(), index);
            super.moveUpFolder(folder);
        }
    }

    public void moveDownFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        IFolder parentFolder = ((AbstractFolder)parent.getUserObject()).getNativeFolder();
        int numberOfChildren = parent.getChildCount();
        int index = parent.getIndex(folderNode);
        assert (index < numberOfChildren - 1) : "numberOfChildren: " + numberOfChildren + ", index: " + index;
        if (++index >= numberOfChildren) {
            index = -1;
        }
        if (folder.getNativeFolder().isCalendarChildFolder()) {
            this.moveCalendarTo(folder, index);
        } else {
            folder.getNativeFolder().moveTo(parentFolder, ++index);
            super.moveDownFolder(folder);
        }
    }

    public void moveLeftFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        DefaultMutableTreeNode where = (DefaultMutableTreeNode)parent.getParent();
        int index = where.getIndex(parent);
        if (++index >= where.getChildCount()) {
            index = -1;
        }
        folder.getNativeFolder().moveTo(((AbstractFolder)where.getUserObject()).getNativeFolder(), index);
        super.moveLeftFolder(folder);
    }

    public void moveRightFolder(AbstractFolder folder) {
        DefaultMutableTreeNode folderNode = this.getFolderNode(folder);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)folderNode.getParent();
        DefaultMutableTreeNode where = (DefaultMutableTreeNode)parent.getChildBefore(folderNode);
        folder.getNativeFolder().moveTo(((AbstractFolder)where.getUserObject()).getNativeFolder(), 0);
        super.moveRightFolder(folder);
    }
}

