/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.resources.GWIcons;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.impl.folder.FakeNewFolderImpl;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.LookAndFeelManager;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeModelUtils;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.navigation.MultipleCheckFoldersTree;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class GWFoldersTreeCellEditor
extends DefaultTreeCellEditor {
    private static Logger logger = Logger.getLogger(GWFoldersTreeCellEditor.class);
    private boolean isCachingMode = false;
    private AbstractFolder folder = null;
    private GWTextField tf;
    private JTree tree;
    private String oldName;
    private static int heightPanel;
    private static final Color DEFAULT_BACKGROUND;
    private static final String PROPERTY_CHANGES_PROCESSED = "GWFoldersTreeCellEditor.changes processed";
    private static final String PROPERTY_KEY_EVENT_IS_PROCESSING = "GWFoldersTreeCellEditor.key event is processing";

    public GWFoldersTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        OrientableLabel lbBefore = new OrientableLabel();
        OrientablePanel pnl = new OrientablePanel(new GridBagLayout()){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                int widthStrMin = this.getFontMetrics(this.getFont()).stringWidth("123456789012345");
                d.width = d.width < widthStrMin ? widthStrMin : (d.width += 5);
                return d;
            }
        };
        OrientableLabel lbUnOpenedItems = new OrientableLabel();
        OrientableLabel lbFolderIcon = new OrientableLabel();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.weighty = 1.0;
        c.fill = 3;
        Object userobject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userobject instanceof AbstractFolder) {
            OrientableCheckBox cb;
            this.folder = (AbstractFolder)userobject;
            String name = this.folder.getName();
            this.oldName = this.folder.getName();
            Icon emptyIcon = null;
            if (!(tree instanceof MultipleCheckFoldersTree)) {
                if (OS.isMacOS() || OS.isNimbusLAF() || LookAndFeelManager.isGtkLookAndFeel()) {
                    emptyIcon = GWIcons.EMPTY_ICON;
                }
                if (this.folder instanceof SentItemsFolder) {
                    if (this.isCachingMode && this.folder.hasUnreadItems(!expanded)) {
                        lbUnOpenedItems.setIcon(ImageResources.ICON_UNSENT_ITEMS);
                    } else {
                        lbUnOpenedItems.setIcon(emptyIcon);
                    }
                } else if (this.folder instanceof CalendarFolder) {
                    if (this.folder.hasUnreadItems(!expanded)) {
                        lbUnOpenedItems.setIcon(ImageResources.ICON_CLOCK_CAL_ITEMS);
                    } else {
                        lbUnOpenedItems.setIcon(emptyIcon);
                    }
                } else if (this.folder.hasUnreadItems(!expanded) && !(this.folder instanceof TrashFolder) && !(this.folder instanceof SubCalendarFolder) && !(this.folder instanceof UserFolder)) {
                    lbUnOpenedItems.setIcon(ImageResources.ICON_UNOPENED_ITEMS);
                } else {
                    lbUnOpenedItems.setIcon(emptyIcon);
                }
            }
            lbFolderIcon.setIcon(ControlsUtils.getImageForFolder((AbstractFolder)userobject, false));
            if (LookAndFeelManager.isGtkLookAndFeel()) {
                lbBefore = new OrientableLabel();
                lbBefore.setOpaque(true);
                pnl.add((Component)lbBefore, c);
                lbBefore.setBackground(UIManager.getColor("Tree.selectionBackground"));
                if (this.folder instanceof SubCalendarFolder) {
                    lbUnOpenedItems.setIcon(null);
                }
            }
            pnl.add((Component)lbUnOpenedItems, c);
            if (tree instanceof MainGWFoldersTree && userobject instanceof SubCalendarFolder) {
                cb = new OrientableCheckBox();
                SubCalendarFolder sub = (SubCalendarFolder)userobject;
                cb.setSelected(sub.isSubCalendarShown());
                pnl.add((Component)cb, c);
            }
            if (tree instanceof MultipleCheckFoldersTree) {
                cb = new OrientableCheckBox();
                cb.setSelected(((MultipleCheckFoldersTree)tree).getSelectedFolderList().contains(this.folder));
                pnl.add((Component)cb, c);
            }
            pnl.add((Component)lbFolderIcon, c);
            c.fill = 1;
            c.weightx = 1.0;
            this.tf = new GWTextField(name);
            if (OS.isNimbusLAF()) {
                this.tf.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            }
            this.tf.putClientProperty(PROPERTY_CHANGES_PROCESSED, false);
            this.tf.putClientProperty(PROPERTY_KEY_EVENT_IS_PROCESSING, false);
            this.tf.addFocusListener(new FocusLostListener(this.tf));
            this.tf.addKeyListener(new TfKeyListener(this.tf));
            c.insets = new Insets(0, 3, 0, 0);
            pnl.add((Component)this.tf, c);
        }
        this.tree = tree;
        this.tf.selectAll();
        this.tf.setFocusTraversalKeysEnabled(false);
        this.tf.requestFocus(true);
        heightPanel = pnl.getPreferredSize().height;
        if (LookAndFeelManager.isGtkLookAndFeel()) {
            this.tf.setBorder(BorderFactory.createEmptyBorder());
            pnl.setBorder(BorderFactory.createEmptyBorder());
            pnl.setBackground(DEFAULT_BACKGROUND);
            lbUnOpenedItems.setBackground(UIManager.getColor("Tree.selectionBackground"));
            if (lbUnOpenedItems.getIcon() != null && lbUnOpenedItems.getIcon().equals(GWIcons.EMPTY_ICON)) {
                lbUnOpenedItems.setIcon(new EmptyIcon());
            }
            if (lbUnOpenedItems.getIcon() != null) {
                int widthUnOpen = lbUnOpenedItems.getIcon().getIconWidth();
                if (widthUnOpen > 15) {
                    lbBefore.setPreferredSize(new Dimension(0, 0));
                } else {
                    lbBefore.setPreferredSize(new Dimension(16 - widthUnOpen, 0));
                }
            } else {
                lbBefore.setPreferredSize(new Dimension(0, 0));
            }
        }
        if (OS.isNimbusLAF() || LookAndFeelManager.isGtkLookAndFeel()) {
            pnl.setFocusCycleRoot(true);
            pnl.setFocusTraversalPolicy(new CellEditorFocusPolicy());
        }
        pnl.setBackground(DEFAULT_BACKGROUND);
        return pnl;
    }

    public Object getCellEditorValue() {
        return this.folder;
    }

    private String getUserGuid() {
        String userGuid = ControlsUtils.getUserGuid(this.tree);
        assert (userGuid != null) : "null user guid for tree: " + this.tree;
        return userGuid;
    }

    private void saveNewFolder(String name) {
        logger.debug((Object)("saving folder: " + name));
        IFolder fakeNewFolder = this.folder.getNativeFolder();
        fakeNewFolder.setName(name);
        IFolder parentFolder = this.folder.getNativeFolder().getParent();
        if (fakeNewFolder.getType() == FolderType.USER_CONTACTS) {
            GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().createContactsFolder(name, parentFolder);
        } else if (fakeNewFolder.getType() == FolderType.NORMAL) {
            GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().createFolder(name, "", parentFolder, 0);
        } else if (fakeNewFolder.getType() == FolderType.CALENDAR) {
            GWCommandManager.getInstance(this.getUserGuid()).createCalendarFolder(name, parentFolder);
        } else {
            throw new RuntimeException("unexpected folder type: " + (Object)((Object)fakeNewFolder.getType()));
        }
        ((MainGWFoldersTree)this.tree).removeNewFolder(this.folder);
    }

    public boolean stopCellEditing() {
        if (this.folder.getNativeFolder() instanceof FakeNewFolderImpl) {
            this.oldName = this.tf.getText();
            this.saveNewFolder(this.tf.getText());
        } else if (!this.oldName.equals(this.tf.getText())) {
            this.oldName = this.tf.getText();
            if (!this.tf.getText().equals("")) {
                if (!this.folder.rename(this.tf.getText())) {
                    return false;
                }
                this.tree.requestFocus();
            }
        }
        boolean res = super.stopCellEditing();
        this.trySelectParentNode();
        return res;
    }

    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.trySelectParentNode();
    }

    private void trySelectParentNode() {
        if (this.tree instanceof MainGWFoldersTree && ((MainGWFoldersTree)this.tree).isEditNewFolder()) {
            AbstractFolder folder = ((GWMainAppFrame)((MainGWFoldersTree)this.tree).getController().getActionList().getMVCView()).getFolder();
            if (this.tree instanceof MainGWFoldersTree) {
                DefaultMutableTreeNode node = GWFoldersTreeModelUtils.getFolderTreeNode((DefaultMutableTreeNode)this.tree.getModel().getRoot(), folder);
                ((MainGWFoldersTree)this.tree).selectNode(node, false);
            }
        }
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    private void applyChanges() {
        logger.debug((Object)"applying changes...");
        if (this.tree instanceof MainGWFoldersTree) {
            ((MainGWFoldersTree)this.tree).setRefreshBlocked(false);
        }
        if (!this.stopCellEditing()) {
            this.tree.startEditingAtPath(this.tree.getSelectionPath());
        }
        if (this.tree instanceof MainGWFoldersTree) {
            ((MainGWFoldersTree)this.tree).setEditNewFolder(false);
        }
        logger.debug((Object)"... changes applyed");
    }

    private void cancelChanges() {
        if (this.tree instanceof MainGWFoldersTree) {
            ((MainGWFoldersTree)this.tree).setRefreshBlocked(false);
            if (((MainGWFoldersTree)this.tree).isEditNewFolder()) {
                ((MainGWFoldersTree)this.tree).removeNewFolder(this.folder);
            }
        }
        this.cancelCellEditing();
        ((MainGWFoldersTree)this.tree).setEditNewFolder(false);
    }

    void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    static {
        DEFAULT_BACKGROUND = Color.WHITE;
    }

    private class CellEditorFocusPolicy
    extends LayoutFocusTraversalPolicy {
        private CellEditorFocusPolicy() {
        }

        public Component getDefaultComponent(Container aContainer) {
            return GWFoldersTreeCellEditor.this.tf;
        }
    }

    private class EmptyIcon
    implements Icon {
        private EmptyIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, 16, heightPanel);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return heightPanel;
        }
    }

    private class FocusLostListener
    extends FocusAdapter {
        private GWTextField editor;

        private FocusLostListener(GWTextField editor) {
            this.editor = editor;
        }

        public void focusLost(FocusEvent e) {
            if (((Boolean)this.editor.getClientProperty(GWFoldersTreeCellEditor.PROPERTY_CHANGES_PROCESSED)).booleanValue()) {
                logger.debug((Object)"event processed by TfKeyListener");
                return;
            }
            if (((Boolean)this.editor.getClientProperty(GWFoldersTreeCellEditor.PROPERTY_KEY_EVENT_IS_PROCESSING)).booleanValue()) {
                logger.debug((Object)"event is processing by TfKeyListener");
                return;
            }
            logger.debug((Object)"processing focusLost() event");
            GWFoldersTreeCellEditor.this.applyChanges();
            this.editor.putClientProperty(GWFoldersTreeCellEditor.PROPERTY_CHANGES_PROCESSED, true);
        }
    }

    private class TfKeyListener
    extends KeyAdapter {
        private GWTextField editor;

        private TfKeyListener(GWTextField editor) {
            this.editor = editor;
        }

        public void keyPressed(KeyEvent e) {
            this.editor.putClientProperty(GWFoldersTreeCellEditor.PROPERTY_KEY_EVENT_IS_PROCESSING, true);
            if (e.getKeyCode() == 10) {
                GWFoldersTreeCellEditor.this.applyChanges();
                this.editor.putClientProperty(GWFoldersTreeCellEditor.PROPERTY_CHANGES_PROCESSED, true);
            } else if (e.getKeyCode() == 27) {
                GWFoldersTreeCellEditor.this.cancelChanges();
                this.editor.putClientProperty(GWFoldersTreeCellEditor.PROPERTY_CHANGES_PROCESSED, true);
            }
            this.editor.putClientProperty(GWFoldersTreeCellEditor.PROPERTY_KEY_EVENT_IS_PROCESSING, false);
        }
    }
}

