/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.folder.Folder;
import com.novell.gw.folder.FolderEvent;
import com.novell.gw.folder.FolderListener;
import com.novell.gw.jclient.api.impl.folder.APIFolderWrapperManager;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeModelUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;

class GWFoldersTreeModel
extends DefaultTreeModel {
    private static Logger logger = Logger.getLogger(GWFoldersTreeModel.class);
    private DisplayCountFolderListener displayCountFolderListener;
    private MVCController controller;

    public GWFoldersTreeModel(MVCController controller, String userGuid) {
        super(new DefaultMutableTreeNode("/"));
        this.controller = controller;
        this.displayCountFolderListener = new DisplayCountFolderListener(userGuid);
        this.setRoot(this.buildRootNode(userGuid));
    }

    public void refreshFolders(String userGuid) {
        this.setRoot(this.buildRootNode(userGuid));
    }

    public void clear(String userGuid) {
        try {
            AbstractFolder rootFolder;
            GWCommandManager commandManager = GWCommandManager.getInstance(userGuid);
            if (commandManager != null && (rootFolder = commandManager.getRootFolder()) != null) {
                this.clear(rootFolder);
            }
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
    }

    private void clear(AbstractFolder theFolder) {
        theFolder.removeFolderListener(this.displayCountFolderListener);
        List<AbstractFolder> folders = theFolder.getChildFolders();
        for (AbstractFolder folder : folders) {
            this.clear(folder);
        }
    }

    private DefaultMutableTreeNode buildRootNode(String userGuid) {
        try {
            AbstractFolder rootFolder = GWCommandManager.getInstance(userGuid).getRootFolder();
            rootFolder.setFolderListener(this.displayCountFolderListener);
            return this.addChildrens(new DefaultMutableTreeNode(rootFolder), rootFolder, userGuid);
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
            return null;
        }
    }

    private DefaultMutableTreeNode addChildrens(DefaultMutableTreeNode theNode, AbstractFolder theFolder, String userGuid) {
        List<AbstractFolder> col;
        if (theFolder instanceof CalendarFolder) {
            col = new LinkedList<AbstractFolder>();
            IFolder[] calendarFolders = GWCommandManager.getInstance(userGuid).getCurrentDataStore().getCalendarFolders();
            int nCount = calendarFolders.length;
            GWCommandManager mgr = GWCommandManager.getInstance(userGuid);
            for (int i = 1; i < nCount; ++i) {
                IFolder subFolder = calendarFolders[i];
                AbstractFolder folder = mgr.getGWFolder(subFolder);
                col.add(folder);
            }
        } else {
            col = theFolder.getChildFolders();
        }
        for (int i = 0; i < col.size(); ++i) {
            AbstractFolder folder = col.get(i);
            folder.setFolderListener(this.displayCountFolderListener);
            DefaultMutableTreeNode tempNode = new DefaultMutableTreeNode(folder);
            this.addChildrens(tempNode, folder, userGuid);
            theNode.add(tempNode);
        }
        return theNode;
    }

    private class DisplayCountFolderListener
    implements FolderListener {
        private String userGuid;

        public DisplayCountFolderListener(String userGuid) {
            this.userGuid = userGuid;
        }

        public void updateDisplayCount(FolderEvent e) {
            IFolder folder = APIFolderWrapperManager.getFolder((Folder)e.getSource());
            AbstractFolder gwFolder = GWCommandManager.getInstance(this.userGuid).getGWFolder(folder);
            try {
                if (gwFolder.equals(GWCommandManager.getInstance(this.userGuid).getMailboxFolder())) {
                    GWFoldersTreeModel.this.controller.processCommand(new GlobalCommand(2050));
                }
            }
            catch (GWCommandException ex) {
                logger.debug((Object)ex);
                logger.error((Object)ex);
            }
            DefaultMutableTreeNode folderNode = GWFoldersTreeModelUtils.getFolderTreeNode((DefaultMutableTreeNode)GWFoldersTreeModel.this.getRoot(), gwFolder);
            GWFoldersTreeModel.this.nodeStructureChanged(folderNode);
        }
    }
}

