/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree;

import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.GWFoldersTreeOrientablePanelRenderer;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UniversalFolder;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static final int NODE_SHIFT = 16;

    public static int getShift(JTree tree, TreePath theTreePath) {
        if (!(tree instanceof GWFoldersTree)) {
            return 0;
        }
        int result = 0;
        if (theTreePath != null) {
            Object userObject = ((DefaultMutableTreeNode)theTreePath.getLastPathComponent()).getUserObject();
            Component treeCellRendererComponent = tree.getCellRenderer().getTreeCellRendererComponent(tree, theTreePath.getLastPathComponent(), false, false, false, 1, false);
            result = treeCellRendererComponent instanceof GWFoldersTreeOrientablePanelRenderer ? 16 - ((GWFoldersTreeOrientablePanelRenderer)treeCellRendererComponent).getWidthUnOpen() : 16;
            if (userObject instanceof AbstractFolder) {
                AbstractFolder folder = (AbstractFolder)userObject;
                boolean collapsed = tree.isCollapsed(theTreePath);
                boolean hasUnopenedItems = folder.hasUnreadItems(collapsed);
                if (folder instanceof SentItemsFolder) {
                    if (EngineCommandManager.getCurrentMode() != EngineMode.CACHING || !hasUnopenedItems) {
                        result = 16;
                    }
                } else if (folder instanceof CalendarFolder) {
                    if (!hasUnopenedItems) {
                        result = 16;
                    }
                } else if (folder instanceof SubCalendarFolder) {
                    result = folder.getParent().isCalendarFolder() ? 0 : 16;
                } else if (folder instanceof UniversalFolder) {
                    if (!hasUnopenedItems) {
                        result = 16;
                    }
                } else if (!hasUnopenedItems || folder instanceof TrashFolder) {
                    result = tree.getComponentOrientation().isLeftToRight() ? 16 : 17;
                }
            }
        }
        return result;
    }
}

