/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree.dnd;

import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.DnDUtils;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import java.awt.Point;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FoldersTreeDropTargetListener
extends DropTargetAdapter {
    private static Logger logger = Logger.getLogger(FoldersTreeDropTargetListener.class);
    private MainGWFoldersTree tree;
    private Timer timerExpander;
    private TreePath lastPath;

    public FoldersTreeDropTargetListener(MainGWFoldersTree theTree) {
        this.tree = theTree;
        this.initTimer();
    }

    private void initTimer() {
        this.timerExpander = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FoldersTreeDropTargetListener.this.tree.isExpanded(FoldersTreeDropTargetListener.this.lastPath)) {
                    if (MainGWFoldersTree.getFolderForPath(FoldersTreeDropTargetListener.this.lastPath) instanceof UserFolder) {
                        logger.debug((Object)"collapsing Home folder skipped");
                        return;
                    }
                    FoldersTreeDropTargetListener.this.tree.collapsePath(FoldersTreeDropTargetListener.this.lastPath);
                } else {
                    FoldersTreeDropTargetListener.this.tree.expandPath(FoldersTreeDropTargetListener.this.lastPath);
                }
                FoldersTreeDropTargetListener.this.tree.repaint();
            }
        });
        this.timerExpander.setRepeats(false);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        Point location = dtde.getLocation();
        TreePath path = this.tree.getClosestPathForLocation(location.x, location.y);
        if (this.lastPath == null || !this.lastPath.equals(path)) {
            this.lastPath = path;
            this.timerExpander.restart();
            this.tree.repaintDragFolder(location);
        }
        String userGuid = ControlsUtils.getUserGuid(this.tree.getController());
        if (DnDUtils.isSameUserGuid(dtde.getTransferable(), userGuid) && this.isDropAllowed(dtde)) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    private boolean isDropAllowed(DropTargetDragEvent dtde) {
        if (this.lastPath == null) {
            return true;
        }
        AbstractFolder folder = MainGWFoldersTree.getFolderForPath(this.lastPath);
        return DnDUtils.isDropOnFolderAllowed(folder, dtde.getTransferable(), this.tree.getController());
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        this.tree.repaint();
    }

    public void dragExit(DropTargetEvent dte) {
        this.stopRepaintTree();
        this.lastPath = null;
        this.tree.getController().processCommand(new GlobalCommand(1751));
    }

    public void drop(DropTargetDropEvent dtde) {
        this.stopRepaintTree();
        if (dtde.isLocalTransfer() && dtde.getCurrentDataFlavorsAsList().contains(GWFlavors.transferItemsFlavor)) {
            this.acceptItemList(dtde);
        }
        this.lastPath = null;
    }

    private void acceptItemList(DropTargetDropEvent dtde) {
        boolean isEditable = this.tree.isEditable();
        this.tree.setEditable(false);
        boolean dropResult = DnDUtils.performTransferToFolder(dtde, MainGWFoldersTree.getFolderForPath(this.lastPath), this.tree.getController());
        this.tree.setEditable(isEditable);
        dtde.dropComplete(dropResult);
        if (OS.isMacOS()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FoldersTreeDropTargetListener.this.tree.getController().processCommand(new GlobalCommand(1750));
                }
            });
        } else {
            this.tree.getController().processCommand(new GlobalCommand(1750));
        }
    }

    private void stopRepaintTree() {
        this.timerExpander.stop();
        this.tree.setDragTargetFolder(null);
        this.tree.repaint();
    }
}

