/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.folderstree.dnd;

import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.controls.folderstree.dnd.FolderDragSourceListener;
import com.novell.gw.jclient.bl.impl.dnd.TransferableWrapper;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class MainGWFoldersTreeDragGestureListener
implements DragGestureListener {
    private static Logger logger = Logger.getLogger(MainGWFoldersTreeDragGestureListener.class);
    private MainGWFoldersTree treeFolders;

    public MainGWFoldersTreeDragGestureListener(MainGWFoldersTree theMainGWFoldersTree) {
        this.treeFolders = theMainGWFoldersTree;
        logger.debug((Object)("this: " + this));
        logger.debug((Object)("treeFolders: " + this.treeFolders));
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        if (dge.getTriggerEvent() instanceof MouseEvent && ((MouseEvent)dge.getTriggerEvent()).getButton() == 2) {
            return;
        }
        AbstractFolder selectedFolder = this.treeFolders.getSelectedFolder();
        if (selectedFolder != null && selectedFolder.getNativeFolder().getType() != FolderType.USER && selectedFolder.getTransferItems() != null) {
            ImageIcon image = ControlsUtils.getImageForFolder(selectedFolder);
            int size = image.getIconWidth() / 2;
            String userGuid = ControlsUtils.getUserGuid(this.treeFolders.getController());
            dge.startDrag(DragSource.DefaultMoveNoDrop, image.getImage(), new Point(size, size), new TransferableWrapper(selectedFolder, userGuid), new FolderDragSourceListener());
        }
    }
}

