/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggleEvent;
import com.novell.gw.jclient.application.options.ApplicationOptions;

public class ActiveTypesToggle
extends TypesToggle {
    private static ActiveTypesToggle instance;

    public ActiveTypesToggle(String thePrefix) {
        super(thePrefix);
        instance = this;
    }

    public ActiveTypesToggle(String thePrefix, boolean defApps, boolean defTasks, boolean defNotes) {
        super(thePrefix, defApps, defNotes, defTasks);
        if (!(defApps || defTasks || defNotes)) {
            defApps = true;
            defTasks = true;
            defNotes = true;
        }
        this.load(defApps, defTasks, defNotes);
        instance = this;
    }

    private void load(boolean theDefApps, boolean theDefTasks, boolean theDefNotes) {
        ApplicationOptions options = ApplicationOptions.getInstance();
        String strPrefix = this.prefix + '.';
        this.showAppointments = options.getBoolean(strPrefix + "SHOW_APPOINTMENTS", theDefApps);
        this.showTasks = options.getBoolean(strPrefix + "SHOW_TASKS", theDefTasks);
        this.showNotes = options.getBoolean(strPrefix + "SHOW_NOTES", theDefNotes);
        this.showAlternateTimeZone = options.getBoolean(strPrefix + "show alternate time zone", false);
    }

    public void setShowAppointments(boolean appointmentsShowing) {
        if (appointmentsShowing != this.showAppointments) {
            this.showAppointments = appointmentsShowing;
            this.fireToggleChanged(new TypesToggleEvent(0));
            ApplicationOptions.getInstance().put(this.prefix + '.' + "SHOW_APPOINTMENTS", this.showAppointments);
        }
    }

    public void setShowAlternateTimeZone(boolean showAlternateTimeZone) {
        if (showAlternateTimeZone != this.showAlternateTimeZone) {
            this.showAlternateTimeZone = showAlternateTimeZone;
            this.fireToggleChanged(new TypesToggleEvent(3));
            ApplicationOptions.getInstance().put(this.prefix + '.' + "show alternate time zone", this.showAlternateTimeZone);
        }
    }

    public void setShowTasks(boolean tasksShowing) {
        if (tasksShowing != this.showTasks) {
            this.showTasks = tasksShowing;
            this.fireToggleChanged(new TypesToggleEvent(2));
            ApplicationOptions.getInstance().put(this.prefix + '.' + "SHOW_TASKS", this.showTasks);
        }
    }

    public void setShowNotes(boolean notesShowing) {
        if (notesShowing != this.showNotes) {
            this.showNotes = notesShowing;
            this.fireToggleChanged(new TypesToggleEvent(1));
            ApplicationOptions.getInstance().put(this.prefix + '.' + "SHOW_NOTES", this.showNotes);
        }
    }

    public static ActiveTypesToggle getInstance() {
        return instance;
    }
}

