/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.AllDayAppointmentItemStatusLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.StaticItemLabel;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class AllDayEventsGridLayout
extends GridLayout {
    private Calendar firstDate;
    private int days;
    private ArrayList<ArrayList<ItemCell>> dayBoxes;
    public static int ITEM_LABEL_HORIZONTAL_INSET = 7;
    public static int ITEM_LABEL_VERTICAL_INSET = 1;
    private boolean isLTR = UIUtils.getComponentOrientation().isLeftToRight();

    public AllDayEventsGridLayout(int days) {
        super(0, days);
        this.days = days;
    }

    public void setFirstDate(Calendar firstDate) {
        this.firstDate = (Calendar)firstDate.clone();
        this.firstDate.set(11, 0);
        this.firstDate.set(12, 0);
        this.firstDate.set(13, 0);
        this.firstDate.set(14, 0);
    }

    public void setDays(int days) {
        this.days = days;
    }

    private void initDayBoxes() {
        this.dayBoxes = new ArrayList(this.days + 1);
        for (int i = 0; i < this.days + 1; ++i) {
            this.dayBoxes.add(new ArrayList());
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        int maxValue;
        Dimension a = super.preferredLayoutSize(parent);
        Component[] components = parent.getComponents();
        int heightOfEventLabel = components.length > 0 ? (int)components[0].getSize().getHeight() + 2 : 0;
        HashMap<Integer, Integer> freqElementsPosition = new HashMap<Integer, Integer>();
        for (Component comp : components) {
            Integer key = new Integer((int)comp.getLocation().getX());
            Integer oldCount = (Integer)freqElementsPosition.get(key);
            Integer newCount = oldCount == null ? new Integer(1) : new Integer(oldCount + 1);
            freqElementsPosition.put(key, newCount);
        }
        ArrayList list = new ArrayList(freqElementsPosition.values());
        Collections.sort(list);
        int n = maxValue = list.size() > 0 ? (Integer)list.get(list.size() - 1) : 0;
        if (maxValue > 0) {
            a.setSize(0, maxValue * heightOfEventLabel);
        } else {
            a.setSize(0.0, a.getHeight());
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        if (this.firstDate == null) {
            return;
        }
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.initDayBoxes();
            int ncomponents = parent.getComponentCount();
            if (ncomponents == 0) {
                return;
            }
            boolean[] processedItems = new boolean[ncomponents];
            Date date = new Date(this.firstDate.getTime().getTime());
            int day = 0;
            int boxWidth = parent.getWidth() / this.days;
            do {
                ArrayList<ItemCell> currentDayBox = this.dayBoxes.get(day);
                boolean unprocessedItemsLeftForDay = true;
                while (unprocessedItemsLeftForDay) {
                    long maxItemDuration = 0L;
                    int curProcessedItem = 0;
                    StaticItemLabel maxDurationAllDayAppointmentItemStatusLabel = null;
                    for (int j = 0; j < ncomponents; ++j) {
                        AllDayAppointmentItemStatusLabel curAllDayAppointmentItemStatusLabel;
                        AppointmentItem item;
                        if (processedItems[j] || (item = (AppointmentItem)(curAllDayAppointmentItemStatusLabel = (AllDayAppointmentItemStatusLabel)parent.getComponent(j)).getItem()).getDurationInDays() <= maxItemDuration || !(day == 0 ? item.getStartDate().before(date) : GWCalendarUtils.isSameDate(item.getStartDate(), date))) continue;
                        maxItemDuration = item.getDurationInDays();
                        maxDurationAllDayAppointmentItemStatusLabel = curAllDayAppointmentItemStatusLabel;
                        curProcessedItem = j;
                        if (!GWCalendarUtils.hasTimeFraction(item.getStartGregorianCalendar())) continue;
                        ++maxItemDuration;
                    }
                    if (maxDurationAllDayAppointmentItemStatusLabel == null) {
                        unprocessedItemsLeftForDay = false;
                        continue;
                    }
                    int firstUnoccupiedSlot = 0;
                    int nSize = currentDayBox.size();
                    for (int i = 0; i < nSize && currentDayBox.get(i) != null && currentDayBox.get((int)i).occupied; ++i) {
                        ++firstUnoccupiedSlot;
                    }
                    processedItems[curProcessedItem] = true;
                    if (day == 0) {
                        Date curItemStartDate = new Date(((AppointmentItem)maxDurationAllDayAppointmentItemStatusLabel.getItem()).getStartDate().getTime());
                        while (curItemStartDate.before(this.firstDate.getTime())) {
                            curItemStartDate.setDate(curItemStartDate.getDate() + 1);
                            --maxItemDuration;
                        }
                    }
                    int k = 0;
                    while ((long)k < maxItemDuration + (long)(day == 0 ? 1 : 0) && k + day < this.dayBoxes.size()) {
                        ArrayList<ItemCell> boxes = this.dayBoxes.get(day + k);
                        for (int nBoxes = boxes.size(); nBoxes <= firstUnoccupiedSlot; ++nBoxes) {
                            boxes.add(new ItemCell(false));
                        }
                        boxes.set(firstUnoccupiedSlot, new ItemCell(true));
                        ++k;
                    }
                    if (day == 0) {
                        ((AllDayAppointmentItemStatusLabel)maxDurationAllDayAppointmentItemStatusLabel).setStartsBeforeView(true);
                    }
                    if (maxItemDuration + (long)day - (long)(day == 0 ? 0 : 1) > (long)this.days) {
                        ((AllDayAppointmentItemStatusLabel)maxDurationAllDayAppointmentItemStatusLabel).setEndsAfterView(true);
                        maxItemDuration = this.days - day + (day == 0 ? 0 : 1);
                    }
                    int itemX = (day == 0 ? 0 : day - 1) * boxWidth + (day == 0 ? 0 : ITEM_LABEL_HORIZONTAL_INSET) + 1;
                    int itemY = firstUnoccupiedSlot * maxDurationAllDayAppointmentItemStatusLabel.getPreferredSize().height + ITEM_LABEL_VERTICAL_INSET;
                    int itemWidth = (int)maxItemDuration * boxWidth - (((AllDayAppointmentItemStatusLabel)maxDurationAllDayAppointmentItemStatusLabel).isEndsAfterView() ? ITEM_LABEL_HORIZONTAL_INSET : ITEM_LABEL_HORIZONTAL_INSET * 2) + (day == 0 ? ITEM_LABEL_HORIZONTAL_INSET : 0) - 2;
                    int itemHeight = maxDurationAllDayAppointmentItemStatusLabel.getPreferredSize().height - ITEM_LABEL_VERTICAL_INSET * 2;
                    if (this.isLTR) {
                        maxDurationAllDayAppointmentItemStatusLabel.setBounds(itemX, itemY, itemWidth, itemHeight);
                        continue;
                    }
                    maxDurationAllDayAppointmentItemStatusLabel.setBounds(parent.getWidth() - itemX - itemWidth, itemY, itemWidth, itemHeight);
                }
                if (day <= 0) continue;
                date.setDate(date.getDate() + 1);
            } while (++day <= this.days);
        }
    }

    static class ItemCell {
        public boolean occupied = false;

        public ItemCell(boolean occupied) {
            this.occupied = occupied;
        }
    }
}

