/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.application.commands.AttributeKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.MonthlyView;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyView;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarViewController
extends MVCController<CalendarView> {
    public CalendarViewController(CalendarView view, MVCController theParentController) {
        super(view, theParentController);
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        Level level = this.getFrameLevel();
        AppEventListener listener = new SELECTED_DATE_CHANGED_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 70, listener);
        this.addListenerDescriptor(descriptor);
        listener = new FOLDER_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 10, listener);
        this.addListenerDescriptor(descriptor);
        listener = new GWITEM_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 20, listener);
        this.addListenerDescriptor(descriptor);
        listener = new NO_ITEMS_SELECTED_listener();
        descriptor = new AppEventListenerDescriptor(level, 470, listener);
        this.addListenerDescriptor(descriptor);
    }

    private class NO_ITEMS_SELECTED_listener
    extends AppEventListener {
        private NO_ITEMS_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (((CalendarView)CalendarViewController.this.getMVCView()).getActiveViewType() == CalendarViewType.DAILY && CalendarViewController.this.getMVCView() instanceof DailyView) {
                ((DailyView)CalendarViewController.this.getMVCView()).setItemSel(null);
            } else if (((CalendarView)CalendarViewController.this.getMVCView()).getActiveViewType() == CalendarViewType.WEEKLY && CalendarViewController.this.getMVCView() instanceof WeeklyView) {
                ((WeeklyView)CalendarViewController.this.getMVCView()).setItemSel(null);
            }
        }
    }

    private class GWITEM_SELECTED_listener
    extends AppEventListener {
        private GWITEM_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ISelectedItemsInfo itemsInfo = (ISelectedItemsInfo)theEvent.getData();
            if (itemsInfo != null && itemsInfo.hasItems()) {
                itemsInfo.getItemList().setSelection(MessageUtils.getItemsAsArray(itemsInfo.getItems()));
            }
            if (!(CalendarViewController.this.getParentController().getMVCView() instanceof GWCalendar)) {
                return;
            }
            CalendarViewType calendarViewTypeType = ((GWCalendar)CalendarViewController.this.getParentController().getMVCView()).getToolbarViewType();
            if ((calendarViewTypeType == CalendarViewType.DAILY || calendarViewTypeType == null) && CalendarViewController.this.getMVCView() instanceof DailyView) {
                ((DailyView)CalendarViewController.this.getMVCView()).setItemSel(ControlsUtils.getGWItemSelectedCommandObjectAsItem(theEvent));
            } else if ((calendarViewTypeType == CalendarViewType.WEEKLY || calendarViewTypeType == null) && CalendarViewController.this.getMVCView() instanceof WeeklyView) {
                ((WeeklyView)CalendarViewController.this.getMVCView()).setItemSel(ControlsUtils.getGWItemSelectedCommandObjectAsItem(theEvent));
            }
        }
    }

    private class FOLDER_SELECTED_listener
    extends AppEventListener {
        private FOLDER_SELECTED_listener() {
        }

        public void handle(AppEvent theEvent) {
            if (CalendarViewController.this.getMVCView() instanceof MonthlyView) {
                MonthlyView monthlyView = (MonthlyView)CalendarViewController.this.getMVCView();
                monthlyView.closePopup();
            }
        }
    }

    private class SELECTED_DATE_CHANGED_listener
    extends AppEventListener {
        private SELECTED_DATE_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object att = theEvent.getAttribute((Object)AttributeKey.CALENDAR);
            if (att != null) {
                MVCController topController = (MVCController)att;
                if (CalendarViewController.this.isChildOf(topController)) {
                    ((CalendarView)CalendarViewController.this.getMVCView()).setMVCModel(((Calendar)theEvent.getData()).getTime());
                }
            } else {
                ((CalendarView)CalendarViewController.this.getMVCView()).setMVCModel(((Calendar)theEvent.getData()).getTime());
            }
        }
    }
}

