/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.Timer;

public class DatePanel
extends OrientablePanel
implements ActionListener {
    private Calendar calendar;
    private JLabel lblBigDay;
    private JLabel lblDayOfWeek;
    private JLabel lblDate;
    private JLabel lblTime;

    public DatePanel() {
        this(DatePanel.getDefaultCalendar());
    }

    public DatePanel(Calendar calendar) {
        this.init();
        this.buildUI();
        this.setCalendar(calendar);
    }

    private void init() {
        this.lblBigDay = DatePanel.createLabel(3.5);
        float multiplier = 1.3f;
        this.lblDayOfWeek = DatePanel.createLabel(multiplier);
        this.lblDate = DatePanel.createLabel(multiplier);
        this.lblTime = DatePanel.createLabel(multiplier);
        new Timer(1000, this).start();
    }

    private static JLabel createLabel(double fontSizeMultiplier) {
        SkinnableLabel label = new SkinnableLabel();
        label.putClientProperty((Object)SkinProperty.TOOLBAR_TEXT_COLOR, (Object)ComponentProperty.FOREGROUND);
        Font oldFont = label.getFont();
        label.setFont(new Font(oldFont.getName(), 1, (int)((double)oldFont.getSize() * fontSizeMultiplier)));
        return label;
    }

    private void buildUI() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 23;
        this.add((Component)this.lblBigDay, constraints);
        ++constraints.gridy;
        this.add((Component)this.lblDayOfWeek, constraints);
        ++constraints.gridy;
        this.add((Component)this.lblDate, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)this.lblTime, constraints);
    }

    private static Calendar getDefaultCalendar() {
        return Calendar.getInstance();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException();
        }
        this.calendar = (Calendar)calendar.clone();
        this.refreshView();
    }

    private synchronized void refreshView() {
        int dayOfMonth = this.calendar.get(5);
        this.lblBigDay.setText(Integer.toString(dayOfMonth));
        int day = this.calendar.get(7);
        String dayOfWeek = GWCalendarUtils.getWeekDayName(day - 1, GWCalendarUtils.DayNameLength.FULL);
        this.lblDayOfWeek.setText(dayOfWeek);
        DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
        Date date = this.calendar.getTime();
        String dateFormat = dateTimeOptions.getShortDateFormat();
        this.lblDate.setText(DateAndTimeFormattingUtils.getDateFormat(dateFormat).format(date));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isShowing()) {
            DateTimeOptions dateTimeOptions = OptionManager.getInstance().getDateTimeOptions();
            String timeFormat = dateTimeOptions.getTimeFormat();
            this.lblTime.setText(DateAndTimeFormattingUtils.getDateFormat(timeFormat).format(Calendar.getInstance().getTime()));
        }
    }
}

