/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.utils.UIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;
import org.apache.log4j.Logger;

public class DayBorder
extends AbstractBorder {
    private static Logger logger = Logger.getLogger(DayBorder.class);
    public static int BORDER_TODAY_SELECTED = 0;
    public static int BORDER_TODAY_UNSELECTED = 1;
    public static int BORDER_DAY_SELECTED = 2;
    public static int BORDER_DAY_UNSELECTED = 4;
    protected static final int a = 4;
    protected Color borderColor = Color.black;
    protected int borderStyle;
    private BasicStroke lineStroke;
    private int lineWidth;

    public DayBorder(int theBorderStyle) {
        this(theBorderStyle, 1);
    }

    public DayBorder(int theBorderStyle, int theLineWidth) {
        this.borderStyle = theBorderStyle;
        this.lineWidth = theLineWidth;
        this.lineStroke = new BasicStroke(this.lineWidth);
        if (theBorderStyle == BORDER_TODAY_UNSELECTED || theBorderStyle == BORDER_DAY_UNSELECTED) {
            this.borderColor = Color.GRAY;
        }
    }

    public DayBorder() {
        this(BORDER_TODAY_UNSELECTED);
    }

    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)UIUtils.enableAntialiasing(gr);
        g.setColor(this.borderColor);
        int ww = width - 1;
        int hh = height - 1;
        Stroke stroke = g.getStroke();
        g.setStroke(this.lineStroke);
        g.drawRect(x + this.lineWidth - 1, y + this.lineWidth - 1, width - this.lineWidth, height - this.lineWidth);
        g.setStroke(stroke);
        if (this.borderStyle == BORDER_DAY_SELECTED || this.borderStyle == BORDER_DAY_UNSELECTED) {
            return;
        }
        g.setColor(Color.black);
        int aa = 4;
        for (int i = 0; i <= 4; ++i) {
            g.drawLine(x, y + i, x + aa, y + i);
            g.drawLine(x + ww, y + i, x + ww - aa, y + i);
            g.drawLine(x, y + hh - aa, x + i, y + hh - aa);
            g.drawLine(x + ww, y + hh - aa, x + ww - i, y + hh - aa);
            --aa;
        }
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(4, 4, 4, 4);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 4;
        insets.right = 4;
        insets.top = 4;
        insets.left = 4;
        return insets;
    }
}

