/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.AppAction;
import com.appframework.listener.ListenerType;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.CalendarFolderChangeListener;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewCalendarItem;
import com.novell.gw.jclient.application.actions.send.DefaultSendCallbackImpl;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.IItemListComponentDataModel;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveTypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarRefreshEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ClockListener;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.PanelTypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggleChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggleEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.calendarpanel.CalendarToolBar;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyView;
import com.novell.gw.jclient.application.controls.gwcalendar.monthly.monthlyview.MonthlyView;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.WeeklyView;
import com.novell.gw.jclient.application.controls.gwcalendar.yearly.YearlyView;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListComponent;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListSelectionListener;
import com.novell.gw.jclient.application.controls.itemlistview.ItemSelectionChangedEvent;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.panelviews.PanelViewController;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCalendar
extends SkinnablePanel
implements MVCView<GWCalendarController, Object>,
ItemListComponent {
    private static Logger logger = Logger.getLogger(GWCalendar.class);
    private GWCalendarController controller;
    private JPanel pnlGWCalendar;
    private DailyView pnlDaily;
    private WeeklyView pnlWeekly;
    private MonthlyView pnlMonthly;
    private YearlyView pnlYear;
    private Calendar currentDay;
    private CalendarToolBar toolbar;
    private TypesToggle typesToggle;
    private ViewsToggle viewsToggle;
    private TypesToggle typesToggleDaily;
    private TypesToggle typesToggleWeekly;
    private TypesToggle typesToggleMonthly;
    private TypesToggle typesToggleYearly;
    private boolean activated = true;
    private static final int CLOCK_PERIOD = 1000;
    private boolean isDailyOnly;
    private CalendarTimer clock;
    private ClockAction clockAction;
    private List<ClockListener> clockListeners;
    private List<CalendarStateListener> stateListeners;
    private boolean showViewsToggleButtons = true;
    private static int nextInstanceId = 0;
    private int instanceId = nextInstanceId++;
    private boolean isSimpleNavigation = false;
    private IItemListComponentDataModel calendarItemListData = null;
    private CalendarFolderChangeListener itemListListener = null;
    private List<ItemListSelectionListener> selectionListeners = new ArrayList<ItemListSelectionListener>();
    private IItem selectedItem;

    public GWCalendar(Calendar theDate, boolean isDailyOnly, MVCController theParentController, IItemListComponentDataModel calendarModel) {
        this(theDate, isDailyOnly, theParentController, null, calendarModel);
    }

    public GWCalendar(Calendar theDate, boolean isDailyOnly, MVCController theParentController, PropertiesViewListItem calendarType, IItemListComponentDataModel calendarModel) {
        this(theDate, isDailyOnly, theParentController, calendarType, true, calendarModel, false);
    }

    public GWCalendar(Calendar theDate, boolean isDailyOnly, MVCController theParentController, PropertiesViewListItem calendarType, boolean showViewsToggleButtons, IItemListComponentDataModel calendarModel, boolean isSimpleNavigation) {
        if (calendarModel == null) {
            throw new IllegalArgumentException("calendarModel is null");
        }
        logger.debug((Object)("creating calendar: " + this));
        this.calendarItemListData = calendarModel;
        this.isSimpleNavigation = isSimpleNavigation;
        this.showViewsToggleButtons = showViewsToggleButtons;
        this.init(theDate, isDailyOnly, theParentController, calendarType);
        if (!this.isDailyOnly) {
            if (calendarType != null) {
                this.viewsToggle.setType(calendarType);
                this.adjustView(this.viewsToggle.getType());
            } else {
                this.adjustView(this.viewsToggle.getType());
            }
        } else {
            this.adjustView(CalendarViewType.DAILY);
        }
        this.itemListListener = new CalendarFolderChangeListener(this);
        if (this.activated) {
            this.calendarItemListData.getItemList().addItemListListener(this.itemListListener);
        }
        logger.debug((Object)"CalendarFolderChangeListener created");
        ControlsUtils.getListenerManager(this.getController()).addListener(this, new GWCalendarFocusListener(), ListenerType.FOCUS_LISTENER);
    }

    @Override
    public AbstractFolder getAbstractFolder() {
        return this.calendarItemListData.getAbstractFolder();
    }

    public CalendarViewType getToolbarViewType() {
        return this.toolbar == null ? null : this.toolbar.getViewType();
    }

    private boolean isOnPanel() {
        return this.getController().isChildOf(PanelViewController.class);
    }

    public CalendarToolBar getCalendarToolBar() {
        return this.toolbar;
    }

    public void refresh() {
        this.activate(true);
        this.viewsToggle.fireToggleChanged(new ViewsToggleEvent(null, this.calendarItemListData.getViewDisplaySettings().getCalViewType()));
        this.refreshCalendarToolBar();
    }

    public void refreshUIOptins() {
        if (this.pnlDaily != null) {
            this.pnlDaily.refreshUIOptions();
        }
        if (this.pnlWeekly != null) {
            this.pnlWeekly.refreshUIOptions();
        }
        if (this.pnlMonthly != null) {
            this.pnlMonthly.refreshUIOptions();
        }
        if (this.pnlYear != null) {
            this.pnlYear.refreshUIOptions();
        }
        if (this.toolbar != null) {
            this.toolbar.refreshUIOptions();
        }
    }

    public void refreshCalendarToolBar() {
        if (this.toolbar != null) {
            this.toolbar.refresh();
        }
    }

    private void adjustView(CalendarViewType theCalendarViewTypeType) {
        this.pnlGWCalendar.removeAll();
        switch (theCalendarViewTypeType) {
            case DAILY: {
                this.pnlGWCalendar.add((Component)this.getDailyView(), "Center");
                break;
            }
            case WEEKLY: {
                this.pnlGWCalendar.add((Component)this.getWeeklyView(), "Center");
                break;
            }
            case MONTHLY: {
                this.pnlGWCalendar.add((Component)this.getMonthlyView(), "Center");
                break;
            }
            case YEARLY: {
                this.pnlGWCalendar.add((Component)this.getYearlyView(), "Center");
            }
        }
        this.validateTree();
        this.repaint();
        this.fireStateChanged(new CalendarStateEvent(this.activated, theCalendarViewTypeType));
        this.requestFocus(theCalendarViewTypeType);
    }

    public void activate(boolean state) {
        logger.debug((Object)("activate: " + state + ", calendar: " + this));
        if (state != this.activated) {
            this.activated = state;
            if (state) {
                this.calendarItemListData.getItemList().addItemListListener(this.itemListListener);
            } else {
                this.calendarItemListData.getItemList().removeItemListListener(this.itemListListener);
            }
            CalendarViewType type = !this.isDailyOnly ? this.viewsToggle.getType() : CalendarViewType.DAILY;
            this.fireStateChanged(new CalendarStateEvent(this.activated, type));
        }
        if (this.activated) {
            this.clock.start();
        } else {
            this.clock.stop();
        }
    }

    public void setActivated(boolean activated) {
        this.activate(activated);
    }

    @Override
    public void setController(GWCalendarController theController) {
        this.controller = theController;
    }

    @Override
    public GWCalendarController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(Object theModel) {
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    public static void createNewCalendarItem(String type, Date theDate, MVCController theController, boolean isPosted) {
        ActionNewCalendarItem actionNewCalendarItem = null;
        if (isPosted) {
            if (type.equals("Appointment")) {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_POSTED_APPOINTMENT));
            } else if (type.equals("AllDayEvent")) {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_POSTED_ALL_DAY_EVENT));
            } else if (type.equals("Task")) {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_POSTED_TASK));
            } else if (type.equals("Note")) {
                actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_POSTED_REMINDERNOTE));
            }
        } else if (type.equals("Appointment")) {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_APPOINTMENT));
        } else if (type.equals("AllDayEvent")) {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_ALL_DAY_EVENT));
        } else if (type.equals("Note")) {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_REMINDERNOTE));
        } else if (type.equals("Task")) {
            actionNewCalendarItem = (ActionNewCalendarItem)((Object)theController.getActionList().getAction(ActionKey.NEW_TASK));
        }
        if (actionNewCalendarItem != null) {
            actionNewCalendarItem.setSelectedDate(theDate);
            ((AppAction)((Object)actionNewCalendarItem)).actionPerformed(null);
        }
    }

    void postNewPostedCalendarItem(String type, Calendar startDate, String theSubject) {
        String userGuid = ControlsUtils.getUserGuid(this);
        AbstractCalendarItem newItem = null;
        try {
            Calendar endDate;
            AbstractFolder folder = this.calendarItemListData.getAbstractFolder();
            if (type.equals("Appointment")) {
                newItem = (AppointmentItem)GWCommandManager.getInstance(userGuid).composeNewItem(AppointmentItem.class, true, folder);
                endDate = (Calendar)startDate.clone();
                int duratioMin = (Integer)EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getSettings().getAppointmentDefaultLength().getValue();
                endDate.add(12, duratioMin);
            } else {
                GWCalendarUtils.clearTime(startDate);
                endDate = (Calendar)startDate.clone();
                if (type.equals("AllDayEvent")) {
                    newItem = (AppointmentItem)GWCommandManager.getInstance(userGuid).composeNewItem(AppointmentItem.class, true, folder);
                    ((AppointmentItem)newItem).setAllDayEvent(true);
                    endDate.add(11, 24);
                } else if (type.equals("Task")) {
                    newItem = (TaskItem)GWCommandManager.getInstance(userGuid).composeNewItem(TaskItem.class, true, folder);
                } else if (type.equals("Note")) {
                    newItem = (ReminderNote)GWCommandManager.getInstance(userGuid).composeNewItem(ReminderNote.class, true, folder);
                }
            }
            if (newItem != null) {
                newItem.setStartDates(new Date[]{startDate.getTime()});
                newItem.setEndDate(endDate.getTime());
                newItem.setSubject(theSubject);
                GWCommandManager.getInstance(userGuid).postItem(newItem, new DefaultSendCallbackImpl(), null);
            }
        }
        catch (ItemNotCreatedException ex) {
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
    }

    private void init(Calendar theDate, boolean isDailyOnly, MVCController theParentController, PropertiesViewListItem calendarType) {
        this.currentDay = theDate;
        this.setController(new GWCalendarController(this, theParentController));
        this.stateListeners = new ArrayList<CalendarStateListener>();
        this.pnlGWCalendar = new OrientablePanel(new BorderLayout());
        this.pnlGWCalendar.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        this.pnlGWCalendar.setOpaque(false);
        this.clockListeners = new ArrayList<ClockListener>();
        this.clockAction = new ClockAction();
        this.clock = new CalendarTimer(1000, this.clockAction);
        this.isDailyOnly = isDailyOnly;
        this.setPreferredSize(new Dimension(500, 360));
        this.setLayout(new BorderLayout());
        this.add((Component)this.pnlGWCalendar, "Center");
        this.viewsToggle = this.calendarItemListData.getViewDisplaySettings() == null ? new ViewsToggle(calendarType.getView()) : new ViewsToggle(this.calendarItemListData.getViewDisplaySettings());
        this.viewsToggle.addChangeListener(new ViewsChangeListener());
        ApplicationOptions options = ApplicationOptions.getInstance();
        if (this.isDailyOnly) {
            this.typesToggle = this.typesToggleDaily = new TypesToggle("CALENDAR_DAILY", options.getBoolean("CALENDAR_DAILY.SHOW_APPOINTMENTS"), options.getBoolean("CALENDAR_DAILY.SHOW_TASKS"), options.getBoolean("CALENDAR_DAILY.SHOW_NOTES"));
        } else {
            if (!this.isOnPanel()) {
                IViewDisplaySettings ds = this.calendarItemListData.getViewDisplaySettings();
                if (ds != null) {
                    this.typesToggleWeekly = this.typesToggleDaily = new ActiveTypesToggle("CALENDAR_DAILY", GWCalendarUtils.isShowCalendarAppointments(ds), GWCalendarUtils.isShowCalendarTasks(ds), GWCalendarUtils.isShowCalendarNotes(ds));
                    this.typesToggleMonthly = this.typesToggleDaily;
                } else {
                    this.typesToggleDaily = new ActiveTypesToggle("CALENDAR_DAILY", options.getBoolean("CALENDAR_DAILY.SHOW_APPOINTMENTS"), options.getBoolean("CALENDAR_DAILY.SHOW_TASKS"), options.getBoolean("CALENDAR_DAILY.SHOW_NOTES"));
                    this.typesToggleWeekly = new ActiveTypesToggle("CALENDAR_WEEKLY", options.getBoolean("CALENDAR_WEEKLY.SHOW_APPOINTMENTS"), options.getBoolean("CALENDAR_WEEKLY.SHOW_TASKS"), options.getBoolean("CALENDAR_WEEKLY.SHOW_NOTES"));
                    this.typesToggleMonthly = new ActiveTypesToggle("CALENDAR_MONTHLY", options.getBoolean("CALENDAR_MONTHLY.SHOW_APPOINTMENTS"), options.getBoolean("CALENDAR_MONTHLY.SHOW_TASKS"), options.getBoolean("CALENDAR_MONTHLY.SHOW_NOTES"));
                }
            } else {
                this.typesToggleWeekly = this.typesToggleMonthly = new PanelTypesToggle(this.calendarItemListData.getViewDisplaySettings());
                this.typesToggleDaily = this.typesToggleMonthly;
            }
            this.typesToggleYearly = new ActiveTypesToggle("CALENDAR_YEARLY", true, true, true);
            CalendarViewType toggleType = calendarType != null ? calendarType.getView() : this.viewsToggle.getType();
            this.setTypesToggle(toggleType);
        }
        this.createToolBar();
        if (!this.isDailyOnly && this.calendarItemListData.getViewDisplaySettings() != null && this.calendarItemListData.getViewDisplaySettings().showCalToolbar()) {
            this.toolbar.setVisible(true);
        } else {
            this.toolbar.setVisible(false);
        }
    }

    private void prosessViewDisplaySettingsChanged() {
        IViewDisplaySettings ds = this.calendarItemListData.getViewDisplaySettings();
        if (this.pnlDaily != null) {
            this.pnlDaily.setMonthPickerVisibled(ds.showCalSmallMonths());
        }
        if (this.pnlWeekly != null) {
            this.pnlWeekly.setMonthPickerVisibled(ds.showCalSmallMonths());
        }
        if (this.pnlMonthly != null) {
            this.pnlMonthly.setMonthPickerVisibled(ds.showCalSmallMonths());
        }
        this.viewsToggle.setDisplaySettings(ds);
        if (this.getCalendarToolBar().getTypesToggle().isShowAppointments() != GWCalendarUtils.isShowCalendarAppointments(ds)) {
            this.getCalendarToolBar().getTypesToggle().setShowAppointments(GWCalendarUtils.isShowCalendarAppointments(ds));
        }
        if (this.getCalendarToolBar().getTypesToggle().isShowNotes() != GWCalendarUtils.isShowCalendarNotes(ds)) {
            this.getCalendarToolBar().getTypesToggle().setShowNotes(GWCalendarUtils.isShowCalendarNotes(ds));
        }
        if (this.getCalendarToolBar().getTypesToggle().isShowTasks() != GWCalendarUtils.isShowCalendarTasks(ds)) {
            this.getCalendarToolBar().getTypesToggle().setShowTasks(GWCalendarUtils.isShowCalendarTasks(ds));
        }
        this.setCalendarToolBarVisible(ds.showCalToolbar());
        this.toolbar.setDisplaySettings(ds);
        this.validate();
    }

    @Override
    public IViewDisplaySettings getViewDisplaySettings() {
        return this.calendarItemListData.getViewDisplaySettings();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        this.activate(false);
        this.saveOptions();
    }

    @Override
    public IFolder getFolder() {
        AbstractFolder abstractFolder = this.calendarItemListData.getAbstractFolder();
        return abstractFolder == null ? null : abstractFolder.getNativeFolder();
    }

    private void setCalendarToolBarVisible(boolean toolBarVisible) {
        if (this.toolbar == null) {
            this.createToolBar();
        }
        this.toolbar.setVisible(toolBarVisible);
    }

    private void createToolBar() {
        this.toolbar = new CalendarToolBar(this.currentDay, this.typesToggle, this.viewsToggle, this.controller, this.typesToggleDaily, this.typesToggleWeekly, this.typesToggleMonthly, this.typesToggleYearly, this.showViewsToggleButtons, this.isSimpleNavigation, this.calendarItemListData.getViewDisplaySettings());
        this.add((Component)this.toolbar, "North");
        this.stateListeners.add(this.toolbar);
    }

    private void setTypesToggle(CalendarViewType toggleType) {
        this.typesToggle = toggleType == CalendarViewType.DAILY ? this.typesToggleDaily : (toggleType == CalendarViewType.WEEKLY ? this.typesToggleWeekly : (toggleType == CalendarViewType.MONTHLY ? this.typesToggleMonthly : this.typesToggleYearly));
    }

    private boolean isQuickViewerVisible() {
        String userGuid = ControlsUtils.getUserGuid(this.controller);
        return GWCommandManager.getInstance(userGuid).getAppearanceSettings().isQuickViewerVisible();
    }

    @Override
    public void doLayout() {
        if (this.isVisible()) {
            super.doLayout();
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
    }

    private DailyView createDailyView() {
        boolean showMiniMonth = true;
        if (this.calendarItemListData.getViewDisplaySettings() != null) {
            showMiniMonth = this.calendarItemListData.getViewDisplaySettings().showCalSmallMonths();
        }
        return new DailyView(this.currentDay, this.typesToggleDaily, this.controller, showMiniMonth, this.calendarItemListData);
    }

    private DailyView getDailyView() {
        if (this.pnlDaily == null) {
            this.pnlDaily = this.createDailyView();
            this.stateListeners.add(this.pnlDaily);
            this.clockListeners.add(this.pnlDaily);
        }
        return this.pnlDaily;
    }

    private WeeklyView createWeeklyView() {
        boolean showMiniMonth = false;
        if (this.calendarItemListData.getViewDisplaySettings() != null) {
            showMiniMonth = this.calendarItemListData.getViewDisplaySettings().showCalSmallMonths();
        }
        return new WeeklyView(this.currentDay, this.typesToggleWeekly, this.controller, showMiniMonth, this.calendarItemListData);
    }

    public WeeklyView getWeeklyView() {
        if (this.pnlWeekly == null) {
            this.pnlWeekly = this.createWeeklyView();
            this.stateListeners.add(this.pnlWeekly);
            this.clockListeners.add(this.pnlWeekly);
        }
        return this.pnlWeekly;
    }

    public void setCurrentDay(Calendar currentDay) {
        this.currentDay = currentDay;
    }

    private MonthlyView createMonthlyView() {
        boolean showMiniMonth = false;
        if (this.calendarItemListData.getViewDisplaySettings() != null) {
            showMiniMonth = this.calendarItemListData.getViewDisplaySettings().showCalSmallMonths();
        }
        return new MonthlyView(this.currentDay, this.typesToggleMonthly, this.controller, showMiniMonth, this.calendarItemListData);
    }

    private MonthlyView getMonthlyView() {
        if (this.pnlMonthly == null) {
            this.pnlMonthly = this.createMonthlyView();
            this.stateListeners.add(this.pnlMonthly);
            this.clockListeners.add(this.pnlMonthly);
        }
        return this.pnlMonthly;
    }

    private YearlyView createYearlyView() {
        return new YearlyView(this.currentDay, this.typesToggleYearly, this.controller, this.calendarItemListData);
    }

    private YearlyView getYearlyView() {
        if (this.pnlYear == null) {
            this.pnlYear = this.createYearlyView();
            this.stateListeners.add(this.pnlYear);
        }
        return this.pnlYear;
    }

    public void notifyRefresh(TimeInterval theRefreshInterval) {
        CalendarRefreshEvent event = new CalendarRefreshEvent();
        event.setRefreshInterval(theRefreshInterval);
        this.fireNotifyRefresh(event);
    }

    private void fireNotifyRefresh(CalendarRefreshEvent event) {
        for (CalendarStateListener listener : this.stateListeners.toArray(new CalendarStateListener[this.stateListeners.size()])) {
            listener.refresh(event);
        }
    }

    private void fireStateChanged(CalendarStateEvent event) {
        for (CalendarStateListener listener : this.stateListeners.toArray(new CalendarStateListener[this.stateListeners.size()])) {
            listener.change(event);
        }
    }

    private void fireFolderChanged() {
        if (this.pnlDaily != null) {
            this.pnlDaily.folderChanged();
        }
        if (this.pnlWeekly != null) {
            this.pnlWeekly.folderChanged();
        }
        if (this.pnlMonthly != null) {
            this.pnlMonthly.folderChanged();
        }
        if (this.pnlYear != null) {
            this.pnlYear.folderChanged();
        }
    }

    private void fireClockTik() {
        for (ClockListener listener : this.clockListeners) {
            listener.clockTik();
        }
    }

    public void rebuildHoursPanels() {
        if (this.pnlDaily != null) {
            this.pnlDaily.rebuild();
        }
        if (this.pnlWeekly != null) {
            this.pnlWeekly.rebuild();
        }
    }

    public CalendarViewType getViewsToggleType() {
        return this.viewsToggle.getType();
    }

    @Override
    public void requestFocus() {
        CalendarViewType type = this.isDailyOnly ? CalendarViewType.DAILY : this.viewsToggle.getType();
        this.requestFocus(type);
    }

    private void requestFocus(CalendarViewType theViewType) {
        switch (theViewType) {
            case DAILY: {
                this.pnlDaily.requestFocus();
                break;
            }
            case WEEKLY: {
                this.pnlWeekly.requestFocus();
                break;
            }
            case MONTHLY: {
                this.pnlMonthly.requestFocus();
                break;
            }
            case YEARLY: {
                this.pnlYear.requestFocus();
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append('[');
        builder.append("instanceId=");
        builder.append(this.instanceId);
        builder.append(']');
        return builder.toString();
    }

    private void saveOptions() {
        if (this.pnlWeekly != null) {
            this.pnlWeekly.storeDaysCount();
        }
    }

    void processItemSelectionChangedEvent(IItem item) {
        this.selectedItem = item;
        ItemSelectionChangedEvent event = item == null ? new ItemSelectionChangedEvent(new IItem[0], this) : new ItemSelectionChangedEvent(new IItem[]{item}, this);
        for (ItemListSelectionListener listener : this.selectionListeners.toArray(new ItemListSelectionListener[this.selectionListeners.size()])) {
            listener.itemSelectionChanged(event);
        }
    }

    @Override
    public void addItemListSelectionListener(ItemListSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    @Override
    public IItem[] getSelectedItems() {
        IItem[] iItemArray;
        if (this.selectedItem == null) {
            iItemArray = new IItem[]{};
        } else {
            IItem[] iItemArray2 = new IItem[1];
            iItemArray = iItemArray2;
            iItemArray2[0] = this.selectedItem;
        }
        return iItemArray;
    }

    @Override
    public void removeItemListSelectionListener(ItemListSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    @Override
    public void setData(AbstractFolder folder, IViewDisplaySettings viewDisplaySettings, IItemList itemList) {
        if (this.activated) {
            this.calendarItemListData.getItemList().removeItemListListener(this.itemListListener);
        }
        this.calendarItemListData.setData(folder, viewDisplaySettings, itemList);
        if (this.activated) {
            this.calendarItemListData.getItemList().addItemListListener(this.itemListListener);
        }
        if (this.activated) {
            this.notifyRefresh(null);
        }
        this.prosessViewDisplaySettingsChanged();
        this.fireFolderChanged();
    }

    private class GWCalendarFocusListener
    extends FocusAdapter {
        private GWCalendarFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            logger.debug((Object)("GWCalendar gained focus, restoring selected item: " + GWCalendar.this.selectedItem));
            GWCalendar.this.processItemSelectionChangedEvent(GWCalendar.this.selectedItem);
        }
    }

    private class ViewsChangeListener
    implements ViewsToggleChangeListener {
        private ViewsChangeListener() {
        }

        public void changed(ViewsToggleEvent theEvent) {
            GWCalendar.this.adjustView(theEvent.getNewValue());
        }
    }

    public static class CalendarTimer {
        private int delay = 500;
        private ActionListener actionListener = null;
        private Thread thread;
        private boolean started = false;

        public CalendarTimer(int delay, ActionListener listener) {
            logger.debug((Object)"### Creating new CalendarTimer...");
            this.delay = delay;
            this.actionListener = listener;
        }

        public void start() {
            if (!this.started) {
                this.startThread();
                this.started = true;
            }
        }

        public void stop() {
            if (this.started) {
                this.stopThread();
                this.started = false;
            }
        }

        private void startThread() {
            this.thread = new Thread(){

                public void run() {
                    CalendarTimer timer = CalendarTimer.this;
                    while (!this.isInterrupted()) {
                        if (timer.actionListener != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    CalendarTimer.this.actionListener.actionPerformed(null);
                                }
                            });
                        }
                        try {
                            1.sleep(timer.delay);
                        }
                        catch (InterruptedException e) {
                            if (this.isInterrupted()) continue;
                            this.interrupt();
                        }
                    }
                }
            };
            this.thread.start();
        }

        private void stopThread() {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    private class ClockAction
    extends AbstractAction {
        boolean isDateChanged = false;

        private ClockAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (GWClient.isPerformingExit()) {
                logger.debug((Object)("calendar: " + GWCalendar.this));
                logger.debug((Object)"application is exiting > skipping action");
                return;
            }
            Calendar gc = GWCalendarUtils.getToday();
            if (gc.get(11) == 0 && !this.isDateChanged) {
                this.isDateChanged = true;
                Command com = new Command(70, gc);
                GWCalendar.this.getController().processCommand(com);
            }
            if (gc.get(11) == 23) {
                this.isDateChanged = false;
            }
            GWCalendar.this.fireClockTik();
        }
    }
}

