/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.appframework.AppAction;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewCalendarItem;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class GWCalendarPopup
extends GWPopupMenu {
    private static Logger logger = Logger.getLogger(GWCalendarPopup.class);
    private String itemType = "Appointment";
    private Date date;
    private MVCController controller;
    private HashMap actionMap = new HashMap();

    public GWCalendarPopup(String itemType, MVCController controller) {
        this(itemType, new Date(), controller);
    }

    public GWCalendarPopup(String type, Date theDate, MVCController theController) {
        this.itemType = type;
        this.date = theDate;
        this.controller = theController;
        this.buildUI();
        this.initActionsMap();
    }

    private void initActionsMap() {
        int nCount = this.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            Collection collection = this.actionMap.values();
            for (AppAction action : collection) {
                ((ActionNewCalendarItem)((Object)action)).setSelectedDate(this.date);
                ((ActionNewCalendarItem)((Object)action)).setCalendarView(true);
            }
        }
    }

    private void buildUI() {
        this.add(GWCalendarUtils.buildNewCalendarItemMenu(this.controller, this.itemType, this.actionMap));
        AppAction action = this.controller.getActionList().getAction(ActionKey.ALTERNATE_TIME_ZONE);
        this.add(action.getMenuItem());
        if (this.itemType.equals("AllDayEvent")) {
            this.addSeparator();
            action = this.controller.getActionList().getAction(ActionKey.AUTOSIZE_ALL_DAY_EVENT_ACTIONS);
            this.add(action.getMenuItem());
        }
    }

    public void setDate(Date date) {
        this.date = date;
        this.initActionsMap();
    }

    public HashMap getActionsMap() {
        return this.actionMap;
    }
}

