/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.gwcalendar.MultilineLabel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarConstants;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipManager;
import com.novell.gw.jclient.application.options.ColorsOptions;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ItemAndItemListInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public abstract class StaticItemLabel
extends MultilineLabel {
    private static Logger logger = Logger.getLogger(StaticItemLabel.class);
    private ItemAndItemListInfo itemAndItemListInfo;
    private Color selectedColor = ColorsOptions.CALENDAR_ITEM_SELECTED_COLOR;
    private Color unselectedColor = ColorsOptions.CALENDAR_ITEM_UNSELECTED_BACKGROUND;
    private boolean checkAlignIcons;
    private boolean selected;

    public StaticItemLabel(boolean isMultiLine, ItemAndItemListInfo itemAndItemListInfo, Color backColor, boolean doCheckAlignIcons) {
        this.itemAndItemListInfo = itemAndItemListInfo;
        this.isMultiLine = isMultiLine;
        this.checkAlignIcons = doCheckAlignIcons;
        this.unselectedColor = backColor;
        this.setBackground(this.unselectedColor);
        AbstractItem item = this.getItem();
        if (item instanceof AppointmentItem) {
            String place = ((AppointmentItem)item).getPlace();
            if (place.length() != 0) {
                place = " (" + place + ')';
            }
            if (item.getNativeItem().getSendOptionConcealSubject()) {
                this.setText(place);
            } else {
                this.setText(item.getSubject() + place);
            }
        } else {
            this.setText(item.getSubject());
        }
        this.init();
    }

    public String getName() {
        AbstractItem item = this.getItem();
        return this.getClass().getName() + '@' + (item == null ? "null" : item.getSubject());
    }

    protected int getStatusIconWidth() {
        if (StaticItemLabel.alignIcons()) {
            return CalendarConstants.ICON_PLACE_WIDTH;
        }
        return super.getStatusIconWidth();
    }

    protected void init() {
        this.setFont();
        this.doSetForegroundColor();
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        AbstractItem item = this.getItem();
        if (!item.isPersonal()) {
            icons.add(ImageResources.ICON_GROUP_APPOINTMENT);
        }
        if (item.isPrivate()) {
            icons.add(ImageResources.ICON_CALENDAR_PRIVATE);
        }
        if (item instanceof AppointmentItem && ((AppointmentItem)item).isAlarmSet()) {
            icons.add(ImageResources.ICON_STATUS_ALARM);
        }
        this.setStatusIcon(icons);
        this.setToolTipText("");
    }

    protected void setFont() {
        AbstractItem item = this.getItem();
        Font font = "Appointment".equals(item.getType()) || "Note".equals(item.getType()) || "Task".equals(item.getType()) ? (((AbstractCalendarItem)item).isAccepted() ? FontOptions.getFontFor(100) : (item.isStatusRead() ? FontOptions.getFontFor(170) : FontOptions.getFontFor(180))) : (item.isStatusRead() ? FontOptions.getFontFor(100) : FontOptions.getFontFor(110));
        this.setFont(font);
    }

    private void doSetForegroundColor() {
        if (this.getItem().isProcessing()) {
            this.setForeground(Color.GRAY);
            return;
        }
        this.setForegroundColor();
    }

    protected void setForegroundColor() {
    }

    public void setToolTipText(String text) {
        GWToolTipManager.setToolTipText(this, text);
    }

    public AbstractItem getItem() {
        return this.itemAndItemListInfo == null ? null : this.itemAndItemListInfo.getItem();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof StaticItemLabel) {
            StaticItemLabel label = (StaticItemLabel)obj;
            return this.getItem().equals(label.getItem());
        }
        return false;
    }

    public IItemList getItemList() {
        return this.itemAndItemListInfo.getItemList();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean isSelected) {
        if (!this.selected == isSelected) {
            this.selected = isSelected;
            this.repaint();
        }
    }

    protected void paintSelection(Graphics g) {
        Color c = g.getColor();
        boolean selected = this.selected;
        if (selected) {
            g.setColor(this.selectedColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        if (StaticItemLabel.alignIcons()) {
            if (!selected) {
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(0, 0, this.getWidth() - 1, 0);
                g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
            g.setColor(new Color(246, 238, 238));
            g.fillRect(this.getSelectionX(1), 1, this.getStatusIconWidth() + 1, this.getHeight() - 2);
            g.setColor(Color.LIGHT_GRAY);
            int x = this.getSelectionX(this.getStatusIconWidth() + 2);
            g.drawLine(x, 1, x, this.getHeight() - 2);
        }
        g.setColor(c);
    }

    boolean isCheckAlighIcons() {
        return this.checkAlignIcons;
    }

    protected static boolean alignIcons() {
        return false;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    public Color getUnselectedColor() {
        return this.unselectedColor;
    }

    public void setUnselectedColor(Color unselectedColor) {
        this.unselectedColor = unselectedColor;
    }
}

