/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar;

import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggleChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.ViewsToggleEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ViewsToggle {
    public static final int DAILY = 0;
    public static final int WEEKLY = 1;
    public static final int MONTHLY = 2;
    public static final int YEARLY = 3;
    private static Logger logger = Logger.getLogger(ViewsToggle.class);
    private CalendarViewType type;
    private ArrayList changelisteners = new ArrayList();
    private IViewDisplaySettings displaySettings;

    public ViewsToggle(CalendarViewType calendarCalendarViewType) {
        this.type = calendarCalendarViewType;
    }

    public ViewsToggle(IViewDisplaySettings theDisplaySettings) {
        this.displaySettings = theDisplaySettings;
        this.load();
    }

    private void load() {
        if (this.displaySettings != null) {
            this.type = GWCalendarUtils.getViewFromSettings(this.displaySettings);
        } else {
            logger.debug((Object)"Null displaySettings!!!");
        }
        if (this.type == null) {
            this.type = CalendarViewType.DAILY;
        }
    }

    public CalendarViewType getType() {
        return this.type;
    }

    public int getSelectedIndex() {
        if (this.displaySettings != null) {
            return this.displaySettings.getCalViewType().getValue();
        }
        logger.debug((Object)"No display Settings!");
        return this.getType().getValue();
    }

    public void setDisplaySettings(IViewDisplaySettings ds) {
        this.displaySettings = ds;
        CalendarViewType theType = ds.getCalViewType();
        this.fireToggleChanged(new ViewsToggleEvent(this.type, theType));
        this.type = theType;
    }

    public void setType(PropertiesViewListItem item) {
        CalendarViewType theType = item.getView();
        this.fireToggleChanged(new ViewsToggleEvent(this.type, theType));
        this.type = theType;
        if (this.displaySettings != null) {
            this.displaySettings.setCalViewType(CalendarViewType.getEnum(GWCalendarUtils.getCalendarPropertiesViewList().getItemIndex(item)));
            logger.debug((Object)("set view <" + item + "> to displaySettings"));
        } else {
            logger.debug((Object)"Null displaySettings!!!");
        }
    }

    public void addChangeListener(ViewsToggleChangeListener theListener) {
        this.changelisteners.add(theListener);
    }

    public void removeChangeListener(ViewsToggleChangeListener theListener) {
        this.changelisteners.remove(theListener);
    }

    protected void fireToggleChanged(ViewsToggleEvent theEvent) {
        int nSize = this.changelisteners.size();
        for (int i = 0; i < nSize; ++i) {
            ViewsToggleChangeListener listener = (ViewsToggleChangeListener)this.changelisteners.get(i);
            listener.changed(theEvent);
        }
    }

    public void firePropertiesListChanged(PropertiesViewList propertiesViewList) {
        if (this.displaySettings == null) {
            logger.debug((Object)"Null display settings!!!");
            return;
        }
        CalendarViewType view = this.displaySettings.getCalViewType();
        if (view != null) {
            PropertiesViewListItem item = GWCalendarUtils.getCalendarPropertiesViewList().getListItem(view.getValue());
            this.displaySettings.setCalViewType(CalendarViewType.getEnum(propertiesViewList.getItemIndex(item)));
        } else {
            this.displaySettings.setCalViewType(CalendarViewType.DAILY);
        }
    }
}

