/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.api.enums.CalendarViewType;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.GWSplitPane;
import com.novell.gw.jclient.application.controls.IItemListComponentDataModel;
import com.novell.gw.jclient.application.controls.gwcalendar.ActiveTypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.AllDayEventsBoxesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarRefreshEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarScrollPane;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarStateEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.CalendarView;
import com.novell.gw.jclient.application.controls.gwcalendar.DatePanel;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GradientBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.LabelFocusListener;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigateCreateItem;
import com.novell.gw.jclient.application.controls.gwcalendar.NavigationCreateItemKeyboardListener;
import com.novell.gw.jclient.application.controls.gwcalendar.TypesToggle;
import com.novell.gw.jclient.application.controls.gwcalendar.daily.dailyview.DailyViewController;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ActiveHourLabelsPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.AppointmentPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.weekly.weeklyview.CalendarBoxesPanel;
import com.novell.gw.jclient.application.controls.gwcalendar.yearlycalendar.YearlyCalendar;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.DividerPositionListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;

public class DailyView
extends CalendarView
implements NavigateCreateItem {
    private JSplitPane spltTaskNotes;
    private JSplitPane spltAppointments;
    private JSplitPane spltAllDayEvents;
    private AppointmentPanel pnlAppointment;
    private AppointmentsClockPanel appointmentClockPanel;
    private JComponent compNotes;
    private JComponent compTasks;
    private JComponent compAllDayEvents;
    private CalendarBoxesPanel tasksBoxesPanel;
    private CalendarBoxesPanel notesBoxesPanel;
    private AllDayEventsBoxesPanel allDayEventsBoxesPanel;
    private boolean isVertSplitVisible;
    private JComponent compAppointments;
    private ArrayList<Integer> workDays;
    private JPanel focusedPanel = null;
    private AbstractItem itemSel;
    private DatePanel datePanel;
    private int itemsCount = 0;
    private JPanel pnlMonthPicker;
    private TimeInterval refreshedInterval = new TimeInterval(-1L, -1L);

    public DailyView(Calendar theCurrentDay, TypesToggle theToggle, MVCController theParentController, boolean showMiniMonth, IItemListComponentDataModel calendarItemListData) {
        super(theCurrentDay, theToggle, theParentController, showMiniMonth, calendarItemListData);
        this.buildUI();
        super.change(new CalendarStateEvent(true, CalendarViewType.DAILY));
        this.setSelectedTime();
    }

    protected MVCController createController(MVCController theParentController) {
        return new DailyViewController(this, theParentController);
    }

    public boolean isAutosizeAllowed() {
        return ApplicationOptions.getInstance().getBoolean("AUTOSIZE_ALLOWED", true);
    }

    protected void buildUI() {
        this.setWorkDay();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setFocusable(false);
        this.buildNotesPanel();
        this.buildTasksPanel();
        this.buildAllDayPanel();
        this.buildAppointmentsPanel();
        this.spltTaskNotes = new GWSplitPane(0, this.compNotes, this.compTasks);
        this.spltTaskNotes.setOneTouchExpandable(false);
        this.spltTaskNotes.setOpaque(false);
        this.spltTaskNotes.setResizeWeight(0.5);
        this.spltTaskNotes.setBorder(BorderFactory.createEmptyBorder());
        this.spltTaskNotes.addPropertyChangeListener(new DividerPositionListener("CALENDAR_DAILY_TASKNOTES_SPLITPOS" + this.optionFrameName, this.spltTaskNotes));
        this.createAppointmentsSplit();
        this.buildYearlyCalendarComponent();
        this.datePanel = new DatePanel(GWCalendarUtils.convertDayToCalendar(this.currentDate));
        this.add((Component)this.spltAppointments, "Center");
        SkinnablePanel panel = new SkinnablePanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        panel.add((Component)this.datePanel, "First");
        panel.add((Component)this.yearlyCalendarComponent, "Center");
        this.datePanel.setOpaque(false);
        this.pnlMonthPicker = panel;
        this.add((Component)this.pnlMonthPicker, "Before");
        this.pnlMonthPicker.setVisible(this.showYearlyCalendar);
        this.updateComponentOpaque(0);
        Rectangle rec = AppointmentPanel.getWorkTimeRectangle();
        this.appointmentClockPanel.scrollRectToVisible(rec);
        this.adjustView();
    }

    protected void buildYearlyCalendarComponent() {
        this.yearlyCalendarComponent = new YearlyCalendar(this.currentDate, false, this.getController(), this.getItemList());
        this.yearlyCalendarComponent.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(2, 2, 2, 2), new GradientBorder(10, 10, 10, 10)));
        Dimension preferredSize = new Dimension(this.yearlyCalendarComponent.getPrefferedWidth() + 24, (int)this.yearlyCalendarComponent.getPreferredSize().getHeight());
        this.yearlyCalendarComponent.setPreferredSize(preferredSize);
        super.buildYearlyCalendarComponent();
    }

    public void setMonthPickerVisibled(boolean b) {
        this.showYearlyCalendar = b;
        this.pnlMonthPicker.setVisible(b);
    }

    private void setWorkDay() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int mask = (Integer)dataStoreSettings.getCalendarWorkDays().getValue();
        this.workDays = new ArrayList();
        int m = 64;
        for (int i = 7; i > 0; --i) {
            if (mask / m == 1) {
                mask -= m;
                this.workDays.add(i);
            }
            m /= 2;
        }
    }

    private void createAppointmentsSplit() {
        this.spltAppointments = new GWSplitPane(1, this.compAppointments, this.spltTaskNotes);
        this.spltAppointments.setOneTouchExpandable(false);
        this.spltAppointments.setOpaque(false);
        this.spltAppointments.setResizeWeight(0.5);
        this.spltAppointments.setBorder(BorderFactory.createEmptyBorder());
        this.spltAppointments.addPropertyChangeListener(new DividerPositionListener("CALENDAR_DAILY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, this.spltAppointments));
    }

    private void buildAppointmentsPanel() {
        this.compAppointments = new OrientablePanel(new BorderLayout());
        this.compAppointments.setOpaque(false);
        this.compAppointments.setMinimumSize(new Dimension(0, 0));
        this.compAppointments.setBorder(null);
        this.compAppointments.setBorder(BorderFactory.createEmptyBorder());
        HeaderLabel lbl = new HeaderLabel(' ' + StringResources.APPOINTMENTS_C);
        lbl.setBorder(BorderFactory.createEmptyBorder());
        this.compAppointments.add((Component)lbl, "North");
        lbl.setOpaque(false);
        this.appointmentClockPanel = new AppointmentsClockPanel();
        this.appointmentClockPanel.setBorder(BorderFactory.createEmptyBorder());
        this.appointmentClockPanel.addFocusListener(new LabelFocusListener(lbl));
        this.appointmentClockPanel.setEnabled(this.checkAppointmentAccess());
        CalendarScrollPane sp = new CalendarScrollPane(this.appointmentClockPanel);
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        OrientablePanel allDayEventsAndAppointments = new OrientablePanel(new BorderLayout());
        allDayEventsAndAppointments.setBorder(BorderFactory.createEmptyBorder());
        this.buildADEPanel(allDayEventsAndAppointments, sp);
        this.compAppointments.add((Component)allDayEventsAndAppointments, "Center");
    }

    private void buildADEPanel(JPanel thePanel, JScrollPane theScrollPane) {
        if (this.isAutosizeAllowed()) {
            thePanel.add((Component)this.compAllDayEvents, "North");
            thePanel.add((Component)theScrollPane, "Center");
        } else {
            this.spltAllDayEvents = new GWSplitPane(0, this.compAllDayEvents, theScrollPane);
            this.spltAllDayEvents.setOneTouchExpandable(false);
            this.spltAllDayEvents.setOpaque(false);
            this.spltAllDayEvents.setBorder(BorderFactory.createEmptyBorder());
            if (this.itemsCount >= 0 && this.itemsCount < 4) {
                this.spltAllDayEvents.setDividerLocation(60);
            } else if (this.itemsCount >= 4 && this.itemsCount <= 10) {
                this.spltAllDayEvents.setDividerLocation(20 * this.itemsCount);
            } else {
                this.spltAllDayEvents.setDividerLocation(190);
            }
            this.spltAllDayEvents.addPropertyChangeListener(new DividerPositionListener("CALENDAR_DAILY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, this.spltAllDayEvents));
            thePanel.add((Component)this.spltAllDayEvents, "Center");
        }
    }

    private void buildNotesPanel() {
        this.compNotes = new OrientablePanel(new BorderLayout());
        this.compNotes.setOpaque(false);
        this.compNotes.setMinimumSize(new Dimension(0, 0));
        this.compNotes.setBorder(BorderFactory.createEmptyBorder());
        HeaderLabel lbl = new HeaderLabel(' ' + StringResources.REMINDER_NOTES_C);
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.compNotes.add((Component)lbl, "North");
        lbl.setOpaque(false);
        this.notesBoxesPanel = new CalendarBoxesPanel(this.getController(), "Note", 1, false);
        this.notesBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.notesBoxesPanel.addFocusListener(new LabelFocusListener(lbl));
        this.notesBoxesPanel.setEnabled(this.checkNoteAccess());
        CalendarScrollPane sp = new CalendarScrollPane(this.notesBoxesPanel);
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        this.compNotes.add((Component)sp, "Center");
    }

    private void buildTasksPanel() {
        this.compTasks = new OrientablePanel(new BorderLayout());
        this.compTasks.setOpaque(false);
        this.compTasks.setMinimumSize(new Dimension(0, 0));
        this.compTasks.setBorder(BorderFactory.createEmptyBorder());
        HeaderLabel lbl = new HeaderLabel(' ' + StringResources.TASKS_C);
        lbl.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorConstants.HEADER_BORDER_COLOR));
        this.compTasks.add((Component)lbl, "North");
        lbl.setOpaque(false);
        this.tasksBoxesPanel = new CalendarBoxesPanel(this.getController(), "Task", 1, false);
        this.tasksBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.tasksBoxesPanel.addFocusListener(new LabelFocusListener(lbl));
        this.tasksBoxesPanel.setEnabled(this.checkTaskAccess());
        CalendarScrollPane sp = new CalendarScrollPane(this.tasksBoxesPanel);
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.setOpaque(false);
        sp.getViewport().setOpaque(false);
        this.compTasks.add((Component)sp, "Center");
    }

    private void buildAllDayPanel() {
        this.allDayEventsBoxesPanel = new AllDayEventsBoxesPanel(this.getController(), 1, false);
        this.allDayEventsBoxesPanel.setBorder(BorderFactory.createEmptyBorder());
        this.allDayEventsBoxesPanel.setEnabled(this.checkAppointmentAccess());
        this.compAllDayEvents = CalendarUtils.createLeftCaptionAndScrollPane(this.allDayEventsBoxesPanel, ImageResources.ITM_ALL_DAY_EVENT_LARGE, BorderFactory.createMatteBorder(0, 1, 0, 1, ColorConstants.HEADER_BORDER_COLOR), this.controller, "AllDayEvent", true);
        this.compAllDayEvents.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, ColorConstants.HEADER_BORDER_COLOR));
        this.compAllDayEvents.setPreferredSize(new Dimension(0, 60));
    }

    protected CalendarViewType getViewType() {
        return CalendarViewType.DAILY;
    }

    protected void prepareRefresh(boolean folderWasChanged) {
        this.refreshedInterval = GWCalendarUtils.getDayTimeInterval(GWCalendarUtils.convertDayToCalendar(this.currentDate).getTime());
        this.calendarAdjusting = true;
        this.yearlyCalendarComponent.setCurrentDate(this.currentDate);
        if (folderWasChanged && this.yearlyCalendarComponent != null) {
            this.yearlyCalendarComponent.setDirty();
            this.yearlyCalendarComponent.validateBusyDays(this.getItemList());
        }
        this.calendarAdjusting = false;
    }

    protected void refreshTasks(IItemList theItemList, TimeInterval theChangedInterval) {
        AbstractItem item = null;
        if (this.itemSel instanceof TaskItem) {
            item = this.itemSel;
        }
        this.tasksBoxesPanel.setItemSel(item);
        this.tasksBoxesPanel.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.currentDate), theItemList, theChangedInterval);
    }

    protected void refreshNotes(IItemList theItemList, TimeInterval theChangedInterval) {
        AbstractItem item = null;
        if (this.itemSel instanceof ReminderNote) {
            item = this.itemSel;
        }
        if (this.itemSel == null) {
            GWCalendarController gwCalendarController = ControlsUtils.getParentGWCalendarController(this.getController());
            assert (gwCalendarController != null);
            gwCalendarController.itemSelected(null);
        }
        this.notesBoxesPanel.setItemSel(item);
        this.notesBoxesPanel.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.currentDate), theItemList, theChangedInterval);
    }

    protected void refreshAppointments(IItemList theItemList, TimeInterval theChangedInterval) {
        if (theChangedInterval == null || theChangedInterval.contains(GWCalendarUtils.convertDayToCalendar(this.currentDate))) {
            AbstractItem item = null;
            if (this.itemSel instanceof AppointmentItem) {
                item = this.itemSel;
            }
            this.pnlAppointment.setItemSel(item);
            this.pnlAppointment.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.currentDate), theItemList);
            this.pnlAppointment.setWorkDay(this.workDays.contains(GWCalendarUtils.convertDayToCalendar(this.currentDate).get(7)));
        }
    }

    protected void refreshAllDayEvents(IItemList theItemList, TimeInterval theChangedInterval) {
        AbstractItem item = null;
        if (this.allDayEventsBoxesPanel.equals(this.focusedPanel) && this.itemSel instanceof AppointmentItem) {
            item = this.itemSel;
        }
        this.allDayEventsBoxesPanel.setItemSel(item);
        this.allDayEventsBoxesPanel.loadItemsForDate(GWCalendarUtils.convertDayToCalendar(this.currentDate), theItemList);
        this.itemsCount = this.allDayEventsBoxesPanel.getCountOfItemsForCurrentDate(GWCalendarUtils.convertDayToCalendar(this.currentDate), theItemList);
        int height = this.itemsCount >= 0 && this.itemsCount < 4 ? 60 : (this.itemsCount >= 4 && this.itemsCount <= 10 ? 20 * this.itemsCount : 190);
        this.compAllDayEvents.setPreferredSize(new Dimension(0, height));
    }

    protected void setDirty() {
        this.yearlyCalendarComponent.setDirty();
    }

    public JPanel getFocusedPanel() {
        return this.focusedPanel;
    }

    public void setFocusedPanel(JPanel focusedPanel) {
        this.focusedPanel = focusedPanel;
    }

    public void setItemSel(AbstractItem itemSel) {
        this.itemSel = itemSel;
    }

    public void folderChanged() {
        this.yearlyCalendarComponent.setItemList(this.calendarItemListData.getItemList());
    }

    public HashMap getAppointmentHashMap() {
        return this.pnlAppointment.getAppointmentHashMap(this.getItemList());
    }

    public int getAppointmentsColumns() {
        return this.pnlAppointment.getAppointmentsColumns();
    }

    private void adjustView() {
        if (!this.typesToggle.isShowAppointments()) {
            this.spltAppointments.remove(this.compAppointments);
        }
        if (!this.typesToggle.isShowNotes()) {
            this.spltTaskNotes.remove(this.compNotes);
        }
        if (!this.typesToggle.isShowTasks()) {
            this.spltTaskNotes.remove(this.compTasks);
        }
        if (!this.typesToggle.isShowNotes() && !this.typesToggle.isShowTasks()) {
            this.spltAppointments.remove(this.spltTaskNotes);
            this.isVertSplitVisible = false;
        } else {
            this.isVertSplitVisible = true;
        }
        this.adjustSplitters();
    }

    private void adjustSplitters() {
        int pos = ApplicationOptions.getInstance().getInteger("CALENDAR_DAILY_APPOINTMENTS_SPLITPOS" + this.optionFrameName, -1);
        this.spltAppointments.setDividerLocation(pos);
        pos = ApplicationOptions.getInstance().getInteger("CALENDAR_DAILY_TASKNOTES_SPLITPOS" + this.optionFrameName, -1);
        this.spltTaskNotes.setDividerLocation(pos);
    }

    protected void adjustTasks() {
        if (this.typesToggle.isShowTasks()) {
            if (!this.isVertSplitVisible) {
                boolean isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
                this.spltAppointments.add((Component)this.spltTaskNotes, isLeftToRight ? "right" : "left");
                this.isVertSplitVisible = true;
            }
            this.spltTaskNotes.add(this.compTasks);
        } else {
            this.spltTaskNotes.remove(this.compTasks);
            if (!this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    protected void adjustNotes() {
        if (this.typesToggle.isShowNotes()) {
            if (!this.isVertSplitVisible) {
                boolean isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
                this.spltAppointments.add((Component)this.spltTaskNotes, isLeftToRight ? "right" : "left");
                this.isVertSplitVisible = true;
            }
            if (this.typesToggle.isShowTasks()) {
                this.spltTaskNotes.remove(this.compTasks);
                this.spltTaskNotes.add(this.compNotes);
                this.spltTaskNotes.add(this.compTasks);
            } else {
                this.spltTaskNotes.add(this.compNotes);
            }
        } else {
            this.spltTaskNotes.remove(this.compNotes);
            if (!this.typesToggle.isShowTasks()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        }
        this.adjustSplitters();
    }

    public void refreshUIOptions() {
        super.refreshUIOptions();
        this.setWorkDay();
        this.yearlyCalendarComponent.refreshUIOptions();
        this.pnlAppointment.refreshUIOptions();
        this.pnlAppointment.setWorkDay(this.workDays.contains(GWCalendarUtils.convertDayToCalendar(this.currentDate).get(7)));
        this.yearlyCalendarComponent.setPreferredSize(new Dimension(this.yearlyCalendarComponent.getPrefferedWidth() + 24, (int)this.yearlyCalendarComponent.getPreferredSize().getHeight()));
    }

    public void refresh(CalendarRefreshEvent theEvent) {
        super.refresh(theEvent);
    }

    protected void adjustAppointments() {
        if (this.typesToggle.isShowAppointments()) {
            boolean isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
            this.spltAppointments.add((Component)this.compAppointments, isLeftToRight ? "left" : "right");
            if (!this.typesToggle.isShowTasks() && !this.typesToggle.isShowNotes()) {
                this.spltAppointments.remove(this.spltTaskNotes);
                this.isVertSplitVisible = false;
            }
        } else {
            this.spltAppointments.remove(this.compAppointments);
        }
        this.adjustSplitters();
    }

    protected void adjustClock() {
        if (this.typesToggle.isShowAppointments()) {
            int y = -1;
            if (GWCalendarUtils.isSameDate(GWCalendarUtils.convertDayToCalendar(this.currentDate), GWCalendarUtils.getToday())) {
                y = GWCalendarUtils.getClockPosition();
            }
            this.pnlAppointment.adjustClock(y);
            this.appointmentClockPanel.adjustClock(y);
        }
    }

    public void setMVCModel(Object model) {
        super.setMVCModel(model);
        if (model instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)model);
            this.datePanel.setCalendar(calendar);
        }
    }

    protected void adjustCurrentDay() {
        if (this.refreshedInterval.contains(GWCalendarUtils.convertDayToCalendar(this.currentDate).getTime())) {
            this.needRefresh(false);
        } else {
            this.needRefresh(true);
            this.refresh(false);
        }
    }

    public void requestFocus() {
        if (this.focusedPanel != null) {
            this.focusedPanel.requestFocus();
        } else {
            this.appointmentClockPanel.requestFocus();
        }
    }

    private void navigate(int field, int shift) {
        this.pnlAppointment.navigate(field, shift);
    }

    public void navigateUP() {
        this.navigate(12, -30);
    }

    public void navigateDOWN() {
        this.navigate(12, 30);
    }

    public void navigateLEFT() {
        this.navigate(5, -1);
    }

    public void navigateRIGHT() {
        this.navigate(5, 1);
    }

    public void createItem() {
        this.pnlAppointment.createItem();
    }

    public void quickCreateItem(char thePressedChar) {
        this.pnlAppointment.handleQuickCreateItem(thePressedChar);
    }

    public void rebuild() {
        Calendar currentTime = this.pnlAppointment.getCurrentDate();
        this.remove(this.spltAppointments);
        this.buildAllDayPanel();
        this.buildAppointmentsPanel();
        this.createAppointmentsSplit();
        this.add((Component)this.spltAppointments, "Center");
        this.updateComponentOpaque(1);
        this.refreshAppointments(this.getItemList(), null);
        this.refreshAllDayEvents(this.getItemList(), null);
        this.refreshTasks(this.getItemList(), null);
        this.refreshNotes(this.getItemList(), null);
        this.adjustView();
        this.validate();
        this.getController().processCommand(new Command(70, currentTime));
    }

    private void updateComponentOpaque(int index) {
        if (this.getComponents().length <= index) {
            return;
        }
        GWSplitPane pane = (GWSplitPane)this.getComponent(index);
        if (this.getComponentOrientation().isLeftToRight()) {
            GWSplitPane rightPane = (GWSplitPane)pane.getRightComponent();
            ((JComponent)((JPanel)pane.getLeftComponent()).getComponent(0)).setOpaque(false);
            if (rightPane.getLeftComponent() != null) {
                ((JComponent)((JPanel)rightPane.getLeftComponent()).getComponent(0)).setOpaque(false);
            }
            if (rightPane.getRightComponent() != null) {
                ((JComponent)((JPanel)rightPane.getRightComponent()).getComponent(0)).setOpaque(false);
            }
        } else {
            GWSplitPane leftPane = (GWSplitPane)pane.getLeftComponent();
            ((JComponent)((JPanel)pane.getRightComponent()).getComponent(0)).setOpaque(false);
            if (leftPane.getLeftComponent() != null) {
                ((JComponent)((JPanel)leftPane.getLeftComponent()).getComponent(0)).setOpaque(false);
            }
            if (leftPane.getRightComponent() != null) {
                ((JComponent)((JPanel)leftPane.getRightComponent()).getComponent(0)).setOpaque(false);
            }
        }
    }

    public String getName() {
        return "CalendarView-Daily";
    }

    public static class HeaderLabel
    extends OrientableLabel {
        public HeaderLabel(String text) {
            super(text);
            this.setOpaque(false);
            this.setPreferredSize(CalendarView.HEADER_LABEL_SIZE);
            this.setMinimumSize(new Dimension(0, 0));
        }
    }

    private class AppointmentsClockPanel
    extends OrientablePanel {
        private JPanel hours;
        private JPanel alternateHours;
        private int clockPosition;

        public AppointmentsClockPanel() {
            super(new BorderLayout());
            this.clockPosition = -1;
            this.buildUI();
        }

        private void buildUI() {
            DailyView.this.pnlAppointment = new AppointmentPanel(DailyView.this.getController(), this);
            this.setFocusable(true);
            this.addKeyListener(new NavigationCreateItemKeyboardListener(DailyView.this));
            JPanel pnlHours = new JPanel(new BorderLayout());
            this.hours = new ActiveHourLabelsPanel(BorderFactory.createLineBorder(ColorConstants.HEADER_BORDER_COLOR, 1), DailyView.this.getController());
            if (ActiveTypesToggle.getInstance() != null && ActiveTypesToggle.getInstance().isShowAlternateTimeZone()) {
                this.alternateHours = new ActiveHourLabelsPanel(BorderFactory.createLineBorder(ColorConstants.HEADER_BORDER_COLOR, 1), DailyView.this.getController(), true);
                pnlHours.add((Component)this.alternateHours, "Before");
            }
            pnlHours.add((Component)this.hours, "After");
            OrientablePanel p1 = new OrientablePanel(new BorderLayout());
            p1.setBorder(BorderFactory.createEmptyBorder());
            p1.add((Component)pnlHours, "Before");
            p1.add((Component)DailyView.this.pnlAppointment, "Center");
            this.add((Component)p1, "First");
        }

        public void adjustClock(int clockPosition) {
            this.clockPosition = clockPosition;
            this.repaint();
        }

        public void paint(Graphics g) {
            g = UIUtils.enableAntialiasing(g);
            super.paint(g);
            if (this.clockPosition >= 0) {
                int x = this.hours.getWidth() - ImageResources.CLOCK_SMALL.getImage().getWidth(this) / 2;
                int y = this.clockPosition - ImageResources.CLOCK_SMALL.getImage().getHeight(this) / 2;
                if (this.alternateHours != null) {
                    x += this.alternateHours.getWidth();
                }
                g.drawImage(ImageResources.CLOCK_SMALL.getImage(), x, y, null);
            }
        }
    }
}

