/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.dailycalendar;

import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.gwcalendar.DayBorder;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes.ColorConstants;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.fonts.FontOptions;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class DailyCalendar
extends OrientablePanel
implements MouseListener {
    private static Logger logger = Logger.getLogger(DailyCalendar.class);
    protected Calendar gcSelectedDay = GWCalendarUtils.getTodayWithoutTimeFraction();
    protected Calendar gcCurrDay = GWCalendarUtils.getTodayWithoutTimeFraction();
    protected Dimension dimMinMonthSize = new Dimension(164, 18);
    protected JLabel lblHeader = new OrientableLabel();
    protected DayBorder todayBorderSelected = new DayBorder(DayBorder.BORDER_TODAY_SELECTED);
    protected DayBorder todayBorderUnselected = new DayBorder(DayBorder.BORDER_TODAY_UNSELECTED);
    protected DayBorder dayBorderSelected = new DayBorder(DayBorder.BORDER_DAY_SELECTED);
    protected JPanel pnlHeader;
    protected static final int CAL_SIZE = 42;
    protected Font fntDates = FontOptions.getFontFor(140);
    protected Font fntDays = FontOptions.getFontFor(150);
    protected int iHgap = 1;
    protected int iVgap = 1;
    protected JLabel[] lblDays = new JLabel[7];
    protected JLabel[] btnDates = new JLabel[42];
    protected Dimension dimMinDaysButtSize = new Dimension(24, 16);
    protected Calendar[] days = new Calendar[42];
    protected boolean isSelectedRectangleShowing = true;

    public DailyCalendar() {
        this.init();
        this.buildUI();
        this.refreshView();
    }

    protected void init() {
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.add((Component)this.buildHeader(), "North");
        this.add((Component)this.buildDaysDatesPanel(), "Center");
    }

    protected JPanel buildHeader() {
        this.pnlHeader = new OrientablePanel(new BorderLayout());
        this.pnlHeader.setBackground(Color.blue);
        this.lblHeader.setHorizontalAlignment(0);
        this.lblHeader.setForeground(Color.white);
        Font font = new Font(this.lblHeader.getFont().getName(), 1, this.lblHeader.getFont().getSize());
        this.lblHeader.setFont(font);
        this.pnlHeader.add(this.lblHeader);
        return this.pnlHeader;
    }

    protected JPanel buildDaysDatesPanel() {
        int i;
        OrientablePanel pnlDatesDays = new OrientablePanel();
        pnlDatesDays.setBackground(Color.white);
        pnlDatesDays.setLayout(new GridLayout(7, 7, this.iHgap, this.iVgap));
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        int x = (Integer)dataStoreSettings.getMonthCalendarFirstDay().getValue();
        for (i = 0; i < 7; ++i) {
            if (x >= 7) {
                x %= 7;
            }
            this.lblDays[i] = new OrientableLabel(GWCalendarUtils.dayShortestNames[x], 0);
            this.lblDays[i].setFont(this.fntDays);
            this.lblDays[i].setForeground(ColorConstants.clrDaysWork);
            if (x == 0 || x == 6) {
                this.lblDays[i].setForeground(ColorConstants.clrDaysHoly);
            }
            pnlDatesDays.add(this.lblDays[i]);
            ++x;
        }
        for (i = 0; i < 42; ++i) {
            this.btnDates[i] = new DailyLabel(i);
            this.btnDates[i].addMouseListener(this);
            this.btnDates[i].setHorizontalAlignment(0);
            this.btnDates[i].setVerticalAlignment(0);
            this.btnDates[i].setBackground(Color.white);
            this.btnDates[i].setForeground(Color.white);
            this.btnDates[i].setBorder(BorderFactory.createEmptyBorder());
            pnlDatesDays.add(this.btnDates[i]);
        }
        return pnlDatesDays;
    }

    public void refreshView() {
        Calendar gcDay = GWCalendarUtils.initCalendar(this.gcCurrDay);
        for (int i = 0; i < 42; ++i) {
            gcDay.add(5, 1);
            this.days[i] = (Calendar)gcDay.clone();
            if (gcDay.get(2) != this.gcCurrDay.get(2)) {
                this.days[i] = null;
                this.refreshDateLabelView(i);
                continue;
            }
            this.setWeekEndColor(gcDay, i);
            this.refreshDateLabelView(i);
            if (this.isSelectedRectangleShowing) {
                this.setSelectedDayBorder(gcDay, i);
            }
            this.setTodayColor(gcDay, i);
        }
        this.setHeaderTitle();
        this.setHeaderColor();
        this.validate();
    }

    protected void refreshDateLabelView(int i) {
        String title = "";
        if (this.days[i] != null) {
            title = String.valueOf(this.days[i].get(5));
        }
        this.btnDates[i].setText(title);
        this.btnDates[i].setEnabled(this.days[i] != null);
        this.btnDates[i].setBorder(BorderFactory.createEmptyBorder());
    }

    private void setSelectedDayBorder(Calendar theCalendar, int i) {
        if (GWCalendarUtils.isSameDate(theCalendar.getTime(), this.gcSelectedDay.getTime())) {
            this.btnDates[i].setBorder(this.dayBorderSelected);
        } else {
            this.btnDates[i].setBorder(BorderFactory.createEmptyBorder());
        }
    }

    protected void setTodayColor(Calendar theCalendar, int i) {
        Date sToday = GWCalendarUtils.getToday().getTime();
        Date sDay = theCalendar.getTime();
        Date sSelectedDay = this.gcSelectedDay.getTime();
        if (GWCalendarUtils.isSameDate(sDay, sToday)) {
            if (GWCalendarUtils.isSameDate(sDay, sSelectedDay)) {
                this.btnDates[i].setBorder(this.todayBorderSelected);
            } else {
                this.btnDates[i].setBorder(this.todayBorderUnselected);
            }
        }
    }

    protected void setWeekEndColor(Calendar theCalendar, int i) {
        if (theCalendar.get(7) == 1 || theCalendar.get(7) == 7) {
            this.btnDates[i].setForeground(ColorConstants.clrDaysHoly);
        } else {
            this.btnDates[i].setForeground(ColorConstants.clrDaysWork);
        }
    }

    private void setHeaderTitle() {
        this.lblHeader.setText(GWCalendarUtils.monthNames[this.gcCurrDay.get(2)] + ' ' + this.gcCurrDay.get(1));
    }

    protected void setHeaderColor() {
        if (this.gcSelectedDay.get(2) == this.gcCurrDay.get(2) && this.gcSelectedDay.get(1) == this.gcCurrDay.get(1)) {
            this.pnlHeader.setBackground(Color.blue);
        } else {
            this.pnlHeader.setBackground(Color.gray);
        }
    }

    public static Calendar getToday() {
        return GWCalendarUtils.getToday();
    }

    public void goToToday() {
        this.gcSelectedDay = GWCalendarUtils.getTodayWithoutTimeFraction();
        this.gcCurrDay = GWCalendarUtils.getTodayWithoutTimeFraction();
        this.refreshView();
    }

    public void changeDate(Date theDate) {
        Calendar date = GWCalendarUtils.getToday();
        date.setTime(theDate);
        this.setSelectedDay(date);
    }

    public void setCurrDay(Calendar theCurrDay) {
        this.gcCurrDay = (Calendar)theCurrDay.clone();
        this.refreshView();
    }

    public Calendar getCurrentDate() {
        return this.gcCurrDay;
    }

    public void setSelectedDay(Calendar theSelectedDay) {
        this.gcSelectedDay = (Calendar)theSelectedDay.clone();
        this.refreshView();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    protected static class DailyLabel
    extends OrientableLabel {
        int index;

        public DailyLabel(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

