/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.itemsboxes;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.MultilineLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MultiLineLabelBox
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(MultiLineLabelBox.class);
    protected static final int GAP = 0;
    private static final int BOTTOM_EMPTY_SPACE = 0;
    protected int minimumWidth = 10;
    protected int minimumHeight = 10;
    protected int titleHeight = 20;
    private String title = "";
    protected boolean isLTR = UIUtils.getComponentOrientation().isLeftToRight();

    public MultiLineLabelBox() {
        this.setLayout(null);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.minimumWidth = minimumSize.width;
        this.minimumHeight = minimumSize.height;
        super.setMinimumSize(minimumSize);
    }

    public Component add(Component comp) {
        if (!(comp instanceof JComponent)) {
            throw new IllegalArgumentException("Only JComponents can be added to this container");
        }
        return super.add(comp);
    }

    public Dimension getPreferredSize() {
        int height = 0;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            int h = this.getComponent((int)i).getPreferredSize().height;
            height += h;
        }
        int h = 0;
        if (this.getBorder() != null) {
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            h = borderInsets.top + borderInsets.bottom;
        }
        if ((height += 0 * n + h) < this.minimumHeight) {
            height = this.minimumHeight;
        }
        if (this.title != null && this.title.length() != 0) {
            height += this.titleHeight;
        }
        return new Dimension(this.minimumWidth, height += 0);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    public void paint(Graphics g) {
        g = UIUtils.enableAntialiasing(g);
        super.paint(g);
        if (this.title != null && this.title.length() != 0) {
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            Insets insets = new Insets(0, 0, 0, 0);
            if (this.getBorder() != null) {
                insets = this.getBorder().getBorderInsets(this);
            }
            int x = insets.left;
            if (!this.isLTR) {
                int width = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.title);
                x = this.getWidth() - width - insets.left;
            }
            g.drawString(this.title, x, g.getFontMetrics().getHeight());
        }
    }

    public void doLayout() {
        if (this.getLayout() != null) {
            super.doLayout();
            return;
        }
        int width = this.getWidth();
        if (width <= 0) {
            return;
        }
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.getBorder() != null) {
            insets = this.getBorder().getBorderInsets(this);
        }
        int y = insets.top;
        if (this.title != null && this.title.length() != 0) {
            y += this.titleHeight;
        }
        Component comp = null;
        int nCount = this.getComponentCount();
        for (int i = 0; i < nCount; ++i) {
            comp = this.getComponent(i);
            if (comp instanceof MultilineLabel) {
                MultilineLabel label = (MultilineLabel)comp;
                int prefferedWidth = width - insets.left - insets.right;
                int preferredHeight = label.getPreferredHeight(prefferedWidth);
                label.setBounds(insets.left, y, prefferedWidth, preferredHeight);
                y += preferredHeight;
            } else {
                JComponent jcomp = (JComponent)comp;
                Dimension dim = jcomp.getPreferredSize();
                jcomp.setBounds(insets.left, y, dim.width - insets.left - insets.right, dim.height);
                y += dim.height;
            }
            y += 0;
        }
    }
}

