/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.DateAndTimeFormattingUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarComponent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModel;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.CalendarModelListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class MonthlyCalendar
extends JComponent
implements CalendarModelListener {
    public static final Color ACTIVE_HEADER_COLOR = Color.BLUE;
    public static final Color INACTIVE_HEADER_COLOR = Color.GRAY;
    public static final Color FOOTER_COLOR = Color.WHITE;
    public final Border inactiveBorder = new LineBorder(Color.GRAY, 1);
    public final Border activeBorder = new LineBorder(Color.BLACK, 1);
    protected CalendarComponent calendar;
    private Border currentBorder = this.inactiveBorder;
    private JLabel headerLabel;
    private JPanel header;
    protected JLabel footerLabel;
    protected JPanel footer;
    private ArrayList<DateValueChangeListener> listeners;
    private boolean allowNavigation;
    private Dimension size;

    private MonthlyCalendar(CalendarModel theCalendarModel, boolean canNavigate, boolean isFooterPresent) {
        if (theCalendarModel == null) {
            throw new IllegalArgumentException("Calendar data model can not be null");
        }
        this.setLayout(new BorderLayout());
        this.listeners = new ArrayList();
        this.allowNavigation = canNavigate;
        theCalendarModel.addModelListener(this);
        this.createCalendar(theCalendarModel);
        this.add((Component)this.calendar, "Center");
        this.initHeader();
        this.add((Component)this.header, "North");
        if (this.allowNavigation && isFooterPresent) {
            this.initFooter();
            this.add((Component)this.footer, "South");
        }
        CalendarMouseListener mouseListener = new CalendarMouseListener();
        this.addMouseListener(mouseListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        FocuseListener focuseListener = new FocuseListener();
        this.addFocusListener(focuseListener);
        this.setFocusable(true);
        this.setBorder(this.currentBorder);
    }

    protected MonthlyCalendar(CalendarModel theCalendarModel, boolean canNavigate) {
        this(theCalendarModel, canNavigate, true);
    }

    public MonthlyCalendar(Calendar theDate, boolean canNavigate, boolean showFooter) {
        this(new CalendarModel(theDate), canNavigate, showFooter);
    }

    protected void createCalendar(CalendarModel theCalendarModel) {
        this.calendar = new CalendarComponent(theCalendarModel);
    }

    public CalendarComponent getCalendarComponent() {
        return this.calendar;
    }

    private void initSize() {
        Insets insets = this.currentBorder.getBorderInsets(this);
        Dimension prefSize = this.calendar.getPreferredSize();
        int w = prefSize.width + insets.left + insets.right;
        int h = prefSize.height + this.header.getPreferredSize().height + insets.top + insets.bottom;
        if (Arrays.asList(this.getComponents()).contains(this.footer)) {
            h += this.footer.getPreferredSize().height;
        }
        this.size = new Dimension(w, h);
    }

    protected void initFooter() {
        this.footer = new OrientablePanel(new BorderLayout());
        this.footer.setOpaque(true);
        this.footer.setBackground(FOOTER_COLOR);
        this.footerLabel = new OrientableLabel();
        this.footerLabel.setHorizontalAlignment(0);
        this.footerLabel.setVerticalAlignment(0);
        this.footerLabel.addMouseListener(new TodayMouserListener());
        Font oldFont = this.footerLabel.getFont();
        Font font = new Font(oldFont.getName(), 0, oldFont.getSize());
        this.footerLabel.setFont(font);
        this.footerLabel.setIconTextGap(4);
        this.footerLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.footerLabel.setIcon(ImageResources.ACT_GOTO_TODAY);
        this.updateTodayField();
        this.footer.add((Component)this.footerLabel, "Center");
    }

    private void initHeader() {
        this.header = new OrientablePanel(new BorderLayout());
        this.header.setOpaque(true);
        this.header.setBackground(INACTIVE_HEADER_COLOR);
        this.headerLabel = new OrientableLabel();
        this.headerLabel.setForeground(Color.WHITE);
        this.headerLabel.setHorizontalAlignment(0);
        this.headerLabel.setVerticalAlignment(0);
        Font oldFont = this.headerLabel.getFont();
        Font font = new Font(oldFont.getName(), 1, oldFont.getSize());
        this.headerLabel.setFont(font);
        this.header.add((Component)this.headerLabel, "Center");
        this.updateHeaderLabel();
        if (this.allowNavigation) {
            this.initNavigationButtons();
        }
    }

    private void initNavigationButtons() {
        this.header.add((Component)this.getLessMoreButtons(1), "Before");
        this.header.add((Component)this.getLessMoreButtons(2), "After");
    }

    private JComponent getLessMoreButtons(int step) {
        OrientablePanel result = new OrientablePanel(new BorderLayout(1, 1));
        result.setBorder(null);
        result.setOpaque(false);
        ImageIcon icon = UIUtils.getComponentOrientation().isLeftToRight() ? ImageResources.ACT_LESS_WHITE : ImageResources.ACT_MORE_WHITE;
        NavigationButton btn = new NavigationButton((Icon)icon);
        btn.setPreferredSize(new Dimension(icon.getIconWidth(), btn.getPreferredSize().height));
        btn.addActionListener(new NavigationAction(-step));
        result.add((Component)btn, "Before");
        icon = UIUtils.getComponentOrientation().isLeftToRight() ? ImageResources.ACT_MORE_WHITE : ImageResources.ACT_LESS_WHITE;
        btn = new NavigationButton((Icon)icon);
        btn.setPreferredSize(new Dimension(icon.getIconWidth(), btn.getPreferredSize().height));
        btn.addActionListener(new NavigationAction(step));
        result.add((Component)btn, "After");
        return result;
    }

    public Dimension getPreferredSize() {
        this.initSize();
        return this.size;
    }

    public void setBorder(Border border) {
        if (this.currentBorder == null) {
            return;
        }
        if (!this.currentBorder.equals(this.getBorder())) {
            this.initSize();
            super.setBorder(this.currentBorder);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, this.size.width, this.size.height);
    }

    protected void handleFocus(boolean gained) {
        this.currentBorder = gained ? this.activeBorder : this.inactiveBorder;
        this.header.setBackground(gained ? ACTIVE_HEADER_COLOR : INACTIVE_HEADER_COLOR);
        this.setBorder(this.currentBorder);
    }

    protected void handleClick(Point thePoint, boolean isShiftDown, boolean isDoubleClick) {
        Point p = SwingUtilities.convertPoint(this, thePoint, this.calendar);
        this.calendar.handleClick(p, isShiftDown);
    }

    public void modelChanged(CalendarEvent e) {
        if (e.isMonthChanged() || e.isYearChanged()) {
            this.calendar.update();
            this.updateHeaderLabel();
        }
        this.calendar.updateSelection();
        this.fireValueChanged(new DateChangeEvent(e.getDate(), this, e.getType()));
    }

    protected void fireValueChanged(DateChangeEvent e) {
        DateValueChangeListener[] arrayOfListeners;
        for (DateValueChangeListener listener : arrayOfListeners = this.listeners.toArray(new DateValueChangeListener[this.listeners.size()])) {
            listener.valueChanged(e);
        }
    }

    public void addValueChangeListener(DateValueChangeListener theListener) {
        this.listeners.add(theListener);
    }

    public void removeValueChangeListener(DateValueChangeListener theListener) {
        this.listeners.remove(theListener);
    }

    private void updateHeaderLabel() {
        String monthName = GWCalendarUtils.monthNames[this.calendar.getModel().getDate().get(2)];
        int year = this.calendar.getModel().getDate().get(1);
        String text = PLAFChanger.isAsianLang() ? year + " " + monthName : monthName + ' ' + year;
        this.headerLabel.setText(text);
    }

    public void updateTodayField() {
        this.footerLabel.setText(StringResources.TODAY + ": " + OptionManager.getInstance().getDateTimeOptions().getGeneralDateString(GWCalendarUtils.getToday().getTime()));
    }

    private void handleKey(int theKeyCode, boolean isShiftDown) {
        this.calendar.handleKey(theKeyCode, isShiftDown, this.allowNavigation);
    }

    public Calendar getDate() {
        return this.calendar.getModel().getDate();
    }

    public void setDate(Calendar theNewDate) {
        this.calendar.getModel().setDate(theNewDate);
    }

    public void gotoToday() {
        this.calendar.gotoToday();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + DateAndTimeFormattingUtils.calendarToLogString(this.calendar.getModel().getDate()) + ']';
    }

    private class NavigationButton
    extends OrientableButton {
        public NavigationButton(Icon icon) {
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.setContentAreaFilled(false);
            this.setCursor(new Cursor(12));
            this.setIcon(icon);
        }
    }

    private class TodayMouserListener
    extends MouseAdapter {
        private TodayMouserListener() {
        }

        public void mouseClicked(MouseEvent e) {
            MonthlyCalendar c = MonthlyCalendar.this;
            if (!c.isFocusOwner()) {
                c.grabFocus();
            }
            c.gotoToday();
        }
    }

    private class NavigationAction
    extends AbstractAction {
        int shift;

        public NavigationAction(int theShift) {
            this.shift = theShift;
        }

        public void actionPerformed(ActionEvent e) {
            MonthlyCalendar c = MonthlyCalendar.this;
            if (!c.isFocusOwner()) {
                c.grabFocus();
            }
            c.calendar.navigate(this.shift, true);
        }
    }

    private class CalendarMouseListener
    extends MouseAdapter {
        private CalendarMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            MonthlyCalendar c = MonthlyCalendar.this;
            if (!c.isFocusOwner()) {
                c.grabFocus();
            }
            c.handleClick(e.getPoint(), e.isShiftDown(), OS.isDoubleClick(e));
        }
    }

    private class FocuseListener
    implements FocusListener {
        private FocuseListener() {
        }

        public void focusGained(FocusEvent e) {
            MonthlyCalendar.this.handleFocus(true);
        }

        public void focusLost(FocusEvent e) {
            MonthlyCalendar.this.handleFocus(false);
        }
    }

    private class KeyboardListener
    extends KeyAdapter {
        private KeyboardListener() {
        }

        public void keyPressed(KeyEvent e) {
            MonthlyCalendar.this.handleKey(e.getKeyCode(), e.isShiftDown());
        }
    }
}

