/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector;

import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DocumentChangeHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationFormat;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeEvent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeListener;
import com.novell.gw.jclient.application.controls.timepicker.MutableTextField;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class DurationTextField
extends GWTextField
implements MutableTextField {
    private static final Logger logger = Logger.getLogger(DurationTextField.class);
    private ArrayList listeners;
    private DurationFormat format;
    private DocumentChangeHandler documentHandler;
    private TimeDuration duration = new TimeDuration(0, 0);

    public DurationTextField(DurationFormat theFormat, DocumentChangeHandler theHandler) {
        this(theFormat, theHandler, new TimeDuration(0, 0));
    }

    public DurationTextField(DurationFormat theFormat, DocumentChangeHandler theHandler, TimeDuration theDuration) {
        if (theFormat == null) {
            throw new IllegalArgumentException("Date format can not be NULL");
        }
        if (theHandler == null) {
            throw new IllegalArgumentException("Document handler can not be NULL");
        }
        this.format = theFormat;
        this.documentHandler = theHandler;
        this.listeners = new ArrayList();
        this.setDocument(new TextDocument());
        this.addFocusListener(new CommitFocusListener());
        this.setDuration(theDuration);
    }

    public void setDuration(TimeDuration theDuration) {
        if (theDuration == null) {
            throw new IllegalArgumentException("Duration can not be NULL");
        }
        if (theDuration.getDuration() <= 0) {
            theDuration = new TimeDuration(theDuration.getStartMinutes(), theDuration.getStartMinutes() + this.documentHandler.getDefaultShift());
        }
        if (!this.duration.equals(theDuration)) {
            this.duration = theDuration;
            this.refreshText();
            this.fireDurationChanged(new DurationChangeEvent(this.duration, this));
        }
    }

    private void refreshText() {
        String text = this.format.format(this.duration);
        this.setText(text);
    }

    private void handleFocusLost() {
        this.commit();
    }

    public void commit() {
        String text = this.getText();
        try {
            TimeDuration newDuration = this.format.parse(this.duration.getStartMinutes(), text);
            this.setDuration(newDuration);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.refreshText();
    }

    protected boolean handleChange(String theText) {
        if (this.documentHandler.canHandle(theText)) {
            this.handleChange(this.documentHandler.getField(theText), this.documentHandler.getShift(theText));
            return true;
        }
        return false;
    }

    private void handleChange(int field, int shift) {
        this.unselectAll();
        this.commit();
        TimeDuration newDuration = new TimeDuration(this.duration.getStartMinutes(), this.duration.getEndMinutes() + shift);
        this.setDuration(newDuration);
        this.selectAll();
    }

    private void unselectAll() {
        this.setCaretPosition(0);
        this.moveCaretPosition(0);
    }

    public TimeDuration getDuration() {
        return this.duration;
    }

    private void fireDurationChanged(DurationChangeEvent e) {
        int nSize = this.listeners.size();
        for (int i = 0; i < nSize; ++i) {
            DurationChangeListener listener = (DurationChangeListener)this.listeners.get(i);
            listener.valueChanged(e);
        }
    }

    public void addDurationChangeListener(DurationChangeListener theListener) {
        this.listeners.add(theListener);
    }

    public void removeDurationChangeListener(DurationChangeListener theListener) {
        this.listeners.remove(theListener);
    }

    private class TextDocument
    extends PlainDocument {
        private TextDocument() {
        }

        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (!DurationTextField.this.handleChange(text)) {
                super.replace(offset, length, text, attrs);
            }
        }
    }

    private class CommitFocusListener
    implements FocusListener {
        private CommitFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            DurationTextField.this.handleFocusLost();
        }
    }
}

