/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.itemedit;

import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.mvc.MVCController;
import com.appframework.utils.Utils;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.folder.FolderSharedEntry;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.ab.IResourceContact;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionShowAppointmentAs;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.contactsearch.RecipientListChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTimeDocumentHandler;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DurationTimeFormat;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.ExtendedDateTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.RecuringDateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.SingleDateSelector;
import com.novell.gw.jclient.application.controls.gwcomponent.GWPopupMenu;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.itemedit.AppointmentEditPanelModel;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.FromComponent;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanelController;
import com.novell.gw.jclient.application.controls.itemedit.RecurringItemEditPanel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.textcomponent.EditableTextComponent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeEvent;
import com.novell.gw.jclient.application.controls.timepicker.DurationChangeListener;
import com.novell.gw.jclient.application.controls.timepicker.TimeDurationSelector;
import com.novell.gw.jclient.application.controls.timepicker.TimePicker;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.TimeDuration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppointmentEditPanel
extends RecurringItemEditPanel<AppointmentEditPanelModel> {
    private static Logger logger = Logger.getLogger(AppointmentEditPanel.class);
    private JPanel pnlStartDate;
    private TimeDurationSelector dsStartDurationSelector;
    private TimeDurationSelector dsEndDurationSelector;
    private JPanel pnlEndDate;
    private JLabel lbDuration;
    private DurationTextField tfDuration;
    private SingleDateSelector dsEndDate;
    private JCheckBox cbAllDayEvent;
    private JLabel lbPlace;
    private LocationTextField tfLocation;
    private EditableTextComponent etcLocation;
    private ListButton cbxShowAs;
    private JMenu mnuShowAppointmentAs = null;
    private boolean showAsChangedByUser;
    private boolean isShowDuration;
    private boolean settingItem = false;

    public AppointmentEditPanel(MVCController theParentController, ComposeMode composeMode, boolean isModify) {
        super(theParentController, "ATTACHLIST_SPLITPOS_APPOINTMENT_EDIT", composeMode, isModify);
        if (isModify) {
            this.showAsChangedByUser = true;
        }
        this.focusTraversalPolicy = new AppointmentFocusPolicy();
    }

    @Override
    protected ItemEditPanelController createController(MVCController parentController) {
        return new ItemEditPanelController<AppointmentEditPanel>(this, parentController);
    }

    @Override
    protected AppointmentEditPanelModel createModel() {
        return new AppointmentEditPanelModel();
    }

    @Override
    public AbstractItem getGWItemComposition() {
        if (this.tfDuration.isFocusOwner()) {
            this.tfDuration.commit();
        }
        if (((Component)this.dsEndDate.getTextComponent()).isFocusOwner()) {
            ((DateTextField)this.dsEndDate.getTextComponent()).commit();
        }
        AppointmentItem appointment = (AppointmentItem)this.newItem;
        appointment.setLocation(this.tfLocation.getText());
        appointment.setSubject(this.tfSubject.getText());
        appointment.setAllDayEvent(((AppointmentEditPanelModel)this.model).isAllDayEvent());
        appointment.setShowAsLevel(this.getShowAsLevel(), false);
        Date[] dates = GWCalendarUtils.CalendarToDate((Calendar[])Utils.castArray(((AppointmentEditPanelModel)this.model).getStartDates(), Calendar[].class));
        appointment.setStartDates(dates);
        appointment.setEndDate(dates[0]);
        TimeDuration duration = ((AppointmentEditPanelModel)this.model).getDuration();
        appointment.changeTimeStart(duration.getStartMinutes());
        appointment.changeTimeEnd(duration.getEndMinutes());
        return super.getGWItemComposition();
    }

    @Override
    public void setGWItemComposition(AbstractItem theNewItem) {
        super.setGWItemComposition(theNewItem);
        AppointmentItem appointmentItem = (AppointmentItem)this.newItem;
        this.setShowAsLevel(appointmentItem.getShowAsLevel());
        this.tfCC.setRecipients(appointmentItem.getCcRecipients());
        this.tfTo.setRecipients(appointmentItem.getToRecipients());
        this.tfBC.setRecipients(appointmentItem.getBcRecipients());
        String location = appointmentItem.getLocation();
        if (location != null && !location.equals("")) {
            this.tfLocation.setText(location);
            this.tfLocation.setManuallyModified(true);
        }
        this.tfSubject.setText(appointmentItem.getSubject());
        this.getController().getActionList().getAction(ActionKey.SET_ALL_DAY_EVENT).setSelected(appointmentItem.isAllDayEvent());
        ((AppointmentEditPanelModel)this.model).setData(appointmentItem.isAllDayEvent(), GWCalendarUtils.DateToCalendar(appointmentItem.getStartDates()), appointmentItem.getEndGregorianCalendar());
        logger.debug((Object)"setting item...");
        this.settingItem = true;
        this.syncWithModel();
        this.settingItem = false;
        logger.debug((Object)"...item set");
    }

    @Override
    protected void syncComponentsWithModel() {
        logger.debug((Object)"updating components...");
        logger.debug((Object)("model: " + this.model));
        Calendar endDate = ((AppointmentEditPanelModel)this.model).getEndDate();
        logger.debug((Object)("endDate: " + endDate.getTime()));
        if (((AppointmentEditPanelModel)this.model).isAllDayEvent()) {
            endDate.add(6, -1);
            logger.debug((Object)("ADE - endDate value corrected: " + endDate.getTime()));
        }
        if (this.settingItem) {
            this.rsStartDate.setDates((Calendar[])Utils.castArray(((AppointmentEditPanelModel)this.model).getStartDates(), Calendar[].class));
            this.dsEndDate.setDate(endDate);
            this.dsStartDurationSelector.setDuration(((AppointmentEditPanelModel)this.model).getDuration());
            this.dsEndDurationSelector.setDuration(((AppointmentEditPanelModel)this.model).getDuration());
            this.tfDuration.setDuration(((AppointmentEditPanelModel)this.model).getDuration());
            return;
        }
        Object[] startDates = (Calendar[])Utils.castArray(((AppointmentEditPanelModel)this.model).getStartDates(), Calendar[].class);
        logger.debug((Object)("startDates[0]: " + this.rsStartDate.getDates()[0].getTime() + " >>> " + startDates[0].getTime()));
        if (!Arrays.equals(startDates, this.rsStartDate.getDates())) {
            logger.debug((Object)"updating startDates");
            this.rsStartDate.setDates((Calendar[])startDates);
        }
        logger.debug((Object)("endDate: " + this.dsEndDate.getDate().getTime() + " >>> " + endDate.getTime()));
        if (!endDate.equals(this.dsEndDate.getDate())) {
            logger.debug((Object)("updating endDate to: " + endDate.getTime()));
            this.dsEndDate.setDate(endDate);
        }
        TimeDuration duration = ((AppointmentEditPanelModel)this.model).getDuration();
        if (!this.dsStartDurationSelector.getDuration().equals(duration)) {
            logger.debug((Object)("updating duration to: " + duration));
            this.dsStartDurationSelector.setDuration(duration);
        }
        if (!this.dsEndDurationSelector.getDuration().equals(((AppointmentEditPanelModel)this.model).getDuration())) {
            logger.debug((Object)("updating end time selector to duration: " + ((AppointmentEditPanelModel)this.model).getDuration()));
            this.dsEndDurationSelector.setDuration(((AppointmentEditPanelModel)this.model).getDuration());
        }
        if (!this.tfDuration.getDuration().equals(((AppointmentEditPanelModel)this.model).getDuration())) {
            logger.debug((Object)("updating end time selector to duration: " + ((AppointmentEditPanelModel)this.model).getDuration()));
            this.tfDuration.setDuration(((AppointmentEditPanelModel)this.model).getDuration());
        }
        logger.debug((Object)"... components updated");
    }

    @Override
    protected void syncPanelWithModel() {
        this.refreshStartDateLabel();
        this.rebuildStartDatePanel();
        this.rebuildEndDatePanel();
        if (!this.showAsChangedByUser) {
            AppointmentAcceptLevel level = ((AppointmentEditPanelModel)this.model).isAllDayEvent() ? AppointmentAcceptLevel.FREE : AppointmentAcceptLevel.BUSY;
            this.setShowAsLevel(level);
        }
    }

    private AppointmentAcceptLevel getShowAsLevel() {
        String txt = this.cbxShowAs.getText();
        AppointmentAcceptLevel res = AppointmentAcceptLevel.BUSY;
        if (txt.equals(StringResources.BUSY)) {
            res = AppointmentAcceptLevel.BUSY;
        } else if (txt.equals(StringResources.FREE)) {
            res = AppointmentAcceptLevel.FREE;
        } else if (txt.equals(StringResources.TENTATIVE)) {
            res = AppointmentAcceptLevel.TENTATIVE;
        } else if (txt.equals(StringResources.OUT_OF_OFFICE)) {
            res = AppointmentAcceptLevel.OUT_OF_OFFICE;
        }
        return res;
    }

    private void setShowAsLevel(AppointmentAcceptLevel showAsLevel) {
        JMenu mnuActions;
        JFrame frame;
        String txt = StringResources.BUSY;
        switch (showAsLevel) {
            case BUSY: {
                txt = StringResources.BUSY;
                break;
            }
            case FREE: {
                txt = StringResources.FREE;
                break;
            }
            case TENTATIVE: {
                txt = StringResources.TENTATIVE;
                break;
            }
            case OUT_OF_OFFICE: {
                txt = StringResources.OUT_OF_OFFICE;
            }
        }
        this.cbxShowAs.setText(txt);
        JRadioButtonMenuItem item = AppointmentEditPanel.getMenuItem(this.cbxShowAs.getPopupMenu(), txt);
        if (item != null) {
            item.setSelected(true);
        }
        if (this.mnuShowAppointmentAs == null && (frame = AppointmentEditPanel.getParentFrame(this)) != null && (mnuActions = AppointmentEditPanel.getActionsMenu(frame.getJMenuBar())) != null) {
            this.mnuShowAppointmentAs = this.getShowAppointmentAs(mnuActions);
        }
        if (this.mnuShowAppointmentAs != null && (item = AppointmentEditPanel.getMenuItem(this.mnuShowAppointmentAs.getPopupMenu(), txt)) != null) {
            item.setSelected(true);
        }
    }

    public void handle_ACTION_BUSYSEARCH_PERFORMED(AppEvent theEvent) {
        GWBusySearch busySearch = (GWBusySearch)theEvent.getData();
        this.tfTo.clear();
        this.tfTo.setRecipients(busySearch.getRecipientDescriptionsList().getSelectedRecipients(RecipientCopyType.getTo()));
        this.tfCC.clear();
        this.tfCC.setRecipients(busySearch.getRecipientDescriptionsList().getSelectedRecipients(RecipientCopyType.getCc()));
        this.tfBC.clear();
        this.tfBC.setRecipients(busySearch.getRecipientDescriptionsList().getSelectedRecipients(RecipientCopyType.getBc()));
        AppointmentItem compos = (AppointmentItem)this.newItem;
        compos.setStartDates(new Date[]{busySearch.getAppointmentTime().getStartDateAsDate()});
        compos.setEndDate(busySearch.getAppointmentTime().getEndDateAsDate());
        ((AppointmentEditPanelModel)this.model).setAllDayEvent(false);
        ((AppointmentEditPanelModel)this.model).setData(compos.isAllDayEvent(), GWCalendarUtils.DateToCalendar(compos.getStartDates()), compos.getEndGregorianCalendar());
        this.syncWithModel();
        logger.debug((Object)"busy search finished!");
    }

    @Override
    protected boolean handle_ACTION_SET_ALL_DAY_EVENT(boolean isSelected) {
        ((AppointmentEditPanelModel)this.model).setAllDayEvent(isSelected);
        this.syncWithModel();
        return true;
    }

    @Override
    public void valueChanged(RecuringDateChangeEvent event) {
        logger.debug((Object)("event: " + event));
        if (event.isRecuring()) {
            ((AppointmentEditPanelModel)this.model).setStartDates(event.getDates());
        } else {
            ((AppointmentEditPanelModel)this.model).setStartDate(event.getDates()[0]);
        }
        super.valueChanged(event);
    }

    @Override
    protected void build() {
        super.build();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.isShowDuration = (Integer)dataStoreSettings.getAppointmentEventMode().getValue() == 0;
        this.contentPanel.setLayout(new BorderLayout());
        this.tfLocation = new LocationTextField();
        this.tfLocation.setName("AppointmentEditPanel_tfLocation");
        this.tfTo.addRecipientListChangeListener(new RecipientListChangeListener(){

            @Override
            public void recipientListChanged(List<? extends IRecipient> recipientList) {
                if (!AppointmentEditPanel.this.tfLocation.isManuallyModified() && recipientList != null) {
                    String place = AppointmentEditPanel.this.tfLocation.getText().trim();
                    ArrayList<IResourceContact> resourceContactList = new ArrayList<IResourceContact>();
                    for (IRecipient iRecipient : recipientList) {
                        IAddressable addressable = iRecipient.getAddressable();
                        if (!(addressable instanceof IResourceContact)) continue;
                        if (place.equals(addressable.getDisplayName())) {
                            return;
                        }
                        resourceContactList.add((IResourceContact)addressable);
                    }
                    if (!resourceContactList.isEmpty()) {
                        AppointmentEditPanel.this.tfLocation.setText(((IResourceContact)resourceContactList.get(0)).getDisplayName() + ' ');
                    } else {
                        AppointmentEditPanel.this.tfLocation.setText("");
                    }
                }
            }
        });
        this.etcLocation = this.createEditableTextComponent(this.tfLocation);
        this.cbAllDayEvent = (JCheckBox)this.getController().getActionList().getAction(ActionKey.SET_ALL_DAY_EVENT).getToolBarComponent();
        this.pnlStartDate = new OrientablePanel();
        this.rsStartDate = new RecuringDateSelector();
        ((ExtendedDateTextField)this.rsStartDate.getTextComponent()).setName("AppointmentEditPanel_rsStartDate_dateField");
        this.rsStartDate.addRecuringDateChangeListener(this);
        this.dsStartDurationSelector = new TimeDurationSelector();
        this.dsStartDurationSelector.setDisplayTimeMode(TimePicker.DisplayTimeMode.START);
        this.dsEndDurationSelector = new TimeDurationSelector();
        this.dsEndDurationSelector.getTextComponent().setName("AppointmentEditPanel_dsEndDurationSelector_startTimeField");
        this.dsEndDurationSelector.setDisplayTimeMode(TimePicker.DisplayTimeMode.END);
        this.pnlEndDate = new OrientablePanel();
        this.tfDuration = new DurationTextField(new DurationTimeFormat(), new DurationTimeDocumentHandler());
        this.tfDuration.setName("AppointmentEditPanel_tfDuration");
        this.dsEndDate = new SingleDateSelector();
        this.dsEndDate.addDateChangeListener(new DateValueChangeListener(){

            public void valueChanged(DateChangeEvent e) {
                Calendar date = (Calendar)e.getDate().clone();
                logger.debug((Object)("updating end date to: " + date.getTime()));
                if (((AppointmentEditPanelModel)AppointmentEditPanel.this.model).isAllDayEvent()) {
                    date.add(6, 1);
                    logger.debug((Object)("ADE, end date updated to: " + date.getTime()));
                }
                ((AppointmentEditPanelModel)AppointmentEditPanel.this.model).setEndDate(date);
                AppointmentEditPanel.this.syncWithModel();
            }
        });
        this.cbxShowAs = new ListButton();
        this.cbxShowAs.setPopupActions(new AppAction[]{this.getController().getActionList().getAction(ActionKey.SHOW_AS_FREE), this.getController().getActionList().getAction(ActionKey.SHOW_AS_TENTATIVE), this.getController().getActionList().getAction(ActionKey.SHOW_AS_BUSY), this.getController().getActionList().getAction(ActionKey.SHOW_AS_OUT_OF_OFFICE)});
        AppointmentDurationChangeListener durationChangeListener = new AppointmentDurationChangeListener();
        this.tfDuration.addDurationChangeListener(durationChangeListener);
        this.dsStartDurationSelector.addDurationChangeListener(durationChangeListener);
        this.dsEndDurationSelector.addDurationChangeListener(durationChangeListener);
        this.compFrom = new FromComponent(this);
        this.lbTo = new JMnemonicLabel(StringResources.TO_C, this.tfTo);
        this.lbCC = new JMnemonicLabel(StringResources.CC_C, this.tfCC);
        this.lbBC = new JMnemonicLabel(StringResources.BC_C, this.tfBC);
        this.lbPlace = new JMnemonicLabel(StringResources.PLACE_C, this.tfLocation);
        this.lbStartDate = new JMnemonicLabel();
        this.lbDuration = new JMnemonicLabel();
        this.lbSubject = new JMnemonicLabel(StringResources.SUBJECT_C, this.tfSubject);
        OrientablePanel messagePanel = new OrientablePanel(new BorderLayout());
        messagePanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        messagePanel.add((Component)this.messageEditor, "Center");
        OrientablePanel attachmentsPanel = new OrientablePanel(new BorderLayout());
        attachmentsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        attachmentsPanel.add((Component)this.attachmentList, "Center");
        this.messageSplit.setBottomComponent(attachmentsPanel);
        this.messageSplit.setTopComponent(messagePanel);
        this.rebuildStartDatePanel();
        this.rebuildEndDatePanel();
        this.createAddressPane();
        this.contentPanel.add((Component)this.addressPane, "North");
        this.contentPanel.add((Component)this.messageSplit, "Center");
    }

    public void initShowAsHandler(JFrame parentFrame) {
        JMenu mnuActions = AppointmentEditPanel.getActionsMenu(parentFrame.getJMenuBar());
        if (mnuActions != null) {
            this.mnuShowAppointmentAs = this.getShowAppointmentAs(mnuActions);
            if (this.mnuShowAppointmentAs != null) {
                FixShowAsActionListener l = new FixShowAsActionListener();
                int n = this.mnuShowAppointmentAs.getItemCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem item = this.mnuShowAppointmentAs.getItem(i);
                    item.addActionListener(l);
                }
            }
        }
    }

    @Override
    public void switchToPostedMode() {
        super.switchToPostedMode();
        this.addressPane.removeAll();
        TitleValueContainer container = new TitleValueContainer(this.addressPane);
        container.getInsets().bottom = 8;
        container.getInsets().top = 0;
        container.buildRow(this.compFrom, this.tfFrom, 0);
        container.buildRow(this.lbSubject, this.tfSubject, 1);
        container.buildRow(this.lbPlace, this.buildLocationPane(), 2);
        container.buildRow(this.lbStartDate, this.pnlStartDate, 3);
        container.buildRow(this.lbDuration, this.pnlEndDate, 4);
    }

    private void createAddressPane() {
        this.addressPane = new OrientablePanel(new GridBagLayout());
        this.addressPane.setBorder(new EmptyBorder(10, 10, 0, 10));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 8, 10);
        this.addressPane.add((Component)this.compFrom, c);
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 8, 0);
        c.weightx = 1.0;
        this.addressPane.add((Component)this.tfFrom, c);
        c.gridx = 2;
        c.insets = new Insets(0, 15, 8, 25);
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbCC, c);
        c.insets = new Insets(0, 0, 8, 0);
        c.gridx = 3;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcCC, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.gridx = 0;
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbTo, c);
        c.insets = new Insets(0, 0, 8, 0);
        c.fill = 1;
        c.gridx = 1;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcTo, c);
        c.insets = new Insets(0, 15, 8, 25);
        c.gridx = 2;
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbBC, c);
        c.insets = new Insets(0, 0, 8, 0);
        c.gridx = 3;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.etcBC, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.weightx = 0.0;
        c.gridx = 0;
        this.addressPane.add((Component)this.lbPlace, c);
        c.insets = new Insets(0, 0, 8, 0);
        c.fill = 2;
        c.gridwidth = 0;
        c.gridx = 1;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.buildLocationPane(), c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbStartDate, c);
        c.fill = 2;
        c.insets = new Insets(0, 0, 8, 0);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.addressPane.add((Component)this.pnlStartDate, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.insets = new Insets(0, 0, 8, 10);
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.addressPane.add((Component)this.lbDuration, c);
        c.fill = 2;
        c.insets = new Insets(0, 0, 8, 0);
        c.gridwidth = 0;
        c.gridx = 1;
        this.addressPane.add((Component)this.pnlEndDate, c);
        ++c.gridy;
        c.anchor = 21;
        c.fill = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.addressPane.add((Component)this.lbSubject, c);
        c.fill = 2;
        c.gridwidth = 0;
        c.gridx = 1;
        c.insets = new Insets(0, 0, 0, 0);
        EditableTextComponent etcSubject = this.createEditableTextComponent(this.tfSubject);
        this.addressPane.add((Component)etcSubject, c);
    }

    private void rebuildStartDatePanel() {
        logger.debug((Object)("isAllDayEventsMode: " + ((AppointmentEditPanelModel)this.model).isAllDayEvent()));
        this.pnlStartDate.removeAll();
        this.pnlStartDate.setLayout(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.fill = 2;
        cs.gridy = 0;
        cs.insets = new Insets(0, 0, 0, 0);
        cs.weightx = 1.0;
        cs.gridx = 0;
        this.pnlStartDate.add((Component)this.rsStartDate, cs);
        if (!((AppointmentEditPanelModel)this.model).isAllDayEvent()) {
            cs.insets = new Insets(0, 5, 0, 0);
            cs.weightx = 0.0;
            cs.gridx = 1;
            cs.ipadx = 10;
            this.pnlStartDate.add((Component)this.dsStartDurationSelector, cs);
            cs.insets = new Insets(0, 5, 0, 0);
            cs.weightx = 0.0;
            cs.gridx = 2;
            this.pnlStartDate.add((Component)this.cbAllDayEvent, cs);
            this.refreshStartDateLabel();
            this.lbStartDate.setLabelFor(this.dsStartDurationSelector);
        } else {
            cs.insets = new Insets(0, 5, 0, 0);
            cs.weightx = 0.0;
            cs.gridx = 1;
            this.pnlStartDate.add((Component)this.cbAllDayEvent, cs);
            this.refreshStartDateLabel();
            this.lbStartDate.setLabelFor(this.rsStartDate);
        }
    }

    private void refreshStartDateLabel() {
        if (((AppointmentEditPanelModel)this.model).isRecurring()) {
            this.lbStartDate.setText(StringResources.AUTO_DATE_C);
        } else {
            this.lbStartDate.setText(StringResources.START_DATE_C);
        }
    }

    public void setAccessRights(FolderSharedEntry sharedEntry, boolean itemExists) {
        boolean hasEditAccess = sharedEntry.getAccessRights().hasEditAccess();
        if (itemExists) {
            this.tfSubject.setEditable(hasEditAccess);
            this.messageEditor.setEditable(hasEditAccess);
            this.tfDuration.setEditable(hasEditAccess);
            ((ExtendedDateTextField)this.rsStartDate.getTextComponent()).setEditable(hasEditAccess);
            this.tfLocation.setEditable(hasEditAccess);
        }
    }

    private void rebuildEndDatePanel() {
        this.pnlEndDate.removeAll();
        this.pnlEndDate.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.weightx = 1.0;
        constraints.insets.right = 5;
        constraints.gridx = 0;
        if (((AppointmentEditPanelModel)this.model).isAllDayEvent()) {
            if (((AppointmentEditPanelModel)this.model).isRecurring()) {
                this.pnlEndDate.add((Component)this.tfDuration, constraints);
                ((AppointmentEditPanelModel)this.model).setDurationFreezed(true);
            } else {
                this.pnlEndDate.add((Component)this.dsEndDate, constraints);
                ((AppointmentEditPanelModel)this.model).setDurationFreezed(false);
            }
        } else {
            if (((AppointmentEditPanelModel)this.model).isRecurring() || this.isShowDuration) {
                this.pnlEndDate.add((Component)this.tfDuration, constraints);
                ((AppointmentEditPanelModel)this.model).setDurationFreezed(true);
            } else {
                this.pnlEndDate.add((Component)this.dsEndDate, constraints);
                ((AppointmentEditPanelModel)this.model).setDurationFreezed(false);
            }
            ++constraints.gridx;
            constraints.weightx = 0.0;
            this.pnlEndDate.add((Component)this.dsEndDurationSelector, constraints);
        }
        if (this.pnlEndDate.getComponent(0) == this.dsEndDate) {
            this.lbDuration.setText(StringResources.END_DATE_C);
            this.lbDuration.setLabelFor(this.dsEndDate);
        } else if (this.pnlEndDate.getComponent(0) == this.tfDuration) {
            this.lbDuration.setText(StringResources.DURATION_C);
            this.lbDuration.setLabelFor(this.tfDuration);
        } else assert (false);
        ++constraints.gridx;
        constraints.anchor = 10;
        constraints.weightx = 0.0;
        this.pnlEndDate.add((Component)this.cbxShowAs, constraints);
    }

    private JPanel buildLocationPane() {
        OrientablePanel pnlPlace = new OrientablePanel(new BorderLayout());
        pnlPlace.add((Component)this.etcLocation, "Center");
        return pnlPlace;
    }

    private void fixShowAsValue(JRadioButtonMenuItem src) {
        String txt = src.getText();
        this.cbxShowAs.setText(txt);
        AppointmentEditPanel.fixPopup(this.cbxShowAs.getPopupMenu(), src);
    }

    private void setShowAsValue(JRadioButtonMenuItem item, ActionEvent e) {
        JMenu menuShowAs;
        JMenu menuActions;
        this.showAsChangedByUser = true;
        String val = this.cbxShowAs.getText();
        ActionShowAppointmentAs action = null;
        if (val.equalsIgnoreCase(StringResources.BUSY)) {
            action = (ActionShowAppointmentAs)this.getController().getActionList().getAction(ActionKey.SHOW_AS_BUSY);
        } else if (val.equalsIgnoreCase(StringResources.FREE)) {
            action = (ActionShowAppointmentAs)this.getController().getActionList().getAction(ActionKey.SHOW_AS_FREE);
        } else if (val.equalsIgnoreCase(StringResources.OUT_OF_OFFICE)) {
            action = (ActionShowAppointmentAs)this.getController().getActionList().getAction(ActionKey.SHOW_AS_OUT_OF_OFFICE);
        } else if (val.equalsIgnoreCase(StringResources.TENTATIVE)) {
            action = (ActionShowAppointmentAs)this.getController().getActionList().getAction(ActionKey.SHOW_AS_TENTATIVE);
        }
        if (action != null) {
            AppointmentItem appointment = (AppointmentItem)this.newItem;
            appointment.setShowAsLevel(action.getAcceptLevel(), false);
            action.setSelected(true);
        }
        if ((menuActions = AppointmentEditPanel.getActionsMenu(AppointmentEditPanel.getParentFrame(this).getJMenuBar())) != null && (menuShowAs = this.getShowAppointmentAs(menuActions)) != null) {
            AppointmentEditPanel.fixPopup(menuShowAs.getPopupMenu(), item);
        }
    }

    private static void fixPopup(JPopupMenu menuShowAs, JRadioButtonMenuItem item) {
        int n = menuShowAs.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)menuShowAs.getComponent(i);
            if (!menuItem.getAction().equals(item.getAction())) continue;
            menuItem.setSelected(true);
            break;
        }
    }

    private JMenu getShowAppointmentAs(JMenu menuActions) {
        if (this.mnuShowAppointmentAs != null) {
            return this.mnuShowAppointmentAs;
        }
        JMenu res = null;
        if (menuActions != null) {
            int n = menuActions.getItemCount();
            for (int i = 0; i < n; ++i) {
                JMenuItem item = menuActions.getItem(i);
                if (item == null || !item.getText().equals(StringResources.MENU_SHOW_APPOINTMENT_AS)) continue;
                res = (JMenu)item;
                break;
            }
        }
        return res;
    }

    private static JMenu getActionsMenu(JMenuBar bar) {
        JMenu res = null;
        if (bar != null) {
            int n = bar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JMenu menu = bar.getMenu(i);
                if (!menu.getText().equals(StringResources.ACTIONS)) continue;
                res = menu;
                break;
            }
        }
        return res;
    }

    public static JRadioButtonMenuItem getMenuItem(JPopupMenu popup, String txt) {
        JRadioButtonMenuItem res = null;
        if (txt != null) {
            int n = popup.getComponentCount();
            for (int i = 0; i < n; ++i) {
                JRadioButtonMenuItem item = (JRadioButtonMenuItem)popup.getComponent(i);
                if (!txt.equals(item.getText())) continue;
                res = item;
                break;
            }
        }
        return res;
    }

    private class LocationTextField
    extends GWTextField
    implements KeyListener {
        private boolean isManuallyModified = false;

        private LocationTextField() {
            this.addKeyListener(this);
        }

        public boolean isManuallyModified() {
            return this.isManuallyModified;
        }

        public void setManuallyModified(boolean manuallyModified) {
            this.isManuallyModified = manuallyModified;
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            this.isManuallyModified = true;
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class AppointmentDurationChangeListener
    implements DurationChangeListener {
        private AppointmentDurationChangeListener() {
        }

        public void valueChanged(DurationChangeEvent e) {
            if (!AppointmentEditPanel.this.syncingWithModel) {
                logger.debug((Object)("updating duration to: " + e.getDuration()));
                logger.debug((Object)("isStartDateDecremented(): " + e.isStartDateDecremented()));
                if (e.isStartDateDecremented()) {
                    ((AppointmentEditPanelModel)AppointmentEditPanel.this.model).changeStartDate(-1);
                }
                if (e.isStartDateIncremented() && !((AppointmentEditPanelModel)AppointmentEditPanel.this.model).isRecurring()) {
                    ((AppointmentEditPanelModel)AppointmentEditPanel.this.model).changeStartDate(1);
                }
                ((AppointmentEditPanelModel)AppointmentEditPanel.this.model).setDuration(e.getDuration());
                AppointmentEditPanel.this.syncWithModel();
            }
        }
    }

    private class ListButton
    extends OrientableButton {
        private JPopupMenu popupMenu = new GWPopupMenu();

        public ListButton() {
            this.initUI();
        }

        private void initUI() {
            this.setIcon(ImageResources.ADV_FILTER_UP_DOWN);
            this.setHorizontalTextPosition(10);
            this.addActionListener(new ShowPopupAction());
        }

        public JPopupMenu getPopupMenu() {
            return this.popupMenu;
        }

        public void setPopupActions(AppAction[] arr) {
            if (arr != null) {
                this.popupMenu.removeAll();
                ButtonGroup bg = new ButtonGroup();
                String firstItem = "";
                int n = arr.length;
                for (int i = 0; i < n; ++i) {
                    JMenuItem item = arr[i].getMenuItem();
                    this.popupMenu.add(item);
                    item.addActionListener(new FixSelectionAction(item.getText()));
                    if (i == 0) {
                        firstItem = item.getText();
                        item.setSelected(true);
                    }
                    bg.add(item);
                }
                this.setText(firstItem);
            }
        }

        public void setPopup(JPopupMenu popup) {
            if (popup != null) {
                this.popupMenu = popup;
                String firstItem = "";
                int n = popup.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    JMenuItem item = (JMenuItem)this.popupMenu.getComponent(i);
                    item.addActionListener(new FixSelectionAction(item.getText()));
                    if (i != 0) continue;
                    firstItem = item.getText();
                }
                this.setText(firstItem);
            }
        }

        private class FixSelectionAction
        implements ActionListener {
            private String label = "[menu item]";

            public FixSelectionAction(String label) {
                this.label = label;
            }

            public void actionPerformed(ActionEvent e) {
                JRadioButtonMenuItem src = (JRadioButtonMenuItem)e.getSource();
                ListButton.this.setText(this.label);
                src.setSelected(true);
                AppointmentEditPanel.this.setShowAsValue(src, e);
            }
        }

        private class ShowPopupAction
        implements ActionListener {
            private ShowPopupAction() {
            }

            public void actionPerformed(ActionEvent e) {
                ListButton.this.popupMenu.show(ListButton.this, 0, 0);
            }
        }
    }

    private class AppointmentFocusPolicy
    extends ItemEditPanel.ItemComposerTraversalPolicy {
        private AppointmentFocusPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component component) {
            AppointmentEditPanel view = AppointmentEditPanel.this;
            Component focusOwner = FocusManager.getCurrentManager().getPermanentFocusOwner();
            if (!component.hasFocus()) {
                return focusOwner;
            }
            if (component.equals(view.tfTo) || component.equals(view.tfTo.getRecipientList())) {
                return view.tfLocation;
            }
            if (component.equals(view.tfSubject) && !this.isPostedCompose || component.equals(view.cbxShowAs) && this.isPostedCompose) {
                return view.messageEditor.getComponent();
            }
            if (component.equals(AppointmentEditPanel.this.messageEditor.getComponent())) {
                return view.attachmentList.getListContent();
            }
            if (component.equals(view.tfCC) || component.equals(view.tfCC.getRecipientList())) {
                return view.tfBC;
            }
            if (component.equals(view.tfBC) || component.equals(view.tfBC.getRecipientList())) {
                return view.tfTo;
            }
            return super.getComponentAfter(focusCycleRoot, component);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            AppointmentEditPanel view = AppointmentEditPanel.this;
            if (aComponent.equals(view.tfTo)) {
                return view.tfBC;
            }
            if (aComponent.equals(view.tfBC)) {
                return view.tfCC;
            }
            if (this.isPostedCompose && aComponent.equals(view.tfSubject)) {
                return view.attachmentList.getListContent();
            }
            if (!this.isPostedCompose && aComponent.equals(view.tfLocation)) {
                return view.tfTo;
            }
            if (ControlsUtils.isComponentInContainer(view.attachmentList, aComponent)) {
                return view.messageEditor.getComponent();
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }

        public Component getDefaultComponent(Container focusCycleRoot) {
            return AppointmentEditPanel.this.getComponentForFocus();
        }
    }

    private class FixShowAsActionListener
    implements ActionListener {
        private FixShowAsActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JRadioButtonMenuItem src = (JRadioButtonMenuItem)e.getSource();
            AppointmentEditPanel.this.fixShowAsValue(src);
        }
    }
}

